/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.Iterator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;

public class LSMBTreeRangeSearchCursor
extends LSMIndexSearchCursor {
    private final ArrayTupleReference copyTuple = new ArrayTupleReference();
    private final RangePredicate reusablePred = new RangePredicate(null, null, true, true, null, null);
    private ISearchOperationCallback searchCallback;
    private RangePredicate predicate;
    private BTree.BTreeAccessor[] btreeAccessors;
    private ArrayTupleBuilder tupleBuilder;
    private boolean proceed = true;

    public LSMBTreeRangeSearchCursor(ILSMIndexOperationContext opCtx) {
        this(opCtx, false);
    }

    public LSMBTreeRangeSearchCursor(ILSMIndexOperationContext opCtx, boolean returnDeletedTuples) {
        super(opCtx, returnDeletedTuples);
    }

    public void reset() throws HyracksDataException, IndexException {
        super.reset();
        this.proceed = true;
    }

    public void next() throws HyracksDataException {
        this.outputElement = (LSMIndexSearchCursor.PriorityQueueElement)this.outputPriorityQueue.poll();
        this.needPush = true;
        this.proceed = false;
    }

    protected void checkPriorityQueue() throws HyracksDataException, IndexException {
        while (!this.outputPriorityQueue.isEmpty() || this.needPush) {
            if (!this.outputPriorityQueue.isEmpty()) {
                LSMIndexSearchCursor.PriorityQueueElement checkElement = (LSMIndexSearchCursor.PriorityQueueElement)this.outputPriorityQueue.peek();
                if (this.proceed && !this.searchCallback.proceed(checkElement.getTuple())) {
                    if (this.includeMutableComponent) {
                        LSMIndexSearchCursor.PriorityQueueElement mutableElement = null;
                        boolean mutableElementFound = false;
                        Iterator it = this.outputPriorityQueue.iterator();
                        while (it.hasNext()) {
                            mutableElement = (LSMIndexSearchCursor.PriorityQueueElement)it.next();
                            if (mutableElement.getCursorIndex() != 0) continue;
                            mutableElementFound = true;
                            it.remove();
                            break;
                        }
                        if (mutableElementFound) {
                            if (this.tupleBuilder == null) {
                                this.tupleBuilder = new ArrayTupleBuilder(this.cmp.getKeyFieldCount());
                            }
                            TupleUtils.copyTuple((ArrayTupleBuilder)this.tupleBuilder, (ITupleReference)mutableElement.getTuple(), (int)this.cmp.getKeyFieldCount());
                            this.copyTuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
                            this.rangeCursors[0].reset();
                            if (checkElement.getCursorIndex() == 0) {
                                this.searchCallback.reconcile((ITupleReference)this.copyTuple);
                            } else {
                                this.searchCallback.reconcile(checkElement.getTuple());
                                this.searchCallback.complete(checkElement.getTuple());
                            }
                            this.reusablePred.setLowKey((ITupleReference)this.copyTuple, true);
                            this.btreeAccessors[0].search(this.rangeCursors[0], (ISearchPredicate)this.reusablePred);
                            boolean isNotExhaustedCursor = this.pushIntoPriorityQueue(mutableElement);
                            if (checkElement.getCursorIndex() == 0) {
                                if (!isNotExhaustedCursor || this.cmp.compare((ITupleReference)this.copyTuple, mutableElement.getTuple()) != 0) {
                                    this.searchCallback.complete((ITupleReference)this.copyTuple);
                                    this.searchCallback.cancel((ITupleReference)this.copyTuple);
                                    continue;
                                }
                                this.searchCallback.complete((ITupleReference)this.copyTuple);
                            }
                        } else {
                            this.searchCallback.reconcile(checkElement.getTuple());
                        }
                    } else {
                        this.searchCallback.reconcile(checkElement.getTuple());
                    }
                }
                if (this.outputElement == null) {
                    if (!this.isDeleted(checkElement) || this.returnDeletedTuples) break;
                    this.outputElement = (LSMIndexSearchCursor.PriorityQueueElement)this.outputPriorityQueue.poll();
                    this.searchCallback.cancel(checkElement.getTuple());
                    this.needPush = true;
                    this.proceed = false;
                    continue;
                }
                if (this.compare(this.cmp, this.outputElement.getTuple(), checkElement.getTuple()) == 0) {
                    LSMIndexSearchCursor.PriorityQueueElement e = (LSMIndexSearchCursor.PriorityQueueElement)this.outputPriorityQueue.poll();
                    this.pushIntoPriorityQueue(e);
                    continue;
                }
                if (this.needPush) {
                    this.pushIntoPriorityQueue(this.outputElement);
                    this.needPush = false;
                }
                this.proceed = true;
                this.outputElement = null;
                continue;
            }
            this.pushIntoPriorityQueue(this.outputElement);
            this.needPush = false;
            this.outputElement = null;
            this.proceed = true;
        }
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException, IndexException {
        LSMBTreeCursorInitialState lsmInitialState = (LSMBTreeCursorInitialState)initialState;
        this.cmp = lsmInitialState.getOriginalKeyComparator();
        this.operationalComponents = lsmInitialState.getOperationalComponents();
        this.lsmHarness = lsmInitialState.getLSMHarness();
        this.searchCallback = lsmInitialState.getSearchOperationCallback();
        this.predicate = (RangePredicate)lsmInitialState.getSearchPredicate();
        this.reusablePred.setLowKeyComparator(this.cmp);
        this.reusablePred.setHighKey(this.predicate.getHighKey(), this.predicate.isHighKeyInclusive());
        this.reusablePred.setHighKeyComparator(this.predicate.getHighKeyComparator());
        this.includeMutableComponent = false;
        int numBTrees = this.operationalComponents.size();
        if (this.rangeCursors == null || this.rangeCursors.length != numBTrees) {
            this.rangeCursors = new IIndexCursor[numBTrees];
            this.btreeAccessors = new BTree.BTreeAccessor[numBTrees];
        }
        for (int i = 0; i < numBTrees; ++i) {
            BTree btree;
            ILSMComponent component = (ILSMComponent)this.operationalComponents.get(i);
            if (this.rangeCursors[i] == null) {
                IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)lsmInitialState.getLeafFrameFactory().createFrame();
                this.rangeCursors[i] = new BTreeRangeSearchCursor(leafFrame, false);
            } else {
                this.rangeCursors[i].reset();
            }
            if (component.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                this.includeMutableComponent = true;
                btree = ((LSMBTreeMemoryComponent)component).getBTree();
            } else {
                btree = ((LSMBTreeDiskComponent)component).getBTree();
            }
            if (this.btreeAccessors[i] == null) {
                this.btreeAccessors[i] = (BTree.BTreeAccessor)btree.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            } else {
                this.btreeAccessors[i].reset(btree, (IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            }
            this.btreeAccessors[i].search(this.rangeCursors[i], searchPred);
        }
        this.setPriorityQueueComparator();
        this.initPriorityQueue();
        this.proceed = true;
    }
}

