/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public class LSMBTreeFileManager
extends AbstractLSMIndexFileManager {
    public static final String BTREE_STRING = "b";
    private final TreeIndexFactory<? extends ITreeIndex> btreeFactory;
    private final boolean hasBloomFilter;
    private static FilenameFilter btreeFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.startsWith(".") && name.endsWith(LSMBTreeFileManager.BTREE_STRING);
        }
    };

    public LSMBTreeFileManager(IIOManager ioManager, IFileMapProvider fileMapProvider, FileReference file, TreeIndexFactory<? extends ITreeIndex> btreeFactory, boolean hasBloomFilter) {
        super(ioManager, fileMapProvider, file, null);
        this.btreeFactory = btreeFactory;
        this.hasBloomFilter = hasBloomFilter;
    }

    public LSMComponentFileReferences getRelFlushFileReference() throws HyracksDataException {
        String ts = this.getCurrentTimestamp();
        String baseName = this.baseDir + ts + "_" + ts;
        return new LSMComponentFileReferences(this.createFlushFile(baseName + "_" + BTREE_STRING), null, this.hasBloomFilter ? this.createFlushFile(baseName + "_" + "f") : null);
    }

    public LSMComponentFileReferences getRelMergeFileReference(String firstFileName, String lastFileName) throws HyracksDataException {
        String[] firstTimestampRange = firstFileName.split("_");
        String[] lastTimestampRange = lastFileName.split("_");
        String baseName = this.baseDir + firstTimestampRange[0] + "_" + lastTimestampRange[1];
        return new LSMComponentFileReferences(this.createMergeFile(baseName + "_" + BTREE_STRING), null, this.hasBloomFilter ? this.createMergeFile(baseName + "_" + "f") : null);
    }

    public List<LSMComponentFileReferences> cleanupAndGetValidFiles() throws HyracksDataException, IndexException {
        ArrayList<LSMComponentFileReferences> validFiles = new ArrayList<LSMComponentFileReferences>();
        ArrayList allBTreeFiles = new ArrayList();
        ArrayList allBloomFilterFiles = new ArrayList();
        FilenameFilter transactionFilter = this.getTransactionFileFilter(false);
        this.cleanupAndGetValidFilesInternal(this.getCompoundFilter(transactionFilter, btreeFilter), this.btreeFactory, allBTreeFiles);
        HashSet<String> btreeFilesSet = new HashSet<String>();
        for (AbstractLSMIndexFileManager.ComparableFileName cmpFileName : allBTreeFiles) {
            int index = cmpFileName.fileName.lastIndexOf("_");
            btreeFilesSet.add(cmpFileName.fileName.substring(0, index));
        }
        if (this.hasBloomFilter) {
            this.validateFiles(btreeFilesSet, allBloomFilterFiles, this.getCompoundFilter(transactionFilter, bloomFilterFilter), null);
            if (allBTreeFiles.size() != allBloomFilterFiles.size()) {
                throw new HyracksDataException("Unequal number of valid BTree and bloom filter files found. Aborting cleanup.");
            }
        }
        if (allBTreeFiles.isEmpty() || this.hasBloomFilter && allBloomFilterFiles.isEmpty()) {
            return validFiles;
        }
        if (!(allBTreeFiles.size() != 1 || this.hasBloomFilter && allBloomFilterFiles.size() != 1)) {
            validFiles.add(new LSMComponentFileReferences(((AbstractLSMIndexFileManager.ComparableFileName)allBTreeFiles.get((int)0)).fileRef, null, this.hasBloomFilter ? ((AbstractLSMIndexFileManager.ComparableFileName)allBloomFilterFiles.get((int)0)).fileRef : null));
            return validFiles;
        }
        Collections.sort(allBTreeFiles);
        if (this.hasBloomFilter) {
            Collections.sort(allBloomFilterFiles);
        }
        ArrayList<AbstractLSMIndexFileManager.ComparableFileName> validComparableBTreeFiles = new ArrayList<AbstractLSMIndexFileManager.ComparableFileName>();
        AbstractLSMIndexFileManager.ComparableFileName lastBTree = (AbstractLSMIndexFileManager.ComparableFileName)allBTreeFiles.get(0);
        validComparableBTreeFiles.add(lastBTree);
        ArrayList<AbstractLSMIndexFileManager.ComparableFileName> validComparableBloomFilterFiles = null;
        AbstractLSMIndexFileManager.ComparableFileName lastBloomFilter = null;
        if (this.hasBloomFilter) {
            validComparableBloomFilterFiles = new ArrayList<AbstractLSMIndexFileManager.ComparableFileName>();
            lastBloomFilter = (AbstractLSMIndexFileManager.ComparableFileName)allBloomFilterFiles.get(0);
            validComparableBloomFilterFiles.add(lastBloomFilter);
        }
        AbstractLSMIndexFileManager.ComparableFileName currentBTree = null;
        AbstractLSMIndexFileManager.ComparableFileName currentBloomFilter = null;
        for (int i = 1; i < allBTreeFiles.size(); ++i) {
            currentBTree = (AbstractLSMIndexFileManager.ComparableFileName)allBTreeFiles.get(i);
            if (this.hasBloomFilter) {
                currentBloomFilter = (AbstractLSMIndexFileManager.ComparableFileName)allBloomFilterFiles.get(i);
            }
            if (!(currentBTree.interval[0].compareTo(lastBTree.interval[1]) <= 0 || this.hasBloomFilter && currentBloomFilter.interval[0].compareTo(lastBloomFilter.interval[1]) <= 0)) {
                validComparableBTreeFiles.add(currentBTree);
                lastBTree = currentBTree;
                if (!this.hasBloomFilter) continue;
                validComparableBloomFilterFiles.add(currentBloomFilter);
                lastBloomFilter = currentBloomFilter;
                continue;
            }
            if (currentBTree.interval[0].compareTo(lastBTree.interval[0]) >= 0 && currentBTree.interval[1].compareTo(lastBTree.interval[1]) <= 0 && (!this.hasBloomFilter || currentBloomFilter.interval[0].compareTo(lastBloomFilter.interval[0]) >= 0 && currentBloomFilter.interval[1].compareTo(lastBloomFilter.interval[1]) <= 0)) {
                File invalidBTreeFile = new File(currentBTree.fullPath);
                invalidBTreeFile.delete();
                if (!this.hasBloomFilter) continue;
                File invalidBloomFilterFile = new File(currentBloomFilter.fullPath);
                invalidBloomFilterFile.delete();
                continue;
            }
            throw new HyracksDataException("Found LSM files with overlapping but not contained timetamp intervals.");
        }
        Collections.sort(validComparableBTreeFiles, this.recencyCmp);
        Iterator btreeFileIter = validComparableBTreeFiles.iterator();
        Iterator bloomFilterFileIter = null;
        if (this.hasBloomFilter) {
            Collections.sort(validComparableBloomFilterFiles, this.recencyCmp);
            bloomFilterFileIter = validComparableBloomFilterFiles.iterator();
        }
        AbstractLSMIndexFileManager.ComparableFileName cmpBTreeFileName = null;
        AbstractLSMIndexFileManager.ComparableFileName cmpBloomFilterFileName = null;
        while (btreeFileIter.hasNext() && (!this.hasBloomFilter || bloomFilterFileIter.hasNext())) {
            cmpBTreeFileName = (AbstractLSMIndexFileManager.ComparableFileName)btreeFileIter.next();
            if (this.hasBloomFilter) {
                cmpBloomFilterFileName = (AbstractLSMIndexFileManager.ComparableFileName)bloomFilterFileIter.next();
            }
            validFiles.add(new LSMComponentFileReferences(cmpBTreeFileName.fileRef, null, this.hasBloomFilter ? cmpBloomFilterFileName.fileRef : null));
        }
        return validFiles;
    }

    public LSMComponentFileReferences getNewTransactionFileReference() throws IOException {
        String ts = this.getCurrentTimestamp();
        Files.createFile(Paths.get(this.baseDir + ".T" + ts, new String[0]), new FileAttribute[0]);
        String baseName = this.baseDir + ts + "_" + ts;
        return new LSMComponentFileReferences(this.createFlushFile(baseName + "_" + BTREE_STRING), null, this.createFlushFile(baseName + "_" + "f"));
    }

    public LSMComponentFileReferences getTransactionFileReferenceForCommit() throws HyracksDataException {
        File dir = new File(this.baseDir);
        String[] files = dir.list(transactionFileNameFilter);
        if (files.length == 0) {
            return null;
        }
        if (files.length != 1) {
            throw new HyracksDataException("More than one transaction lock found:" + files.length);
        }
        FilenameFilter transactionFilter = this.getTransactionFileFilter(true);
        String txnFileName = dir.getPath() + File.separator + files[0];
        files = dir.list(transactionFilter);
        if (files.length < 2) {
            throw new HyracksDataException("LSM Btree transaction has less than 2 files :" + files.length);
        }
        try {
            Files.delete(Paths.get(txnFileName, new String[0]));
        }
        catch (IOException e) {
            throw new HyracksDataException("Failed to delete transaction lock :" + txnFileName);
        }
        File bTreeFile = null;
        File bloomFilterFile = null;
        for (String fileName : files) {
            if (fileName.endsWith(BTREE_STRING)) {
                bTreeFile = new File(dir.getPath() + File.separator + fileName);
                continue;
            }
            if (fileName.endsWith("f")) {
                bloomFilterFile = new File(dir.getPath() + File.separator + fileName);
                continue;
            }
            throw new HyracksDataException("unrecognized file found = " + fileName);
        }
        FileReference bTreeFileRef = this.ioManager.resolveAbsolutePath(bTreeFile.getAbsolutePath());
        FileReference bloomFilterFileRef = this.ioManager.resolveAbsolutePath(bloomFilterFile.getAbsolutePath());
        return new LSMComponentFileReferences(bTreeFileRef, null, bloomFilterFileRef);
    }
}

