/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;

public class ExternalBTreeOpContext
extends AbstractLSMIndexOperationContext {
    public ITreeIndexFrameFactory insertLeafFrameFactory;
    public ITreeIndexFrameFactory deleteLeafFrameFactory;
    public IBTreeLeafFrame insertLeafFrame;
    public IBTreeLeafFrame deleteLeafFrame;
    public IndexOperation op;
    public final MultiComparator cmp;
    public final MultiComparator bloomFilterCmp;
    public final ISearchOperationCallback searchCallback;
    private final List<ILSMComponent> componentHolder;
    private final List<ILSMDiskComponent> componentsToBeMerged;
    private final List<ILSMDiskComponent> componentsToBeReplicated;
    private final int targetIndexVersion;
    public ISearchPredicate searchPredicate;
    public LSMBTreeCursorInitialState searchInitialState;

    public ExternalBTreeOpContext(ITreeIndexFrameFactory insertLeafFrameFactory, ITreeIndexFrameFactory deleteLeafFrameFactory, ISearchOperationCallback searchCallback, int numBloomFilterKeyFields, IBinaryComparatorFactory[] cmpFactories, int targetIndexVersion, ILSMHarness lsmHarness) {
        this.cmp = cmpFactories != null ? MultiComparator.create((IBinaryComparatorFactory[])cmpFactories) : null;
        this.bloomFilterCmp = MultiComparator.create((IBinaryComparatorFactory[])cmpFactories, (int)0, (int)numBloomFilterKeyFields);
        this.insertLeafFrameFactory = insertLeafFrameFactory;
        this.deleteLeafFrameFactory = deleteLeafFrameFactory;
        this.insertLeafFrame = (IBTreeLeafFrame)insertLeafFrameFactory.createFrame();
        this.deleteLeafFrame = (IBTreeLeafFrame)deleteLeafFrameFactory.createFrame();
        if (this.insertLeafFrame != null && this.cmp != null) {
            this.insertLeafFrame.setMultiComparator(this.cmp);
        }
        if (this.deleteLeafFrame != null && this.cmp != null) {
            this.deleteLeafFrame.setMultiComparator(this.cmp);
        }
        this.componentHolder = new LinkedList<ILSMComponent>();
        this.componentsToBeMerged = new LinkedList<ILSMDiskComponent>();
        this.componentsToBeReplicated = new LinkedList<ILSMDiskComponent>();
        this.searchCallback = searchCallback;
        this.targetIndexVersion = targetIndexVersion;
        this.searchInitialState = new LSMBTreeCursorInitialState(insertLeafFrameFactory, this.cmp, this.bloomFilterCmp, lsmHarness, null, searchCallback, null);
    }

    public void setOperation(IndexOperation newOp) {
        this.reset();
        this.op = newOp;
    }

    public void reset() {
        super.reset();
        this.componentHolder.clear();
        this.componentsToBeMerged.clear();
        this.componentsToBeReplicated.clear();
    }

    public IndexOperation getOperation() {
        return this.op;
    }

    public List<ILSMComponent> getComponentHolder() {
        return this.componentHolder;
    }

    public ISearchOperationCallback getSearchOperationCallback() {
        return this.searchCallback;
    }

    public IModificationOperationCallback getModificationCallback() {
        return null;
    }

    public void setCurrentMutableComponentId(int currentMutableComponentId) {
    }

    public List<ILSMDiskComponent> getComponentsToBeMerged() {
        return this.componentsToBeMerged;
    }

    public int getTargetIndexVersion() {
        return this.targetIndexVersion;
    }

    public void setSearchPredicate(ISearchPredicate searchPredicate) {
        this.searchPredicate = searchPredicate;
    }

    public ISearchPredicate getSearchPredicate() {
        return this.searchPredicate;
    }

    public List<ILSMDiskComponent> getComponentsToBeReplicated() {
        return this.componentsToBeReplicated;
    }
}

