/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.dataflow;

import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.api.IIndex;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IResourceLifecycleManager;
import org.apache.hyracks.storage.am.common.dataflow.AbstractTreeIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.util.IndexFileNameUtil;
import org.apache.hyracks.storage.am.lsm.btree.utils.LSMBTreeUtil;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.am.lsm.common.dataflow.AbstractLSMIndexDataflowHelper;

public class ExternalBTreeWithBuddyDataflowHelper
extends AbstractLSMIndexDataflowHelper {
    private final int[] buddyBtreeFields;
    private final int version;

    public ExternalBTreeWithBuddyDataflowHelper(IIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, ILSMMergePolicy mergePolicy, ILSMOperationTrackerFactory opTrackerFactory, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, int[] buddyBtreeFields, int version, boolean durable) throws HyracksDataException {
        super(opDesc, ctx, partition, null, mergePolicy, opTrackerFactory, ioScheduler, ioOpCallbackFactory, null, null, null, durable);
        this.buddyBtreeFields = buddyBtreeFields;
        this.version = version;
    }

    public ExternalBTreeWithBuddyDataflowHelper(IIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTrackerFactory opTrackerFactory, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, int[] buddyBtreeFields, int version, boolean durable) throws HyracksDataException {
        super(opDesc, ctx, partition, null, bloomFilterFalsePositiveRate, mergePolicy, opTrackerFactory, ioScheduler, ioOpCallbackFactory, null, null, null, durable);
        this.buddyBtreeFields = buddyBtreeFields;
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIndex getIndexInstance() {
        IResourceLifecycleManager iResourceLifecycleManager = this.lcManager;
        synchronized (iResourceLifecycleManager) {
            if (this.index == null) {
                try {
                    this.index = (IIndex)this.lcManager.get(this.resourceName);
                }
                catch (HyracksDataException e) {
                    return null;
                }
            }
        }
        return this.index;
    }

    protected IIndex createIndexInstance() throws HyracksDataException {
        AbstractTreeIndexOperatorDescriptor treeOpDesc = (AbstractTreeIndexOperatorDescriptor)this.opDesc;
        FileReference fileRef = IndexFileNameUtil.getIndexAbsoluteFileRef((IIndexOperatorDescriptor)treeOpDesc, (int)this.ctx.getTaskAttemptId().getTaskId().getPartition(), (IIOManager)this.ctx.getIOManager());
        return LSMBTreeUtil.createExternalBTreeWithBuddy(this.ctx.getIOManager(), fileRef, this.opDesc.getStorageManager().getBufferCache(this.ctx), this.opDesc.getStorageManager().getFileMapProvider(this.ctx), treeOpDesc.getTreeIndexTypeTraits(), treeOpDesc.getTreeIndexComparatorFactories(), this.bloomFilterFalsePositiveRate, this.mergePolicy, this.opTrackerFactory.getOperationTracker(this.ctx.getJobletContext().getServiceContext()), this.ioScheduler, this.ioOpCallbackFactory.createIoOpCallback(), this.buddyBtreeFields, this.version, this.durable, (IMetadataPageManagerFactory)this.opDesc.getPageManagerFactory());
    }

    public int getTargetVersion() {
        return this.version;
    }
}

