/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.map;

import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IDataWriter;
import org.apache.hyracks.api.dataflow.IOpenableDataWriter;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.IOpenableDataWriterOperator;
import org.apache.hyracks.dataflow.std.map.IDeserializedMapper;
import org.apache.hyracks.dataflow.std.map.IDeserializedMapperFactory;
import org.apache.hyracks.dataflow.std.util.DeserializedOperatorNodePushable;

public class DeserializedMapperOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final IDeserializedMapperFactory mapperFactory;

    public DeserializedMapperOperatorDescriptor(IOperatorDescriptorRegistry spec, IDeserializedMapperFactory mapperFactory, RecordDescriptor recordDescriptor) {
        super(spec, 1, 1);
        this.mapperFactory = mapperFactory;
        this.recordDescriptors[0] = recordDescriptor;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        return new DeserializedOperatorNodePushable(ctx, new MapperOperator(), recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0));
    }

    private class MapperOperator
    implements IOpenableDataWriterOperator {
        private IDeserializedMapper mapper;
        private IOpenableDataWriter<Object[]> writer;

        private MapperOperator() {
        }

        public void close() throws HyracksDataException {
            this.writer.close();
        }

        public void fail() throws HyracksDataException {
            this.writer.fail();
        }

        public void open() throws HyracksDataException {
            this.mapper = DeserializedMapperOperatorDescriptor.this.mapperFactory.createMapper();
            this.writer.open();
        }

        @Override
        public void setDataWriter(int index, IOpenableDataWriter<Object[]> writer) {
            if (index != 0) {
                throw new IllegalArgumentException();
            }
            this.writer = writer;
        }

        public void writeData(Object[] data) throws HyracksDataException {
            this.mapper.map(data, (IDataWriter<Object[]>)this.writer);
        }

        public void flush() throws HyracksDataException {
        }
    }
}

