/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.join;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluator;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.buffermanager.DeallocatableFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.FramePoolBackedFrameBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.IDeallocatableFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.IPartitionedTupleBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.PreferToSpillFullyOccupiedFramePolicy;
import org.apache.hyracks.dataflow.std.buffermanager.VPartitionTupleBufferManager;
import org.apache.hyracks.dataflow.std.join.InMemoryHashJoin;
import org.apache.hyracks.dataflow.std.structures.SerializableHashTable;
import org.apache.hyracks.dataflow.std.structures.TuplePointer;
import org.apache.hyracks.dataflow.std.util.FrameTuplePairComparator;

public class OptimizedHybridHashJoin {
    private FrameTupleAppender bigProbeFrameAppender;
    private IHyracksTaskContext ctx;
    private final String buildRelName;
    private final String probeRelName;
    private final int[] buildKeys;
    private final int[] probeKeys;
    private final IBinaryComparator[] comparators;
    private final ITuplePartitionComputer buildHpc;
    private final ITuplePartitionComputer probeHpc;
    private final RecordDescriptor buildRd;
    private final RecordDescriptor probeRd;
    private RunFileWriter[] buildRFWriters;
    private RunFileWriter[] probeRFWriters;
    private final IPredicateEvaluator predEvaluator;
    private final boolean isLeftOuter;
    private final IMissingWriter[] nonMatchWriters;
    private final BitSet spilledStatus;
    private final int numOfPartitions;
    private final int memSizeInFrames;
    private InMemoryHashJoin inMemJoiner;
    private IPartitionedTupleBufferManager bufferManager;
    private PreferToSpillFullyOccupiedFramePolicy spillPolicy;
    private final FrameTupleAccessor accessorBuild;
    private final FrameTupleAccessor accessorProbe;
    private IDeallocatableFramePool framePool;
    private ISimpleFrameBufferManager bufferManagerForHashTable;
    private boolean isReversed;
    private int[] buildPSizeInTups;
    private IFrame reloadBuffer;
    private TuplePointer tempPtr = new TuplePointer();
    private int[] probePSizeInTups;

    public OptimizedHybridHashJoin(IHyracksTaskContext ctx, int memSizeInFrames, int numOfPartitions, String probeRelName, String buildRelName, int[] probeKeys, int[] buildKeys, IBinaryComparator[] comparators, RecordDescriptor probeRd, RecordDescriptor buildRd, ITuplePartitionComputer probeHpc, ITuplePartitionComputer buildHpc, IPredicateEvaluator predEval, boolean isLeftOuter, IMissingWriterFactory[] nullWriterFactories1) {
        this.ctx = ctx;
        this.memSizeInFrames = memSizeInFrames;
        this.buildRd = buildRd;
        this.probeRd = probeRd;
        this.buildHpc = buildHpc;
        this.probeHpc = probeHpc;
        this.buildKeys = buildKeys;
        this.probeKeys = probeKeys;
        this.comparators = comparators;
        this.buildRelName = buildRelName;
        this.probeRelName = probeRelName;
        this.numOfPartitions = numOfPartitions;
        this.buildRFWriters = new RunFileWriter[numOfPartitions];
        this.probeRFWriters = new RunFileWriter[numOfPartitions];
        this.accessorBuild = new FrameTupleAccessor(buildRd);
        this.accessorProbe = new FrameTupleAccessor(probeRd);
        this.predEvaluator = predEval;
        this.isLeftOuter = isLeftOuter;
        this.isReversed = false;
        this.spilledStatus = new BitSet(numOfPartitions);
        IMissingWriter[] iMissingWriterArray = this.nonMatchWriters = isLeftOuter ? new IMissingWriter[nullWriterFactories1.length] : null;
        if (isLeftOuter) {
            for (int i = 0; i < nullWriterFactories1.length; ++i) {
                this.nonMatchWriters[i] = nullWriterFactories1[i].createMissingWriter();
            }
        }
    }

    public void initBuild() throws HyracksDataException {
        this.framePool = new DeallocatableFramePool((IHyracksFrameMgrContext)this.ctx, this.memSizeInFrames * this.ctx.getInitialFrameSize());
        this.bufferManagerForHashTable = new FramePoolBackedFrameBufferManager(this.framePool);
        this.bufferManager = new VPartitionTupleBufferManager(PreferToSpillFullyOccupiedFramePolicy.createAtMostOneFrameForSpilledPartitionConstrain(this.spilledStatus), this.numOfPartitions, this.framePool);
        this.spillPolicy = new PreferToSpillFullyOccupiedFramePolicy(this.bufferManager, this.spilledStatus);
        this.spilledStatus.clear();
        this.buildPSizeInTups = new int[this.numOfPartitions];
    }

    public void build(ByteBuffer buffer) throws HyracksDataException {
        this.accessorBuild.reset(buffer);
        int tupleCount = this.accessorBuild.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            int pid = this.buildHpc.partition((IFrameTupleAccessor)this.accessorBuild, i, this.numOfPartitions);
            this.processTuple(i, pid);
            int n = pid;
            this.buildPSizeInTups[n] = this.buildPSizeInTups[n] + 1;
        }
    }

    private void processTuple(int tid, int pid) throws HyracksDataException {
        while (!this.bufferManager.insertTuple(pid, (IFrameTupleAccessor)this.accessorBuild, tid, this.tempPtr)) {
            this.selectAndSpillVictim(pid);
        }
    }

    private void selectAndSpillVictim(int pid) throws HyracksDataException {
        int victimPartition = this.spillPolicy.selectVictimPartition(pid);
        if (victimPartition < 0) {
            throw new HyracksDataException("No more space left in the memory buffer, please assign more memory to hash-join.");
        }
        this.spillPartition(victimPartition);
    }

    private void spillPartition(int pid) throws HyracksDataException {
        RunFileWriter writer = this.getSpillWriterOrCreateNewOneIfNotExist(pid, SIDE.BUILD);
        this.bufferManager.flushPartition(pid, (IFrameWriter)writer);
        this.bufferManager.clearPartition(pid);
        this.spilledStatus.set(pid);
    }

    private void closeBuildPartition(int pid) throws HyracksDataException {
        if (this.buildRFWriters[pid] == null) {
            throw new HyracksDataException("Tried to close the non-existing file writer.");
        }
        this.buildRFWriters[pid].close();
    }

    private RunFileWriter getSpillWriterOrCreateNewOneIfNotExist(int pid, SIDE whichSide) throws HyracksDataException {
        RunFileWriter[] runFileWriters = null;
        String refName = null;
        switch (whichSide) {
            case BUILD: {
                runFileWriters = this.buildRFWriters;
                refName = this.buildRelName;
                break;
            }
            case PROBE: {
                refName = this.probeRelName;
                runFileWriters = this.probeRFWriters;
            }
        }
        RunFileWriter writer = runFileWriters[pid];
        if (writer == null) {
            FileReference file = this.ctx.getJobletContext().createManagedWorkspaceFile(refName);
            writer = new RunFileWriter(file, this.ctx.getIOManager());
            writer.open();
            runFileWriters[pid] = writer;
        }
        return writer;
    }

    public void closeBuild() throws HyracksDataException {
        this.closeAllSpilledPartitions(SIDE.BUILD);
        int inMemTupCount = this.makeSpaceForHashTableAndBringBackSpilledPartitions();
        this.createInMemoryJoiner(inMemTupCount);
        this.loadDataInMemJoin();
    }

    public void clearBuildTempFiles() throws HyracksDataException {
        for (int i = 0; i < this.buildRFWriters.length; ++i) {
            if (this.buildRFWriters[i] == null) continue;
            this.buildRFWriters[i].erase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllSpilledPartitions(SIDE whichSide) throws HyracksDataException {
        RunFileWriter[] runFileWriters = null;
        switch (whichSide) {
            case BUILD: {
                runFileWriters = this.buildRFWriters;
                break;
            }
            case PROBE: {
                runFileWriters = this.probeRFWriters;
            }
        }
        try {
            int pid = this.spilledStatus.nextSetBit(0);
            while (pid >= 0 && pid < this.numOfPartitions) {
                if (this.bufferManager.getNumTuples(pid) > 0) {
                    this.bufferManager.flushPartition(pid, (IFrameWriter)this.getSpillWriterOrCreateNewOneIfNotExist(pid, whichSide));
                    this.bufferManager.clearPartition(pid);
                }
                pid = this.spilledStatus.nextSetBit(pid + 1);
            }
        }
        finally {
            if (runFileWriters != null) {
                for (RunFileWriter runFileWriter : runFileWriters) {
                    if (runFileWriter == null) continue;
                    runFileWriter.close();
                }
            }
        }
    }

    private int makeSpaceForHashTableAndBringBackSpilledPartitions() throws HyracksDataException {
        int frameSize = this.ctx.getInitialFrameSize();
        long freeSpace = (long)(this.memSizeInFrames - this.spilledStatus.cardinality()) * (long)frameSize;
        int inMemTupCount = 0;
        int p = this.spilledStatus.nextClearBit(0);
        while (p >= 0 && p < this.numOfPartitions) {
            freeSpace -= (long)this.bufferManager.getPhysicalSize(p);
            inMemTupCount += this.buildPSizeInTups[p];
            p = this.spilledStatus.nextClearBit(p + 1);
        }
        long hashTableByteSizeForInMemTuples = SerializableHashTable.getExpectedTableByteSize(inMemTupCount, frameSize);
        boolean moreSpilled = false;
        if ((freeSpace -= hashTableByteSizeForInMemTuples) < 0L) {
            int pidToSpill = this.selectSinglePartitionToSpill(freeSpace, inMemTupCount, frameSize);
            if (pidToSpill >= 0) {
                long hashTableSizeDecrease = -SerializableHashTable.calculateByteSizeDeltaForTableSizeChange(inMemTupCount, -this.buildPSizeInTups[pidToSpill], frameSize);
                freeSpace = freeSpace + (long)this.bufferManager.getPhysicalSize(pidToSpill) + hashTableSizeDecrease;
                inMemTupCount -= this.buildPSizeInTups[pidToSpill];
                this.spillPartition(pidToSpill);
                this.closeBuildPartition(pidToSpill);
                moreSpilled = true;
            } else {
                int p2 = this.spilledStatus.nextClearBit(0);
                while (p2 >= 0 && p2 < this.numOfPartitions) {
                    int spaceToBeReturned = this.bufferManager.getPhysicalSize(p2);
                    int numberOfTuplesToBeSpilled = this.buildPSizeInTups[p2];
                    if (spaceToBeReturned != 0 && numberOfTuplesToBeSpilled != 0) {
                        this.spillPartition(p2);
                        this.closeBuildPartition(p2);
                        moreSpilled = true;
                        long expectedHashTableSizeDecrease = -SerializableHashTable.calculateByteSizeDeltaForTableSizeChange(inMemTupCount, -numberOfTuplesToBeSpilled, frameSize);
                        freeSpace = freeSpace + (long)spaceToBeReturned + expectedHashTableSizeDecrease;
                        inMemTupCount -= numberOfTuplesToBeSpilled;
                        if (freeSpace >= 0L) break;
                    }
                    p2 = this.spilledStatus.nextClearBit(p2 + 1);
                }
            }
        }
        if (moreSpilled) {
            hashTableByteSizeForInMemTuples = SerializableHashTable.getExpectedTableByteSize(inMemTupCount, frameSize);
        }
        int pid = 0;
        while ((pid = this.selectPartitionsToReload(freeSpace, pid, inMemTupCount)) >= 0 && this.loadSpilledPartitionToMem(pid, this.buildRFWriters[pid])) {
            long expectedHashTableByteSizeIncrease = SerializableHashTable.calculateByteSizeDeltaForTableSizeChange(inMemTupCount, this.buildPSizeInTups[pid], frameSize);
            freeSpace = freeSpace - (long)this.bufferManager.getPhysicalSize(pid) - expectedHashTableByteSizeIncrease;
            inMemTupCount += this.buildPSizeInTups[pid];
            hashTableByteSizeForInMemTuples += expectedHashTableByteSizeIncrease;
        }
        return inMemTupCount;
    }

    private int selectSinglePartitionToSpill(long currentFreeSpace, int currentInMemTupCount, int frameSize) {
        long minSpaceAfterSpill = (long)this.memSizeInFrames * (long)frameSize;
        int minSpaceAfterSpillPartID = -1;
        int p = this.spilledStatus.nextClearBit(0);
        while (p >= 0 && p < this.numOfPartitions) {
            if (this.buildPSizeInTups[p] != 0 && this.bufferManager.getPhysicalSize(p) != 0) {
                long spaceAfterSpill = currentFreeSpace + (long)this.bufferManager.getPhysicalSize(p) + -SerializableHashTable.calculateByteSizeDeltaForTableSizeChange(currentInMemTupCount, -this.buildPSizeInTups[p], frameSize);
                if (spaceAfterSpill == 0L) {
                    return p;
                }
                if (spaceAfterSpill > 0L && spaceAfterSpill < minSpaceAfterSpill) {
                    minSpaceAfterSpill = spaceAfterSpill;
                    minSpaceAfterSpillPartID = p;
                }
            }
            p = this.spilledStatus.nextClearBit(p + 1);
        }
        return minSpaceAfterSpillPartID;
    }

    private int selectPartitionsToReload(long freeSpace, int pid, int inMemTupCount) {
        int i = this.spilledStatus.nextSetBit(pid);
        while (i >= 0 && i < this.numOfPartitions) {
            int spilledTupleCount = this.buildPSizeInTups[i];
            long expectedHashTableByteSizeIncrease = SerializableHashTable.calculateByteSizeDeltaForTableSizeChange(inMemTupCount, spilledTupleCount, this.ctx.getInitialFrameSize());
            if (freeSpace >= this.buildRFWriters[i].getFileSize() + expectedHashTableByteSizeIncrease) {
                return i;
            }
            i = this.spilledStatus.nextSetBit(i + 1);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadSpilledPartitionToMem(int pid, RunFileWriter wr) throws HyracksDataException {
        try (GeneratedRunFileReader r = wr.createReader();){
            r.open();
            if (this.reloadBuffer == null) {
                this.reloadBuffer = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
            }
            while (r.nextFrame(this.reloadBuffer)) {
                this.accessorBuild.reset(this.reloadBuffer.getBuffer());
                for (int tid = 0; tid < this.accessorBuild.getTupleCount(); ++tid) {
                    if (this.bufferManager.insertTuple(pid, (IFrameTupleAccessor)this.accessorBuild, tid, this.tempPtr)) continue;
                    this.bufferManager.clearPartition(pid);
                    boolean bl = false;
                    return bl;
                }
            }
            r.setDeleteAfterClose(true);
        }
        this.spilledStatus.set(pid, false);
        this.buildRFWriters[pid] = null;
        return true;
    }

    private void createInMemoryJoiner(int inMemTupCount) throws HyracksDataException {
        SerializableHashTable table = new SerializableHashTable(inMemTupCount, (IHyracksFrameMgrContext)this.ctx, this.bufferManagerForHashTable);
        this.inMemJoiner = new InMemoryHashJoin(this.ctx, inMemTupCount, new FrameTupleAccessor(this.probeRd), this.probeHpc, new FrameTupleAccessor(this.buildRd), this.buildRd, this.buildHpc, new FrameTuplePairComparator(this.probeKeys, this.buildKeys, this.comparators), this.isLeftOuter, this.nonMatchWriters, table, this.predEvaluator, this.isReversed, this.bufferManagerForHashTable);
    }

    private void loadDataInMemJoin() throws HyracksDataException {
        for (int pid = 0; pid < this.numOfPartitions; ++pid) {
            if (this.spilledStatus.get(pid)) continue;
            this.bufferManager.flushPartition(pid, new IFrameWriter(){

                public void open() throws HyracksDataException {
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    OptimizedHybridHashJoin.this.inMemJoiner.build(buffer);
                }

                public void fail() throws HyracksDataException {
                }

                public void close() throws HyracksDataException {
                }
            });
        }
    }

    public void initProbe() throws HyracksDataException {
        this.probePSizeInTups = new int[this.numOfPartitions];
        this.probeRFWriters = new RunFileWriter[this.numOfPartitions];
    }

    public void probe(ByteBuffer buffer, IFrameWriter writer) throws HyracksDataException {
        this.accessorProbe.reset(buffer);
        int tupleCount = this.accessorProbe.getTupleCount();
        if (this.isBuildRelAllInMemory()) {
            this.inMemJoiner.join(buffer, writer);
            return;
        }
        this.inMemJoiner.resetAccessorProbe((IFrameTupleAccessor)this.accessorProbe);
        for (int i = 0; i < tupleCount; ++i) {
            int pid = this.probeHpc.partition((IFrameTupleAccessor)this.accessorProbe, i, this.numOfPartitions);
            if (this.buildPSizeInTups[pid] <= 0 && !this.isLeftOuter) continue;
            if (this.spilledStatus.get(pid)) {
                while (!this.bufferManager.insertTuple(pid, (IFrameTupleAccessor)this.accessorProbe, i, this.tempPtr)) {
                    int victim = pid;
                    if (this.bufferManager.getNumTuples(pid) == 0) {
                        victim = this.spillPolicy.findSpilledPartitionWithMaxMemoryUsage();
                    }
                    if (victim < 0) {
                        this.flushBigProbeObjectToDisk(pid, this.accessorProbe, i);
                        break;
                    }
                    RunFileWriter runFileWriter = this.getSpillWriterOrCreateNewOneIfNotExist(victim, SIDE.PROBE);
                    this.bufferManager.flushPartition(victim, (IFrameWriter)runFileWriter);
                    this.bufferManager.clearPartition(victim);
                }
            } else {
                this.inMemJoiner.join(i, writer);
            }
            int n = pid;
            this.probePSizeInTups[n] = this.probePSizeInTups[n] + 1;
        }
    }

    private void flushBigProbeObjectToDisk(int pid, FrameTupleAccessor accessorProbe, int i) throws HyracksDataException {
        if (this.bigProbeFrameAppender == null) {
            this.bigProbeFrameAppender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx));
        }
        RunFileWriter runFileWriter = this.getSpillWriterOrCreateNewOneIfNotExist(pid, SIDE.PROBE);
        if (!this.bigProbeFrameAppender.append((IFrameTupleAccessor)accessorProbe, i)) {
            throw new HyracksDataException("The given tuple is too big");
        }
        this.bigProbeFrameAppender.write((IFrameWriter)runFileWriter, true);
    }

    private boolean isBuildRelAllInMemory() {
        return this.spilledStatus.nextSetBit(0) < 0;
    }

    public void completeProbe(IFrameWriter writer) throws HyracksDataException {
        this.inMemJoiner.completeJoin(writer);
    }

    public void releaseResource() throws HyracksDataException {
        this.inMemJoiner.closeTable();
        this.closeAllSpilledPartitions(SIDE.PROBE);
        this.bufferManager.close();
        this.inMemJoiner = null;
        this.bufferManager = null;
        this.bufferManagerForHashTable = null;
    }

    public void clearProbeTempFiles() throws HyracksDataException {
        for (int i = 0; i < this.probeRFWriters.length; ++i) {
            if (this.probeRFWriters[i] == null) continue;
            this.probeRFWriters[i].erase();
        }
    }

    public RunFileReader getBuildRFReader(int pid) throws HyracksDataException {
        return this.buildRFWriters[pid] == null ? null : this.buildRFWriters[pid].createDeleteOnCloseReader();
    }

    public int getBuildPartitionSizeInTup(int pid) {
        return this.buildPSizeInTups[pid];
    }

    public RunFileReader getProbeRFReader(int pid) throws HyracksDataException {
        return this.probeRFWriters[pid] == null ? null : this.probeRFWriters[pid].createDeleteOnCloseReader();
    }

    public int getProbePartitionSizeInTup(int pid) {
        return this.probePSizeInTups[pid];
    }

    public int getMaxBuildPartitionSize() {
        int max = this.buildPSizeInTups[0];
        for (int i = 1; i < this.buildPSizeInTups.length; ++i) {
            if (this.buildPSizeInTups[i] <= max) continue;
            max = this.buildPSizeInTups[i];
        }
        return max;
    }

    public int getMaxProbePartitionSize() {
        int max = this.probePSizeInTups[0];
        for (int i = 1; i < this.probePSizeInTups.length; ++i) {
            if (this.probePSizeInTups[i] <= max) continue;
            max = this.probePSizeInTups[i];
        }
        return max;
    }

    public BitSet getPartitionStatus() {
        return this.spilledStatus;
    }

    public void setIsReversed(boolean b) {
        this.isReversed = b;
    }

    public String printPartitionInfo(SIDE whichSide) {
        StringBuilder buf = new StringBuilder();
        buf.append(">>> " + this + " " + Thread.currentThread().getId() + " printInfo():\n");
        if (whichSide == SIDE.BUILD) {
            buf.append("BUILD side\n");
        } else {
            buf.append("PROBE side\n");
        }
        buf.append("# of partitions:\t" + this.numOfPartitions + "\t#spilled:\t" + this.spilledStatus.cardinality() + "\t#in-memory:\t" + (this.numOfPartitions - this.spilledStatus.cardinality()) + "\n");
        buf.append("(A) Spilled partitions\n");
        int spilledTupleCount = 0;
        int spilledPartByteSize = 0;
        int pid = this.spilledStatus.nextSetBit(0);
        while (pid >= 0 && pid < this.numOfPartitions) {
            if (whichSide == SIDE.BUILD) {
                spilledTupleCount += this.buildPSizeInTups[pid];
                spilledPartByteSize = (int)((long)spilledPartByteSize + this.buildRFWriters[pid].getFileSize());
                buf.append("part:\t" + pid + "\t#tuple:\t" + this.buildPSizeInTups[pid] + "\tsize(MB):\t" + (double)this.buildRFWriters[pid].getFileSize() / 1048576.0 + "\n");
            } else {
                spilledTupleCount += this.probePSizeInTups[pid];
                spilledPartByteSize = (int)((long)spilledPartByteSize + this.probeRFWriters[pid].getFileSize());
            }
            pid = this.spilledStatus.nextSetBit(pid + 1);
        }
        if (this.spilledStatus.cardinality() > 0) {
            buf.append("# of spilled tuples:\t" + spilledTupleCount + "\tsize(MB):\t" + (double)spilledPartByteSize / 1048576.0 + "avg #tuples per spilled part:\t" + spilledTupleCount / this.spilledStatus.cardinality() + "\tavg size per part(MB):\t" + (double)spilledPartByteSize / 1048576.0 / (double)this.spilledStatus.cardinality() + "\n");
        }
        buf.append("(B) In-memory partitions\n");
        int inMemoryTupleCount = 0;
        int inMemoryPartByteSize = 0;
        int pid2 = this.spilledStatus.nextClearBit(0);
        while (pid2 >= 0 && pid2 < this.numOfPartitions) {
            if (whichSide == SIDE.BUILD) {
                inMemoryTupleCount += this.buildPSizeInTups[pid2];
                inMemoryPartByteSize += this.bufferManager.getPhysicalSize(pid2);
            } else {
                inMemoryTupleCount += this.probePSizeInTups[pid2];
                inMemoryPartByteSize += this.bufferManager.getPhysicalSize(pid2);
            }
            pid2 = this.spilledStatus.nextClearBit(pid2 + 1);
        }
        if (this.spilledStatus.cardinality() > 0) {
            buf.append("# of in-memory tuples:\t" + inMemoryTupleCount + "\tsize(MB):\t" + (double)inMemoryPartByteSize / 1048576.0 + "avg #tuples per spilled part:\t" + inMemoryTupleCount / this.spilledStatus.cardinality() + "\tavg size per part(MB):\t" + (double)inMemoryPartByteSize / 1048576.0 / (double)(this.numOfPartitions - this.spilledStatus.cardinality()) + "\n");
        }
        if (inMemoryTupleCount + spilledTupleCount > 0) {
            buf.append("# of all tuples:\t" + (inMemoryTupleCount + spilledTupleCount) + "\tsize(MB):\t" + (double)(inMemoryPartByteSize + spilledPartByteSize) / 1048576.0 + " ratio of spilled tuples:\t" + spilledTupleCount / (inMemoryTupleCount + spilledTupleCount) + "\n");
        } else {
            buf.append("# of all tuples:\t" + (inMemoryTupleCount + spilledTupleCount) + "\tsize(MB):\t" + (double)(inMemoryPartByteSize + spilledPartByteSize) / 1048576.0 + " ratio of spilled tuples:\tN/A\n");
        }
        return buf.toString();
    }

    static enum SIDE {
        BUILD,
        PROBE;

    }
}

