/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.intersect;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IActivityGraphBuilder;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputOperatorNodePushable;

public class IntersectOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final int[][] projectFields;
    private final INormalizedKeyComputerFactory firstKeyNormalizerFactory;
    private final IBinaryComparatorFactory[] comparatorFactory;

    public IntersectOperatorDescriptor(IOperatorDescriptorRegistry spec, int nInputs, int[][] compareAndProjectFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) throws HyracksException {
        super(spec, nInputs, 1);
        this.recordDescriptors[0] = recordDescriptor;
        this.validateParameters(compareAndProjectFields, comparatorFactories);
        this.projectFields = compareAndProjectFields;
        this.firstKeyNormalizerFactory = firstKeyNormalizerFactory;
        this.comparatorFactory = comparatorFactories;
    }

    private void validateParameters(int[][] compareAndProjectFields, IBinaryComparatorFactory[] comparatorFactories) throws HyracksException {
        int firstLength = compareAndProjectFields[0].length;
        for (int[] fields : compareAndProjectFields) {
            if (fields.length != firstLength) {
                throw new HyracksException("The given input comparison fields is not equal");
            }
            for (int fid : fields) {
                if (fid >= 0) continue;
                throw new HyracksException("Invalid field index in given comparison fields array");
            }
        }
        if (firstLength != comparatorFactories.length) {
            throw new HyracksException("The size of given fields is not equal with the number of comparators");
        }
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        IntersectActivity intersectActivity = new IntersectActivity(new ActivityId(this.getOperatorId(), 0));
        builder.addActivity((IOperatorDescriptor)this, (IActivity)intersectActivity);
        for (int i = 0; i < this.getInputArity(); ++i) {
            builder.addSourceEdge(i, (IActivity)intersectActivity, i);
        }
        builder.addTargetEdge(0, (IActivity)intersectActivity, 0);
    }

    public static class IntersectOperatorNodePushable
    extends AbstractUnaryOutputOperatorNodePushable {
        private final int inputArity;
        private final int[][] projectFields;
        private final BitSet consumed;
        private final int[] tupleIndexMarker;
        private final FrameTupleAccessor[] refAccessor;
        private final FrameTupleAppender appender;
        private final INormalizedKeyComputer firstKeyNormalizerComputer;
        private final IBinaryComparator[] comparators;
        private boolean done = false;

        public IntersectOperatorNodePushable(IHyracksTaskContext ctx, int inputArity, RecordDescriptor[] inputRecordDescriptors, int[][] projectFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactory) throws HyracksDataException {
            int i;
            this.inputArity = inputArity;
            this.projectFields = projectFields;
            this.firstKeyNormalizerComputer = firstKeyNormalizerFactory == null ? null : firstKeyNormalizerFactory.createNormalizedKeyComputer();
            this.comparators = new IBinaryComparator[projectFields[0].length];
            for (i = 0; i < this.comparators.length; ++i) {
                this.comparators[i] = comparatorFactory[i].createBinaryComparator();
            }
            this.appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx));
            this.refAccessor = new FrameTupleAccessor[inputArity];
            for (i = 0; i < inputArity; ++i) {
                this.refAccessor[i] = new FrameTupleAccessor(inputRecordDescriptors[i]);
            }
            this.consumed = new BitSet(inputArity);
            this.consumed.set(0, inputArity);
            this.tupleIndexMarker = new int[inputArity];
        }

        public int getInputArity() {
            return this.inputArity;
        }

        public IFrameWriter getInputFrameWriter(final int index) {
            return new IFrameWriter(){

                public void open() throws HyracksDataException {
                    if (index == 0) {
                        writer.open();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    IntersectOperatorNodePushable intersectOperatorNodePushable = this;
                    synchronized (intersectOperatorNodePushable) {
                        if (done) {
                            return;
                        }
                        refAccessor[index].reset(buffer);
                        ((IntersectOperatorNodePushable)this).tupleIndexMarker[index] = 0;
                        consumed.clear(index);
                        if (index != 0) {
                            if (this.allInputArrived()) {
                                this.notifyAll();
                            }
                            while (!consumed.get(index) && !done) {
                                this.waitOrHyracksException();
                            }
                        } else {
                            while (!consumed.get(0)) {
                                while (!this.allInputArrived() && !done) {
                                    this.waitOrHyracksException();
                                }
                                if (!done) {
                                    this.intersectAllInputs();
                                    this.notifyAll();
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                }

                private void waitOrHyracksException() throws HyracksDataException {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                }

                private boolean allInputArrived() {
                    return consumed.cardinality() == 0;
                }

                private void intersectAllInputs() throws HyracksDataException {
                    do {
                        int i;
                        int maxInput = this.findMaxInput();
                        int match = 1;
                        boolean needToUpdateMax = false;
                        for (i = 0; i < inputArity; ++i) {
                            if (i == maxInput) continue;
                            while (tupleIndexMarker[i] < refAccessor[i].getTupleCount()) {
                                int cmp = this.compare(i, refAccessor[i], tupleIndexMarker[i], maxInput, refAccessor[maxInput], tupleIndexMarker[maxInput]);
                                if (cmp == 0) {
                                    ++match;
                                    break;
                                }
                                if (cmp < 0) {
                                    int[] nArray = tupleIndexMarker;
                                    int n = i;
                                    nArray[n] = nArray[n] + 1;
                                    continue;
                                }
                                needToUpdateMax = true;
                                break;
                            }
                            if (tupleIndexMarker[i] < refAccessor[i].getTupleCount()) continue;
                            consumed.set(i);
                        }
                        if (match == inputArity) {
                            FrameUtils.appendProjectionToWriter((IFrameWriter)writer, (IFrameTupleAppender)appender, (IFrameTupleAccessor)refAccessor[maxInput], (int)tupleIndexMarker[maxInput], (int[])projectFields[maxInput]);
                            for (i = 0; i < inputArity; ++i) {
                                int[] nArray = tupleIndexMarker;
                                int n = i;
                                nArray[n] = nArray[n] + 1;
                                if (tupleIndexMarker[i] < refAccessor[i].getTupleCount()) continue;
                                consumed.set(i);
                            }
                        } else {
                            if (!needToUpdateMax) continue;
                            int[] nArray = tupleIndexMarker;
                            int n = maxInput;
                            nArray[n] = nArray[n] + 1;
                            if (tupleIndexMarker[maxInput] < refAccessor[maxInput].getTupleCount()) continue;
                            consumed.set(maxInput);
                        }
                    } while (consumed.nextSetBit(0) < 0);
                    appender.write(writer, true);
                }

                private int compare(int input1, FrameTupleAccessor frameTupleAccessor1, int tid1, int input2, FrameTupleAccessor frameTupleAccessor2, int tid2) throws HyracksDataException {
                    int firstNorm2;
                    int firstNorm1 = this.getFirstNorm(input1, frameTupleAccessor1, tid1);
                    if (firstNorm1 < (firstNorm2 = this.getFirstNorm(input2, frameTupleAccessor2, tid2))) {
                        return -1;
                    }
                    if (firstNorm1 > firstNorm2) {
                        return 1;
                    }
                    for (int i = 0; i < comparators.length; ++i) {
                        int cmp = comparators[i].compare(frameTupleAccessor1.getBuffer().array(), frameTupleAccessor1.getAbsoluteFieldStartOffset(tid1, projectFields[input1][i]), frameTupleAccessor1.getFieldLength(tid1, projectFields[input1][i]), frameTupleAccessor2.getBuffer().array(), frameTupleAccessor2.getAbsoluteFieldStartOffset(tid2, projectFields[input2][i]), frameTupleAccessor2.getFieldLength(tid2, projectFields[input2][i]));
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }

                private int getFirstNorm(int inputId1, FrameTupleAccessor frameTupleAccessor1, int tid1) {
                    return firstKeyNormalizerComputer == null ? 0 : firstKeyNormalizerComputer.normalize(frameTupleAccessor1.getBuffer().array(), frameTupleAccessor1.getAbsoluteFieldStartOffset(tid1, projectFields[inputId1][0]), frameTupleAccessor1.getFieldLength(tid1, projectFields[inputId1][0]));
                }

                private int findMaxInput() throws HyracksDataException {
                    int max = 0;
                    for (int i = 1; i < inputArity; ++i) {
                        int cmp = this.compare(max, refAccessor[max], tupleIndexMarker[max], i, refAccessor[i], tupleIndexMarker[i]);
                        if (cmp >= 0) continue;
                        max = i;
                    }
                    return max;
                }

                public void fail() throws HyracksDataException {
                    this.clearStateWith(ACTION.FAILED);
                }

                public void close() throws HyracksDataException {
                    this.clearStateWith(ACTION.CLOSE);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void clearStateWith(ACTION action) throws HyracksDataException {
                    IntersectOperatorNodePushable intersectOperatorNodePushable = this;
                    synchronized (intersectOperatorNodePushable) {
                        if (index == 0) {
                            this.doAction(action);
                        }
                        if (done) {
                            return;
                        }
                        consumed.set(index);
                        ((IntersectOperatorNodePushable)this).refAccessor[index] = null;
                        done = true;
                        this.notifyAll();
                    }
                }

                private void doAction(ACTION action) throws HyracksDataException {
                    switch (action) {
                        case CLOSE: {
                            writer.close();
                            break;
                        }
                        case FAILED: {
                            writer.fail();
                        }
                    }
                }
            };
        }

        private static enum ACTION {
            FAILED,
            CLOSE;

        }
    }

    private class IntersectActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public IntersectActivity(ActivityId activityId) {
            super(activityId);
        }

        public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
            RecordDescriptor[] inputRecordDesc = new RecordDescriptor[IntersectOperatorDescriptor.this.inputArity];
            for (int i = 0; i < inputRecordDesc.length; ++i) {
                inputRecordDesc[i] = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), i);
            }
            return new IntersectOperatorNodePushable(ctx, IntersectOperatorDescriptor.this.inputArity, inputRecordDesc, IntersectOperatorDescriptor.this.projectFields, IntersectOperatorDescriptor.this.firstKeyNormalizerFactory, IntersectOperatorDescriptor.this.comparatorFactory);
        }
    }
}

