/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.group.external;

import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IActivityGraphBuilder;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.ISpillableTableFactory;
import org.apache.hyracks.dataflow.std.group.external.ExternalGroupBuildOperatorNodePushable;
import org.apache.hyracks.dataflow.std.group.external.ExternalGroupWriteOperatorNodePushable;

public class ExternalGroupOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final int AGGREGATE_ACTIVITY_ID = 0;
    private static final int MERGE_ACTIVITY_ID = 1;
    private static final long serialVersionUID = 1L;
    private final int[] keyFields;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final INormalizedKeyComputerFactory firstNormalizerFactory;
    private final IAggregatorDescriptorFactory partialAggregatorFactory;
    private final IAggregatorDescriptorFactory intermediateAggregateFactory;
    private final int framesLimit;
    private final ISpillableTableFactory spillableTableFactory;
    private final RecordDescriptor partialRecDesc;
    private final RecordDescriptor outRecDesc;
    private final int tableSize;
    private final long fileSize;

    public ExternalGroupOperatorDescriptor(IOperatorDescriptorRegistry spec, int inputSizeInTuple, long inputFileSize, int[] keyFields, int framesLimit, IBinaryComparatorFactory[] comparatorFactories, INormalizedKeyComputerFactory firstNormalizerFactory, IAggregatorDescriptorFactory partialAggregatorFactory, IAggregatorDescriptorFactory intermediateAggregateFactory, RecordDescriptor partialAggRecordDesc, RecordDescriptor outRecordDesc, ISpillableTableFactory spillableTableFactory) {
        super(spec, 1, 1);
        this.framesLimit = framesLimit;
        if (framesLimit <= 3) {
            throw new IllegalStateException("Frame limit for the External Group Operator should at least be 4, but it is " + framesLimit + "!");
        }
        this.partialAggregatorFactory = partialAggregatorFactory;
        this.intermediateAggregateFactory = intermediateAggregateFactory;
        this.keyFields = keyFields;
        this.comparatorFactories = comparatorFactories;
        this.firstNormalizerFactory = firstNormalizerFactory;
        this.spillableTableFactory = spillableTableFactory;
        this.partialRecDesc = partialAggRecordDesc;
        this.outRecDesc = outRecordDesc;
        this.recordDescriptors[0] = outRecordDesc;
        this.tableSize = inputSizeInTuple;
        this.fileSize = inputFileSize;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        AggregateActivity aggregateAct = new AggregateActivity(new ActivityId(this.getOperatorId(), 0));
        MergeActivity mergeAct = new MergeActivity(new ActivityId(this.odId, 1));
        builder.addActivity((IOperatorDescriptor)this, (IActivity)aggregateAct);
        builder.addSourceEdge(0, (IActivity)aggregateAct, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)mergeAct);
        builder.addTargetEdge(0, (IActivity)mergeAct, 0);
        builder.addBlockingEdge((IActivity)aggregateAct, (IActivity)mergeAct);
    }

    private class MergeActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public MergeActivity(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
            return new ExternalGroupWriteOperatorNodePushable(ctx, new TaskId(new ActivityId(ExternalGroupOperatorDescriptor.this.getOperatorId(), 0), partition), ExternalGroupOperatorDescriptor.this.spillableTableFactory, ExternalGroupOperatorDescriptor.this.partialRecDesc, ExternalGroupOperatorDescriptor.this.outRecDesc, ExternalGroupOperatorDescriptor.this.framesLimit, ExternalGroupOperatorDescriptor.this.keyFields, ExternalGroupOperatorDescriptor.this.firstNormalizerFactory, ExternalGroupOperatorDescriptor.this.comparatorFactories, ExternalGroupOperatorDescriptor.this.intermediateAggregateFactory);
        }
    }

    private class AggregateActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public AggregateActivity(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
            return new ExternalGroupBuildOperatorNodePushable(ctx, new TaskId(this.getActivityId(), partition), ExternalGroupOperatorDescriptor.this.tableSize, ExternalGroupOperatorDescriptor.this.fileSize, ExternalGroupOperatorDescriptor.this.keyFields, ExternalGroupOperatorDescriptor.this.framesLimit, ExternalGroupOperatorDescriptor.this.comparatorFactories, ExternalGroupOperatorDescriptor.this.firstNormalizerFactory, ExternalGroupOperatorDescriptor.this.partialAggregatorFactory, recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0), ExternalGroupOperatorDescriptor.this.recordDescriptors[0], ExternalGroupOperatorDescriptor.this.spillableTableFactory);
        }
    }
}

