/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.group;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.dataflow.IDataReader;
import org.apache.hyracks.api.dataflow.IDataWriter;
import org.apache.hyracks.api.dataflow.IOpenableDataReader;
import org.apache.hyracks.api.dataflow.IOpenableDataWriter;
import org.apache.hyracks.api.dataflow.value.IComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.base.IOpenableDataWriterOperator;
import org.apache.hyracks.dataflow.std.group.IGroupAggregator;

public class DeserializedPreclusteredGroupOperator
implements IOpenableDataWriterOperator {
    private final int[] groupFields;
    private final IComparator[] comparators;
    private final IGroupAggregator aggregator;
    private Object[] lastData;
    private IOpenableDataWriter<Object[]> writer;
    private List<Object[]> buffer;
    private IOpenableDataReader<Object[]> reader;

    public DeserializedPreclusteredGroupOperator(int[] groupFields, IComparator[] comparators, IGroupAggregator aggregator) {
        this.groupFields = groupFields;
        this.comparators = comparators;
        this.aggregator = aggregator;
        this.buffer = new ArrayList<Object[]>();
        this.reader = new IOpenableDataReader<Object[]>(){
            private int idx;

            public void open() {
                this.idx = 0;
            }

            public void close() {
            }

            public Object[] readData() {
                return this.idx >= DeserializedPreclusteredGroupOperator.this.buffer.size() ? null : (Object[])DeserializedPreclusteredGroupOperator.this.buffer.get(this.idx++);
            }
        };
    }

    public void close() throws HyracksDataException {
        if (!this.buffer.isEmpty()) {
            this.aggregate();
        }
        this.writer.close();
        try {
            this.aggregator.close();
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    private void aggregate() throws HyracksDataException {
        this.reader.open();
        this.aggregator.aggregate((IDataReader<Object[]>)this.reader, (IDataWriter<Object[]>)this.writer);
        this.reader.close();
        this.buffer.clear();
    }

    public void open() throws HyracksDataException {
        this.lastData = null;
        this.writer.open();
    }

    @Override
    public void setDataWriter(int index, IOpenableDataWriter<Object[]> writer) {
        if (index != 0) {
            throw new IllegalArgumentException();
        }
        this.writer = writer;
    }

    public void writeData(Object[] data) throws HyracksDataException {
        if (this.lastData != null && this.compare(data, this.lastData) != 0) {
            this.aggregate();
        }
        this.lastData = data;
        this.buffer.add(data);
    }

    private int compare(Object[] d1, Object[] d2) {
        for (int i = 0; i < this.groupFields.length; ++i) {
            int fIdx = this.groupFields[i];
            int c = this.comparators[i].compare(d1[fIdx], d2[fIdx]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public void fail() throws HyracksDataException {
    }

    public void flush() throws HyracksDataException {
        throw new HyracksDataException("unsupported operation");
    }
}

