/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.dataflow.std.file.ITupleParser;
import org.apache.hyracks.dataflow.std.file.ITupleParserFactory;

public class FileScanOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final IFileSplitProvider fileSplitProvider;
    private final ITupleParserFactory tupleParserFactory;

    public FileScanOperatorDescriptor(IOperatorDescriptorRegistry spec, IFileSplitProvider fileSplitProvider, ITupleParserFactory tupleParserFactory, RecordDescriptor rDesc) {
        super(spec, 0, 1);
        this.fileSplitProvider = fileSplitProvider;
        this.tupleParserFactory = tupleParserFactory;
        this.recordDescriptors[0] = rDesc;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        final FileSplit split = this.fileSplitProvider.getFileSplits()[partition];
        final ITupleParser tp = this.tupleParserFactory.createTupleParser(ctx);
        final IIOManager ioManager = ctx.getIOManager();
        return new AbstractUnaryOutputSourceOperatorNodePushable(){

            @Override
            public void initialize() throws HyracksDataException {
                File f = split.getFile(ioManager);
                try {
                    FileInputStream in;
                    this.writer.open();
                    try {
                        in = new FileInputStream(f);
                    }
                    catch (FileNotFoundException e) {
                        this.writer.fail();
                        throw new HyracksDataException((Throwable)e);
                    }
                    tp.parse(in, this.writer);
                }
                catch (Throwable th) {
                    this.writer.fail();
                    throw new HyracksDataException(th);
                }
                finally {
                    this.writer.close();
                }
            }
        };
    }
}

