/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.collectors;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.channels.IInputChannel;
import org.apache.hyracks.api.channels.IInputChannelMonitor;
import org.apache.hyracks.api.comm.IFrameReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.dataflow.std.collectors.IPartitionBatchManager;
import org.apache.hyracks.dataflow.std.collectors.InputChannelFrameReader;

public class NonDeterministicPartitionBatchManager
implements IPartitionBatchManager {
    private final IInputChannel[] channels;
    private List<IFrameReader> partitions;
    private List<IFrameReader> batch;
    private int requiredSize;

    public NonDeterministicPartitionBatchManager(int nSenders) {
        this.channels = new IInputChannel[nSenders];
        this.partitions = new ArrayList<IFrameReader>();
    }

    @Override
    public synchronized void addPartition(PartitionId pid, IInputChannel channel) {
        this.channels[pid.getSenderIndex()] = channel;
        InputChannelFrameReader channelReader = new InputChannelFrameReader(channel);
        channel.registerMonitor((IInputChannelMonitor)channelReader);
        if (this.batch != null && this.batch.size() < this.requiredSize) {
            this.batch.add(channelReader);
            if (this.batch.size() == this.requiredSize) {
                this.notifyAll();
            }
        } else {
            this.partitions.add(channelReader);
        }
    }

    @Override
    public synchronized void getNextBatch(List<IFrameReader> batch, int size) throws HyracksDataException {
        if (this.partitions.size() <= size) {
            batch.addAll(this.partitions);
            this.partitions.clear();
        } else if (this.partitions.size() > size) {
            List<IFrameReader> sublist = this.partitions.subList(0, size);
            batch.addAll(sublist);
            sublist.clear();
        }
        if (batch.size() == size) {
            return;
        }
        this.batch = batch;
        this.requiredSize = size;
        while (batch.size() < size) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        this.batch = null;
    }
}

