/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.buffermanager.BufferInfo;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameFreeSlotPolicy;
import org.apache.hyracks.dataflow.std.buffermanager.IFramePool;
import org.apache.hyracks.util.IntSerDeUtils;

public class VariableFrameMemoryManager
implements IFrameBufferManager {
    private final IFramePool framePool;
    private List<PhysicalFrameOffset> physicalFrameOffsets;
    private List<BufferInfo> logicalFrameStartSizes;
    private final IFrameFreeSlotPolicy freeSlotPolicy;

    public VariableFrameMemoryManager(IFramePool framePool, IFrameFreeSlotPolicy freeSlotPolicy) {
        this.framePool = framePool;
        this.freeSlotPolicy = freeSlotPolicy;
        this.physicalFrameOffsets = new ArrayList<PhysicalFrameOffset>();
        this.logicalFrameStartSizes = new ArrayList<BufferInfo>();
    }

    private int findAvailableFrame(int frameSize) throws HyracksDataException {
        int frameId = this.freeSlotPolicy.popBestFit(frameSize);
        if (frameId >= 0) {
            return frameId;
        }
        ByteBuffer buffer = this.framePool.allocateFrame(frameSize);
        if (buffer != null) {
            IntSerDeUtils.putInt((byte[])buffer.array(), (int)FrameHelper.getTupleCountOffset((int)buffer.capacity()), (int)0);
            this.physicalFrameOffsets.add(new PhysicalFrameOffset(buffer, 0));
            return this.physicalFrameOffsets.size() - 1;
        }
        return -1;
    }

    @Override
    public void reset() throws HyracksDataException {
        this.physicalFrameOffsets.clear();
        this.logicalFrameStartSizes.clear();
        this.freeSlotPolicy.reset();
        this.framePool.reset();
    }

    @Override
    public BufferInfo getFrame(int frameIndex, BufferInfo info) {
        info.reset(this.logicalFrameStartSizes.get(frameIndex));
        return info;
    }

    @Override
    public int getNumFrames() {
        return this.logicalFrameStartSizes.size();
    }

    @Override
    public int insertFrame(ByteBuffer frame) throws HyracksDataException {
        int frameSize = frame.capacity();
        int physicalFrameId = this.findAvailableFrame(frameSize);
        if (physicalFrameId < 0) {
            return -1;
        }
        PhysicalFrameOffset frameOffset = this.physicalFrameOffsets.get(physicalFrameId);
        ByteBuffer buffer = frameOffset.physicalFrame;
        int offset = frameOffset.physicalOffset;
        System.arraycopy(frame.array(), 0, buffer.array(), offset, frameSize);
        if (offset + frameSize < buffer.capacity()) {
            this.freeSlotPolicy.pushNewFrame(physicalFrameId, buffer.capacity() - offset - frameSize);
        }
        frameOffset.physicalOffset = offset + frameSize;
        this.logicalFrameStartSizes.add(new BufferInfo(buffer, offset, frameSize));
        return this.logicalFrameStartSizes.size() - 1;
    }

    @Override
    public void close() {
        this.physicalFrameOffsets.clear();
        this.logicalFrameStartSizes.clear();
        this.freeSlotPolicy.reset();
        this.framePool.close();
    }

    class PhysicalFrameOffset {
        ByteBuffer physicalFrame;
        int physicalOffset;

        PhysicalFrameOffset(ByteBuffer frame, int offset) {
            this.physicalFrame = frame;
            this.physicalOffset = offset;
        }
    }
}

