/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.constraints.IConstraintAcceptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.OperatorDescriptorId;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;

public abstract class AbstractOperatorDescriptor
implements IOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    protected OperatorDescriptorId odId;
    protected String[] partitions;
    protected final RecordDescriptor[] recordDescriptors;
    protected final int inputArity;
    protected final int outputArity;
    protected String displayName;

    public AbstractOperatorDescriptor(IOperatorDescriptorRegistry spec, int inputArity, int outputArity) {
        this.odId = spec.createOperatorDescriptorId((IOperatorDescriptor)this);
        this.inputArity = inputArity;
        this.outputArity = outputArity;
        this.recordDescriptors = new RecordDescriptor[outputArity];
        this.displayName = this.getClass().getName() + "[" + this.odId + "]";
    }

    public final OperatorDescriptorId getOperatorId() {
        return this.odId;
    }

    public void setOperatorId(OperatorDescriptorId id) {
        this.odId = id;
    }

    public int getInputArity() {
        return this.inputArity;
    }

    public int getOutputArity() {
        return this.outputArity;
    }

    public RecordDescriptor[] getOutputRecordDescriptors() {
        return this.recordDescriptors;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void contributeSchedulingConstraints(IConstraintAcceptor constraintAcceptor, ICCServiceContext serviceCtx) {
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode jop = om.createObjectNode();
        jop.put("id", String.valueOf(this.getOperatorId()));
        jop.put("java-class", this.getClass().getName());
        jop.put("in-arity", this.getInputArity());
        jop.put("out-arity", this.getOutputArity());
        jop.put("display-name", this.displayName);
        return jop;
    }
}

