/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.annotations.IRecordFieldDataGen;
import org.apache.asterix.common.annotations.RecordDataGenAnnotation;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.lang.common.expression.OrderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.RecordTypeDefinition;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.expression.TypeReferenceExpression;
import org.apache.asterix.lang.common.expression.UnorderedListTypeDefinition;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.AbstractComplexType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class TypeTranslator {
    private TypeTranslator() {
    }

    public static Map<TypeSignature, IAType> computeTypes(MetadataTransactionContext mdTxnCtx, TypeExpression typeExpr, String typeName, String typeDataverse) throws AlgebricksException {
        HashMap<TypeSignature, IAType> typeMap = new HashMap<TypeSignature, IAType>();
        return TypeTranslator.computeTypes(mdTxnCtx, typeExpr, typeName, typeDataverse, typeMap);
    }

    public static Map<TypeSignature, IAType> computeTypes(MetadataTransactionContext mdTxnCtx, TypeExpression typeExpr, String typeName, String typeDataverse, Map<TypeSignature, IAType> typeMap) throws AlgebricksException {
        HashMap<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes = new HashMap<String, Map<ARecordType, List<Integer>>>();
        HashMap<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes = new HashMap<TypeSignature, List<AbstractCollectionType>>();
        HashMap<TypeSignature, List<TypeSignature>> incompleteTopLevelTypeReferences = new HashMap<TypeSignature, List<TypeSignature>>();
        TypeTranslator.firstPass(typeExpr, typeName, typeMap, incompleteFieldTypes, incompleteItemTypes, incompleteTopLevelTypeReferences, typeDataverse);
        TypeTranslator.secondPass(mdTxnCtx, typeMap, incompleteFieldTypes, incompleteItemTypes, incompleteTopLevelTypeReferences, typeDataverse);
        for (IAType type : typeMap.values()) {
            if (!type.getTypeTag().isDerivedType()) continue;
            ((AbstractComplexType)type).generateNestedDerivedTypeNames();
        }
        return typeMap;
    }

    private static void firstPass(TypeExpression typeExpr, String typeName, Map<TypeSignature, IAType> typeMap, Map<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes, Map<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes, Map<TypeSignature, List<TypeSignature>> incompleteTopLevelTypeReferences, String typeDataverse) throws AlgebricksException {
        if (BuiltinTypeMap.getBuiltinType((String)typeName) != null) {
            throw new AlgebricksException("Cannot redefine builtin type " + typeName + " .");
        }
        TypeSignature typeSignature = new TypeSignature(typeDataverse, typeName);
        try {
            switch (typeExpr.getTypeKind()) {
                case TYPEREFERENCE: {
                    TypeReferenceExpression tre = (TypeReferenceExpression)typeExpr;
                    IAType t = TypeTranslator.solveTypeReference(new TypeSignature(tre.getIdent().first == null ? typeDataverse : ((Identifier)tre.getIdent().first).getValue(), ((Identifier)tre.getIdent().second).getValue()), typeMap);
                    if (t != null) {
                        typeMap.put(typeSignature, t);
                        break;
                    }
                    TypeTranslator.addIncompleteTopLevelTypeReference(tre, incompleteTopLevelTypeReferences, typeDataverse);
                    break;
                }
                case RECORD: {
                    RecordTypeDefinition rtd = (RecordTypeDefinition)typeExpr;
                    ARecordType recType = TypeTranslator.computeRecordType(typeSignature, rtd, typeMap, incompleteFieldTypes, incompleteItemTypes, typeDataverse);
                    typeMap.put(typeSignature, (IAType)recType);
                    break;
                }
                case ORDEREDLIST: {
                    OrderedListTypeDefinition oltd = (OrderedListTypeDefinition)typeExpr;
                    AOrderedListType olType = TypeTranslator.computeOrderedListType(typeSignature, oltd, typeMap, incompleteItemTypes, incompleteFieldTypes, typeDataverse);
                    typeMap.put(typeSignature, (IAType)olType);
                    break;
                }
                case UNORDEREDLIST: {
                    UnorderedListTypeDefinition ultd = (UnorderedListTypeDefinition)typeExpr;
                    AUnorderedListType ulType = TypeTranslator.computeUnorderedListType(typeSignature, ultd, typeMap, incompleteItemTypes, incompleteFieldTypes, typeDataverse);
                    typeMap.put(typeSignature, (IAType)ulType);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (AsterixException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private static void secondPass(MetadataTransactionContext mdTxnCtx, Map<TypeSignature, IAType> typeMap, Map<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes, Map<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes, Map<TypeSignature, List<TypeSignature>> incompleteTopLevelTypeReferences, String typeDataverse) throws AlgebricksException {
        IAType t;
        Datatype dt;
        for (TypeSignature typeSignature : incompleteTopLevelTypeReferences.keySet()) {
            dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, typeSignature.getNamespace(), typeSignature.getName());
            if (dt == null) {
                throw new AlgebricksException("Could not resolve type " + typeSignature);
            }
            t = dt.getDatatype();
            for (TypeSignature typeSignature2 : incompleteTopLevelTypeReferences.get(typeSignature)) {
                typeMap.put(typeSignature2, t);
            }
        }
        for (String trefName : incompleteFieldTypes.keySet()) {
            dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, typeDataverse, trefName);
            if (dt == null) {
                dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, "Metadata", trefName);
            }
            if (dt == null) {
                throw new AlgebricksException("Could not resolve type " + trefName);
            }
            t = dt.getDatatype();
            Map<ARecordType, List<Integer>> fieldsToFix = incompleteFieldTypes.get(trefName);
            for (ARecordType recType : fieldsToFix.keySet()) {
                List<Integer> positions = fieldsToFix.get(recType);
                IAType[] fldTypes = recType.getFieldTypes();
                for (Integer pos : positions) {
                    if (fldTypes[pos] == null) {
                        fldTypes[pos.intValue()] = t;
                        continue;
                    }
                    AUnionType nullableUnion = (AUnionType)fldTypes[pos];
                    nullableUnion.setActualType(t);
                }
            }
        }
        for (TypeSignature typeSignature : incompleteItemTypes.keySet()) {
            if (MetadataManager.INSTANCE != null) {
                dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, typeSignature.getNamespace(), typeSignature.getName());
                if (dt == null) {
                    throw new AlgebricksException("Could not resolve type " + typeSignature);
                }
                t = dt.getDatatype();
            } else {
                t = typeMap.get(typeSignature);
            }
            for (AbstractCollectionType abstractCollectionType : incompleteItemTypes.get(typeSignature)) {
                abstractCollectionType.setItemType(t);
            }
        }
    }

    private static AOrderedListType computeOrderedListType(TypeSignature typeSignature, OrderedListTypeDefinition oltd, Map<TypeSignature, IAType> typeMap, Map<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes, Map<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes, String defaultDataverse) throws AsterixException {
        TypeExpression tExpr = oltd.getItemTypeExpression();
        String typeName = typeSignature != null ? typeSignature.getName() : null;
        AOrderedListType aolt = new AOrderedListType(null, typeName);
        TypeTranslator.setCollectionItemType(tExpr, typeMap, incompleteItemTypes, incompleteFieldTypes, (AbstractCollectionType)aolt, defaultDataverse);
        return aolt;
    }

    private static AUnorderedListType computeUnorderedListType(TypeSignature typeSignature, UnorderedListTypeDefinition ultd, Map<TypeSignature, IAType> typeMap, Map<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes, Map<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes, String defaulDataverse) throws AsterixException {
        TypeExpression tExpr = ultd.getItemTypeExpression();
        String typeName = typeSignature != null ? typeSignature.getName() : null;
        AUnorderedListType ault = new AUnorderedListType(null, typeName);
        TypeTranslator.setCollectionItemType(tExpr, typeMap, incompleteItemTypes, incompleteFieldTypes, (AbstractCollectionType)ault, defaulDataverse);
        return ault;
    }

    private static void setCollectionItemType(TypeExpression tExpr, Map<TypeSignature, IAType> typeMap, Map<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes, Map<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes, AbstractCollectionType act, String defaultDataverse) throws AsterixException {
        switch (tExpr.getTypeKind()) {
            case ORDEREDLIST: {
                OrderedListTypeDefinition oltd = (OrderedListTypeDefinition)tExpr;
                AOrderedListType t = TypeTranslator.computeOrderedListType(null, oltd, typeMap, incompleteItemTypes, incompleteFieldTypes, defaultDataverse);
                act.setItemType((IAType)t);
                break;
            }
            case UNORDEREDLIST: {
                UnorderedListTypeDefinition ultd = (UnorderedListTypeDefinition)tExpr;
                AUnorderedListType t = TypeTranslator.computeUnorderedListType(null, ultd, typeMap, incompleteItemTypes, incompleteFieldTypes, defaultDataverse);
                act.setItemType((IAType)t);
                break;
            }
            case RECORD: {
                RecordTypeDefinition rtd = (RecordTypeDefinition)tExpr;
                ARecordType t = TypeTranslator.computeRecordType(null, rtd, typeMap, incompleteFieldTypes, incompleteItemTypes, defaultDataverse);
                act.setItemType((IAType)t);
                break;
            }
            case TYPEREFERENCE: {
                TypeReferenceExpression tre = (TypeReferenceExpression)tExpr;
                TypeSignature signature = new TypeSignature(tre.getIdent().first == null ? defaultDataverse : ((Identifier)tre.getIdent().first).getValue(), ((Identifier)tre.getIdent().second).getValue());
                IAType tref = TypeTranslator.solveTypeReference(signature, typeMap);
                if (tref != null) {
                    act.setItemType(tref);
                    break;
                }
                TypeTranslator.addIncompleteCollectionTypeReference(act, tre, incompleteItemTypes, defaultDataverse);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static void addIncompleteCollectionTypeReference(AbstractCollectionType collType, TypeReferenceExpression tre, Map<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes, String defaultDataverse) {
        String typeName;
        TypeSignature typeSignature = new TypeSignature(tre.getIdent().first == null ? defaultDataverse : ((Identifier)tre.getIdent().first).getValue(), typeName = ((Identifier)tre.getIdent().second).getValue());
        List<AbstractCollectionType> typeList = incompleteItemTypes.get(typeSignature);
        if (typeList == null) {
            typeList = new LinkedList<AbstractCollectionType>();
            incompleteItemTypes.put(typeSignature, typeList);
        }
        typeList.add(collType);
    }

    private static void addIncompleteFieldTypeReference(ARecordType recType, int fldPosition, TypeReferenceExpression tre, Map<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes) {
        List<Integer> typeList;
        String typeName = ((Identifier)tre.getIdent().second).getValue();
        Map<ARecordType, List<Integer>> refMap = incompleteFieldTypes.get(typeName);
        if (refMap == null) {
            refMap = new HashMap<ARecordType, List<Integer>>();
            incompleteFieldTypes.put(typeName, refMap);
        }
        if ((typeList = refMap.get(recType)) == null) {
            typeList = new ArrayList<Integer>();
            refMap.put(recType, typeList);
        }
        typeList.add(fldPosition);
    }

    private static void addIncompleteTopLevelTypeReference(TypeReferenceExpression tre, Map<TypeSignature, List<TypeSignature>> incompleteTopLevelTypeReferences, String defaultDataverse) {
        String name = ((Identifier)tre.getIdent().second).getValue();
        TypeSignature typeSignature = new TypeSignature(tre.getIdent().first == null ? defaultDataverse : ((Identifier)tre.getIdent().first).getValue(), name);
        List<TypeSignature> refList = incompleteTopLevelTypeReferences.get(name);
        if (refList == null) {
            refList = new LinkedList<TypeSignature>();
            incompleteTopLevelTypeReferences.put(new TypeSignature(tre.getIdent().first == null ? defaultDataverse : ((Identifier)tre.getIdent().first).getValue(), ((Identifier)tre.getIdent().second).getValue()), refList);
        }
        refList.add(typeSignature);
    }

    private static IAType solveTypeReference(TypeSignature typeSignature, Map<TypeSignature, IAType> typeMap) {
        IAType builtin = BuiltinTypeMap.getBuiltinType((String)typeSignature.getName());
        if (builtin != null) {
            return builtin;
        }
        return typeMap.get(typeSignature);
    }

    private static ARecordType computeRecordType(TypeSignature typeSignature, RecordTypeDefinition rtd, Map<TypeSignature, IAType> typeMap, Map<String, Map<ARecordType, List<Integer>>> incompleteFieldTypes, Map<TypeSignature, List<AbstractCollectionType>> incompleteItemTypes, String defaultDataverse) throws AsterixException {
        List names = rtd.getFieldNames();
        int n = names.size();
        String[] fldNames = new String[n];
        IAType[] fldTypes = new IAType[n];
        int i = 0;
        for (String s : names) {
            fldNames[i++] = s;
        }
        boolean isOpen = rtd.getRecordKind() == RecordTypeDefinition.RecordKind.OPEN;
        ARecordType recType = new ARecordType(typeSignature == null ? null : typeSignature.getName(), fldNames, fldTypes, isOpen);
        List fieldDataGen = rtd.getFieldDataGen();
        if (fieldDataGen.size() == n) {
            IRecordFieldDataGen[] rfdg = new IRecordFieldDataGen[n];
            rfdg = fieldDataGen.toArray(rfdg);
            recType.getAnnotations().add(new RecordDataGenAnnotation(rfdg, rtd.getUndeclaredFieldsDataGen()));
        }
        block7: for (int j = 0; j < n; ++j) {
            TypeExpression texpr = (TypeExpression)rtd.getFieldTypes().get(j);
            switch (texpr.getTypeKind()) {
                case TYPEREFERENCE: {
                    TypeReferenceExpression tre = (TypeReferenceExpression)texpr;
                    TypeSignature signature = new TypeSignature(tre.getIdent().first == null ? defaultDataverse : ((Identifier)tre.getIdent().first).getValue(), ((Identifier)tre.getIdent().second).getValue());
                    IAType tref = TypeTranslator.solveTypeReference(signature, typeMap);
                    if (tref != null) {
                        if (!((Boolean)rtd.getOptionableFields().get(j)).booleanValue()) {
                            fldTypes[j] = tref;
                            continue block7;
                        }
                        fldTypes[j] = AUnionType.createUnknownableType((IAType)tref);
                        continue block7;
                    }
                    TypeTranslator.addIncompleteFieldTypeReference(recType, j, tre, incompleteFieldTypes);
                    if (!((Boolean)rtd.getOptionableFields().get(j)).booleanValue()) continue block7;
                    fldTypes[j] = AUnionType.createUnknownableType(null);
                    continue block7;
                }
                case RECORD: {
                    RecordTypeDefinition recTypeDef2 = (RecordTypeDefinition)texpr;
                    ARecordType t2 = TypeTranslator.computeRecordType(null, recTypeDef2, typeMap, incompleteFieldTypes, incompleteItemTypes, defaultDataverse);
                    if (!((Boolean)rtd.getOptionableFields().get(j)).booleanValue()) {
                        fldTypes[j] = t2;
                        continue block7;
                    }
                    fldTypes[j] = AUnionType.createUnknownableType((IAType)t2);
                    continue block7;
                }
                case ORDEREDLIST: {
                    OrderedListTypeDefinition oltd = (OrderedListTypeDefinition)texpr;
                    ARecordType t2 = TypeTranslator.computeOrderedListType(null, oltd, typeMap, incompleteItemTypes, incompleteFieldTypes, defaultDataverse);
                    fldTypes[j] = (Boolean)rtd.getOptionableFields().get(j) != false ? AUnionType.createUnknownableType((IAType)t2) : t2;
                    continue block7;
                }
                case UNORDEREDLIST: {
                    UnorderedListTypeDefinition ultd = (UnorderedListTypeDefinition)texpr;
                    ARecordType t2 = TypeTranslator.computeUnorderedListType(null, ultd, typeMap, incompleteItemTypes, incompleteFieldTypes, defaultDataverse);
                    fldTypes[j] = (Boolean)rtd.getOptionableFields().get(j) != false ? AUnionType.createUnknownableType((IAType)t2) : t2;
                    continue block7;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return recType;
    }
}

