/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.literal.DoubleLiteral;
import org.apache.asterix.lang.common.literal.FloatLiteral;
import org.apache.asterix.lang.common.literal.IntegerLiteral;
import org.apache.asterix.lang.common.literal.LongIntegerLiteral;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;

public final class ConstantHelper {
    public static IAObject objectFromLiteral(Literal valLiteral) {
        switch (valLiteral.getLiteralType()) {
            case DOUBLE: {
                DoubleLiteral d = (DoubleLiteral)valLiteral;
                return new ADouble(d.getValue().doubleValue());
            }
            case FALSE: {
                return ABoolean.FALSE;
            }
            case FLOAT: {
                FloatLiteral fl = (FloatLiteral)valLiteral;
                return new AFloat(fl.getValue().floatValue());
            }
            case INTEGER: {
                IntegerLiteral il = (IntegerLiteral)valLiteral;
                return new AInt32(il.getValue().intValue());
            }
            case LONG: {
                LongIntegerLiteral ll = (LongIntegerLiteral)valLiteral;
                return new AInt64(ll.getValue());
            }
            case MISSING: {
                return AMissing.MISSING;
            }
            case NULL: {
                return ANull.NULL;
            }
            case STRING: {
                StringLiteral sl = (StringLiteral)valLiteral;
                return new AString(sl.getValue());
            }
            case TRUE: {
                return ABoolean.TRUE;
            }
        }
        throw new IllegalStateException();
    }
}

