/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.statement.DatasetDecl;
import org.apache.asterix.lang.common.statement.DataverseDropStatement;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.DropDatasetStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.NodeGroupDropStatement;
import org.apache.asterix.metadata.dataset.hints.DatasetHints;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.runtime.utils.AppContextInfo;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class AbstractLangTranslator {
    private static final Logger LOGGER = Logger.getLogger(AbstractLangTranslator.class.getName());

    public void validateOperation(Dataverse defaultDataverse, Statement stmt) throws AsterixException {
        int maxWaitCycles;
        if (!ClusterStateManager.INSTANCE.getState().equals((Object)IClusterManagementWork.ClusterState.ACTIVE) || !ClusterStateManager.INSTANCE.isGlobalRecoveryCompleted()) {
            maxWaitCycles = AppContextInfo.INSTANCE.getExternalProperties().getMaxWaitClusterActive();
            try {
                ClusterStateManager.INSTANCE.waitForState(IClusterManagementWork.ClusterState.ACTIVE, (long)maxWaitCycles, TimeUnit.SECONDS);
            }
            catch (HyracksDataException e) {
                throw new AsterixException((Throwable)e);
            }
            catch (InterruptedException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Thread interrupted while waiting for cluster to be " + IClusterManagementWork.ClusterState.ACTIVE);
                }
                Thread.currentThread().interrupt();
            }
            if (!ClusterStateManager.INSTANCE.getState().equals((Object)IClusterManagementWork.ClusterState.ACTIVE)) {
                throw new AsterixException("Cluster is in " + IClusterManagementWork.ClusterState.UNUSABLE + " state.\n One or more Node Controllers have left or haven't joined yet.\n");
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Cluster is now " + IClusterManagementWork.ClusterState.ACTIVE);
            }
        }
        if (ClusterStateManager.INSTANCE.getState().equals((Object)IClusterManagementWork.ClusterState.UNUSABLE)) {
            throw new AsterixException("Cluster is in " + IClusterManagementWork.ClusterState.UNUSABLE + " state.\n One or more Node Controllers have left.\n");
        }
        if (!ClusterStateManager.INSTANCE.isGlobalRecoveryCompleted()) {
            maxWaitCycles = AppContextInfo.INSTANCE.getExternalProperties().getMaxWaitClusterActive();
            try {
                for (int waitCycleCount = 0; !ClusterStateManager.INSTANCE.isGlobalRecoveryCompleted() && waitCycleCount < maxWaitCycles; ++waitCycleCount) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Thread interrupted while waiting for cluster to complete global recovery ");
                }
                Thread.currentThread().interrupt();
            }
            if (!ClusterStateManager.INSTANCE.isGlobalRecoveryCompleted()) {
                throw new AsterixException("Cluster Global recovery is not yet complete and the system is in " + IClusterManagementWork.ClusterState.ACTIVE + " state");
            }
        }
        boolean invalidOperation = false;
        String message = null;
        String dataverse = defaultDataverse != null ? defaultDataverse.getDataverseName() : null;
        switch (stmt.getKind()) {
            case 5: {
                InsertStatement insertStmt = (InsertStatement)stmt;
                if (insertStmt.getDataverseName() != null) {
                    dataverse = insertStmt.getDataverseName().getValue();
                }
                if (!(invalidOperation = "Metadata".equals(dataverse))) break;
                message = "Insert operation is not permitted in dataverse Metadata";
                break;
            }
            case 4: {
                DeleteStatement deleteStmt = (DeleteStatement)stmt;
                if (deleteStmt.getDataverseName() != null) {
                    dataverse = deleteStmt.getDataverseName().getValue();
                }
                if (!(invalidOperation = "Metadata".equals(dataverse))) break;
                message = "Delete operation is not permitted in dataverse Metadata";
                break;
            }
            case 12: {
                String nodegroupName = ((NodeGroupDropStatement)stmt).getNodeGroupName().getValue();
                invalidOperation = "DEFAULT_NG_ALL_NODES".equals(nodegroupName);
                if (!invalidOperation) break;
                message = "Cannot drop nodegroup:" + nodegroupName;
                break;
            }
            case 2: {
                DataverseDropStatement dvDropStmt = (DataverseDropStatement)stmt;
                invalidOperation = "Metadata".equals(dvDropStmt.getDataverseName().getValue());
                if (!invalidOperation) break;
                message = "Cannot drop dataverse:" + dvDropStmt.getDataverseName().getValue();
                break;
            }
            case 3: {
                DropDatasetStatement dropStmt = (DropDatasetStatement)stmt;
                if (dropStmt.getDataverseName() != null) {
                    dataverse = dropStmt.getDataverseName().getValue();
                }
                if (!(invalidOperation = "Metadata".equals(dataverse))) break;
                message = "Cannot drop a dataset belonging to the dataverse:Metadata";
                break;
            }
            case 0: {
                DatasetDecl datasetStmt = (DatasetDecl)stmt;
                Map hints = datasetStmt.getHints();
                if (hints == null || hints.isEmpty()) break;
                Pair validationResult = null;
                StringBuffer errorMsgBuffer = new StringBuffer();
                for (Map.Entry hint : hints.entrySet()) {
                    validationResult = DatasetHints.validate((String)((String)hint.getKey()), (String)((String)hint.getValue()));
                    if (((Boolean)validationResult.first).booleanValue()) continue;
                    errorMsgBuffer.append("Dataset: " + datasetStmt.getName().getValue() + " error in processing hint: " + (String)hint.getKey() + " " + (String)validationResult.second);
                    errorMsgBuffer.append(" \n");
                }
                boolean bl = invalidOperation = errorMsgBuffer.length() > 0;
                if (!invalidOperation) break;
                message = errorMsgBuffer.toString();
                break;
            }
        }
        if (invalidOperation) {
            throw new AsterixException("Invalid operation - " + message);
        }
    }
}

