/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.runtime.RuntimeRecordTypeInfo;
import org.apache.asterix.runtime.evaluators.comparisons.DeepEqualAssessor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.functions.records.RecordMergeDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.functions.records.RecordMergeDescriptor$_Gen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class RecordMergeDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final RuntimeRecordTypeInfo runtimeRecordTypeInfo = new RuntimeRecordTypeInfo();
    private final DeepEqualAssessor deepEqualAssesor = new DeepEqualAssessor();
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput out = this.resultStorage.getDataOutput();
    final /* synthetic */ IScalarEvaluator val$eval0;
    final /* synthetic */ IPointable val$argPtr0;
    final /* synthetic */ IScalarEvaluator val$eval1;
    final /* synthetic */ IPointable val$argPtr1;
    final /* synthetic */ IVisitablePointable val$vp0;
    final /* synthetic */ IVisitablePointable val$vp1;
    final /* synthetic */ List val$rbStack;
    final /* synthetic */ ArrayBackedValueStorage val$tabvs;
    final /* synthetic */ RecordMergeDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker = new TypeChecker();

    RecordMergeDescriptor$_EvaluatorGen(RecordMergeDescriptor$_EvaluatorFactoryGen this$1, IScalarEvaluator iScalarEvaluator, IPointable iPointable, IScalarEvaluator iScalarEvaluator2, IPointable iPointable2, IVisitablePointable iVisitablePointable, IVisitablePointable iVisitablePointable2, List list, ArrayBackedValueStorage arrayBackedValueStorage) {
        this.this$1 = this$1;
        this.val$eval0 = iScalarEvaluator;
        this.val$argPtr0 = iPointable;
        this.val$eval1 = iScalarEvaluator2;
        this.val$argPtr1 = iPointable2;
        this.val$vp0 = iVisitablePointable;
        this.val$vp1 = iVisitablePointable2;
        this.val$rbStack = list;
        this.val$tabvs = arrayBackedValueStorage;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.val$eval0.evaluate(tuple, this.val$argPtr0);
        if (this.typeChecker.isMissing(this.val$argPtr0, result)) {
            return;
        }
        this.val$eval1.evaluate(tuple, this.val$argPtr1);
        if (this.typeChecker.isMissing(this.val$argPtr1, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        this.val$vp0.set((IValueReference)this.val$argPtr0);
        this.val$vp1.set((IValueReference)this.val$argPtr1);
        ARecordVisitablePointable rp0 = (ARecordVisitablePointable)this.val$vp0;
        ARecordVisitablePointable rp1 = (ARecordVisitablePointable)this.val$vp1;
        try {
            this.mergeFields(RecordMergeDescriptor$_Gen.access$200(this.this$1.this$0), rp0, rp1, true, 0);
            ((RecordBuilder)this.val$rbStack.get(0)).write(this.out, true);
        }
        catch (IOException | AsterixException e) {
            throw new HyracksDataException(e);
        }
        result.set((IValueReference)this.resultStorage);
    }

    private void mergeFields(ARecordType combinedType, ARecordVisitablePointable leftRecord, ARecordVisitablePointable rightRecord, boolean openFromParent, int nestedLevel) throws IOException, AsterixException, HyracksDataException {
        if (this.val$rbStack.size() < nestedLevel + 1) {
            this.val$rbStack.add(new RecordBuilder());
        }
        ((RecordBuilder)this.val$rbStack.get(nestedLevel)).reset(combinedType);
        ((RecordBuilder)this.val$rbStack.get(nestedLevel)).init();
        for (int i = 0; i < leftRecord.getFieldNames().size(); ++i) {
            IVisitablePointable leftName = (IVisitablePointable)leftRecord.getFieldNames().get(i);
            IVisitablePointable leftValue = (IVisitablePointable)leftRecord.getFieldValues().get(i);
            IVisitablePointable leftType = (IVisitablePointable)leftRecord.getFieldTypeTags().get(i);
            boolean foundMatch = false;
            for (int j = 0; j < rightRecord.getFieldNames().size(); ++j) {
                IVisitablePointable rightName = (IVisitablePointable)rightRecord.getFieldNames().get(j);
                IVisitablePointable rightValue = (IVisitablePointable)rightRecord.getFieldValues().get(j);
                IVisitablePointable rightType = (IVisitablePointable)rightRecord.getFieldTypeTags().get(j);
                if (!PointableHelper.isEqual((IValueReference)leftName, (IValueReference)rightName) || this.deepEqualAssesor.isEqual(leftValue, rightValue)) continue;
                if (PointableHelper.sameType((ATypeTag)ATypeTag.RECORD, (IVisitablePointable)rightType) && PointableHelper.sameType((ATypeTag)ATypeTag.RECORD, (IVisitablePointable)leftType)) {
                    this.addFieldToSubRecord(combinedType, leftName, leftValue, rightValue, openFromParent, nestedLevel);
                    foundMatch = true;
                    continue;
                }
                throw new RuntimeDataException(13, new Serializable[]{this.this$1.this$0.getIdentifier()});
            }
            if (foundMatch) continue;
            this.addFieldToSubRecord(combinedType, leftName, leftValue, null, openFromParent, nestedLevel);
        }
        for (int j = 0; j < rightRecord.getFieldNames().size(); ++j) {
            IVisitablePointable rightName = (IVisitablePointable)rightRecord.getFieldNames().get(j);
            IVisitablePointable rightValue = (IVisitablePointable)rightRecord.getFieldValues().get(j);
            boolean foundMatch = false;
            for (int i = 0; i < leftRecord.getFieldNames().size(); ++i) {
                IVisitablePointable leftName = (IVisitablePointable)leftRecord.getFieldNames().get(i);
                if (!rightName.equals(leftName)) continue;
                foundMatch = true;
            }
            if (foundMatch) continue;
            this.addFieldToSubRecord(combinedType, rightName, rightValue, null, openFromParent, nestedLevel);
        }
    }

    private void addFieldToSubRecord(ARecordType combinedType, IVisitablePointable fieldNamePointable, IVisitablePointable leftValue, IVisitablePointable rightValue, boolean openFromParent, int nestedLevel) throws IOException, AsterixException, HyracksDataException {
        this.runtimeRecordTypeInfo.reset(combinedType);
        int pos = this.runtimeRecordTypeInfo.getFieldIndex(fieldNamePointable.getByteArray(), fieldNamePointable.getStartOffset() + 1, fieldNamePointable.getLength() - 1);
        if (combinedType != null && pos >= 0) {
            if (rightValue == null) {
                ((RecordBuilder)this.val$rbStack.get(nestedLevel)).addField(pos, (IValueReference)leftValue);
            } else {
                this.mergeFields((ARecordType)combinedType.getFieldTypes()[pos], (ARecordVisitablePointable)leftValue, (ARecordVisitablePointable)rightValue, false, nestedLevel + 1);
                this.val$tabvs.reset();
                ((RecordBuilder)this.val$rbStack.get(nestedLevel + 1)).write(this.val$tabvs.getDataOutput(), true);
                ((RecordBuilder)this.val$rbStack.get(nestedLevel)).addField(pos, (IValueReference)this.val$tabvs);
            }
        } else if (rightValue == null) {
            ((RecordBuilder)this.val$rbStack.get(nestedLevel)).addField((IValueReference)fieldNamePointable, (IValueReference)leftValue);
        } else {
            this.mergeFields(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE, (ARecordVisitablePointable)leftValue, (ARecordVisitablePointable)rightValue, false, nestedLevel + 1);
            this.val$tabvs.reset();
            ((RecordBuilder)this.val$rbStack.get(nestedLevel + 1)).write(this.val$tabvs.getDataOutput(), true);
            ((RecordBuilder)this.val$rbStack.get(nestedLevel)).addField((IValueReference)fieldNamePointable, (IValueReference)this.val$tabvs);
        }
    }
}

