/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.StringRepeatDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

class StringRepeatDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private IScalarEvaluator evalString;
    private IScalarEvaluator evalStart;
    private IPointable argString;
    private IPointable argNumber;
    private ArrayBackedValueStorage resultStorage;
    private DataOutput out;
    private byte[] tempLengthArray;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ StringRepeatDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    StringRepeatDescriptor$_EvaluatorGen(StringRepeatDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.evalString = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.evalStart = this.this$1.val$args[1].createScalarEvaluator(this.val$ctx);
        this.argString = new VoidPointable();
        this.argNumber = new VoidPointable();
        this.resultStorage = new ArrayBackedValueStorage();
        this.out = this.resultStorage.getDataOutput();
        this.tempLengthArray = new byte[5];
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.evalString.evaluate(tuple, this.argString);
        if (this.typeChecker.isMissing(this.argString, result)) {
            return;
        }
        this.evalStart.evaluate(tuple, this.argNumber);
        if (this.typeChecker.isMissing(this.argNumber, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        byte[] bytes = this.argNumber.getByteArray();
        int offset = this.argNumber.getStartOffset();
        int repeatingTimes = ATypeHierarchy.getIntegerValue((String)this.this$1.this$0.getIdentifier().getName(), (int)1, (byte[])bytes, (int)offset);
        if (repeatingTimes < 0) {
            throw new RuntimeDataException(10, new Serializable[]{this.this$1.this$0.getIdentifier(), Integer.valueOf(1), Integer.valueOf(repeatingTimes)});
        }
        bytes = this.argString.getByteArray();
        if (bytes[offset = this.argString.getStartOffset()] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), Integer.valueOf(0), bytes[offset], new byte[]{ATypeTag.SERIALIZED_STRING_TYPE_TAG});
        }
        int inputLen = UTF8StringUtil.getUTFLength((byte[])bytes, (int)(offset + 1));
        int resultLen = Math.multiplyExact(inputLen, repeatingTimes);
        int cbytes = UTF8StringUtil.encodeUTF8Length((int)resultLen, (byte[])this.tempLengthArray, (int)0);
        int inputStringStart = offset + 1 + UTF8StringUtil.getNumBytesToStoreLength((int)inputLen);
        try {
            this.out.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            this.out.write(this.tempLengthArray, 0, cbytes);
            for (int numRepeats = 0; numRepeats < repeatingTimes; ++numRepeats) {
                this.out.write(bytes, inputStringStart, inputLen);
            }
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }
}

