/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.cast.ACastVisitor;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class CastTypeEvaluator$_EvaluatorGen
implements IScalarEvaluator {
    private final IScalarEvaluator argEvaluator;
    private final IPointable argPointable = new VoidPointable();
    private final PointableAllocator allocator = new PointableAllocator();
    private final IVisitablePointable inputPointable;
    private final IVisitablePointable resultPointable;
    private final ACastVisitor castVisitor = new ACastVisitor();
    private final Triple<IVisitablePointable, IAType, Boolean> arg;
    private final TypeChecker typeChecker;

    public CastTypeEvaluator$_EvaluatorGen(IAType reqType, IAType inputType, IScalarEvaluator argEvaluator) throws HyracksDataException {
        try {
            this.argEvaluator = argEvaluator;
            this.inputPointable = this.allocatePointable(inputType, reqType);
            this.resultPointable = this.allocatePointable(reqType, inputType);
            this.arg = new Triple((Object)this.resultPointable, (Object)reqType, (Object)Boolean.FALSE);
        }
        catch (AsterixException e) {
            throw new HyracksDataException((Throwable)e);
        }
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            this.argEvaluator.evaluate(tuple, this.argPointable);
            if (this.typeChecker.isMissing(this.argPointable, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            this.inputPointable.set((IValueReference)this.argPointable);
            this.inputPointable.accept((IVisitablePointableVisitor)this.castVisitor, this.arg);
            result.set((IValueReference)this.resultPointable);
        }
        catch (Exception ioe) {
            throw new HyracksDataException((Throwable)ioe);
        }
    }

    private final IVisitablePointable allocatePointable(IAType typeForPointable, IAType typeForOtherSide) throws AsterixException {
        if (!typeForPointable.equals(BuiltinType.ANY)) {
            return this.allocator.allocateFieldValue(typeForPointable);
        }
        return this.allocatePointableForAny(typeForOtherSide);
    }

    private IVisitablePointable allocatePointableForAny(IAType type) {
        ATypeTag tag = type.getTypeTag();
        switch (tag) {
            case RECORD: {
                return this.allocator.allocateFieldValue((IAType)DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
            }
            case ORDEREDLIST: {
                return this.allocator.allocateFieldValue((IAType)DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE);
            }
            case UNORDEREDLIST: {
                return this.allocator.allocateFieldValue((IAType)DefaultOpenFieldType.NESTED_OPEN_AUNORDERED_LIST_TYPE);
            }
        }
        return this.allocator.allocateFieldValue(null);
    }
}

