/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.constructors.AStringConstructorDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class AStringConstructorDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput out = this.resultStorage.getDataOutput();
    private IPointable inputArg = new VoidPointable();
    private IScalarEvaluator eval;
    private UTF8StringBuilder builder;
    private GrowableArray baaos;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ AStringConstructorDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    AStringConstructorDescriptor$_EvaluatorGen(AStringConstructorDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.builder = new UTF8StringBuilder();
        this.baaos = new GrowableArray();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            this.resultStorage.reset();
            this.baaos.reset();
            this.eval.evaluate(tuple, this.inputArg);
            if (this.typeChecker.isMissing(this.inputArg, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            byte[] serString = this.inputArg.getByteArray();
            int offset = this.inputArg.getStartOffset();
            int len = this.inputArg.getLength();
            ATypeTag tt = ATypeTag.VALUE_TYPE_MAPPING[serString[offset]];
            if (tt == ATypeTag.STRING) {
                result.set((IValueReference)this.inputArg);
            } else {
                this.builder.reset(this.baaos, len);
                int startOffset = offset + 1;
                switch (tt) {
                    case INT8: {
                        byte i = AInt8SerializerDeserializer.getByte((byte[])serString, (int)startOffset);
                        this.builder.appendString(String.valueOf(i));
                        break;
                    }
                    case INT16: {
                        short i = AInt16SerializerDeserializer.getShort((byte[])serString, (int)startOffset);
                        this.builder.appendString(String.valueOf(i));
                        break;
                    }
                    case INT32: {
                        int i = AInt32SerializerDeserializer.getInt((byte[])serString, (int)startOffset);
                        this.builder.appendString(String.valueOf(i));
                        break;
                    }
                    case INT64: {
                        long l = AInt64SerializerDeserializer.getLong((byte[])serString, (int)startOffset);
                        this.builder.appendString(String.valueOf(l));
                        break;
                    }
                    case DOUBLE: {
                        double d = ADoubleSerializerDeserializer.getDouble((byte[])serString, (int)startOffset);
                        this.builder.appendString(String.valueOf(d));
                        break;
                    }
                    case FLOAT: {
                        float f = AFloatSerializerDeserializer.getFloat((byte[])serString, (int)startOffset);
                        this.builder.appendString(String.valueOf(f));
                        break;
                    }
                    case BOOLEAN: {
                        boolean b = ABooleanSerializerDeserializer.getBoolean((byte[])serString, (int)startOffset);
                        this.builder.appendString(String.valueOf(b));
                        break;
                    }
                    default: {
                        throw new UnsupportedTypeException(this.this$1.this$0.getIdentifier(), serString[offset]);
                    }
                }
                this.builder.finish();
                this.out.write(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                this.out.write(this.baaos.getByteArray(), 0, this.baaos.getLength());
                result.set((IValueReference)this.resultStorage);
            }
        }
        catch (IOException e) {
            throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), (Throwable)e, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        }
    }
}

