/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutablePoint;
import org.apache.asterix.om.base.AMutableRectangle;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.ARectangle;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.constructors.ARectangleConstructorDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class ARectangleConstructorDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput out = this.resultStorage.getDataOutput();
    private IPointable inputArg = new VoidPointable();
    private IScalarEvaluator eval;
    private AMutableRectangle aRectangle;
    private AMutablePoint[] aPoint;
    private ISerializerDeserializer<ARectangle> rectangle2DSerde;
    private final UTF8StringPointable utf8Ptr;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ ARectangleConstructorDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    ARectangleConstructorDescriptor$_EvaluatorGen(ARectangleConstructorDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.aRectangle = new AMutableRectangle(null, null);
        this.aPoint = new AMutablePoint[]{new AMutablePoint(0.0, 0.0), new AMutablePoint(0.0, 0.0)};
        this.rectangle2DSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ARECTANGLE);
        this.utf8Ptr = new UTF8StringPointable();
        this.typeChecker = new TypeChecker();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            this.resultStorage.reset();
            this.eval.evaluate(tuple, this.inputArg);
            if (this.typeChecker.isMissing(this.inputArg, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            byte[] serString = this.inputArg.getByteArray();
            int offset = this.inputArg.getStartOffset();
            int len = this.inputArg.getLength();
            if (serString[offset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), Integer.valueOf(0), serString[offset], new byte[]{ATypeTag.SERIALIZED_STRING_TYPE_TAG});
            this.utf8Ptr.set(serString, offset + 1, len - 1);
            String s = this.utf8Ptr.toString();
            int commaIndex = s.indexOf(44);
            int spaceIndex = s.indexOf(32, commaIndex + 1);
            this.aPoint[0].setValue(Double.parseDouble(s.substring(0, commaIndex)), Double.parseDouble(s.substring(commaIndex + 1, spaceIndex)));
            commaIndex = s.indexOf(44, spaceIndex + 1);
            this.aPoint[1].setValue(Double.parseDouble(s.substring(spaceIndex + 1, commaIndex)), Double.parseDouble(s.substring(commaIndex + 1, s.length())));
            if (this.aPoint[0].getX() > this.aPoint[1].getX() && this.aPoint[0].getY() > this.aPoint[1].getY()) {
                this.aRectangle.setValue((APoint)this.aPoint[1], (APoint)this.aPoint[0]);
            } else {
                if (!(this.aPoint[0].getX() < this.aPoint[1].getX()) || !(this.aPoint[0].getY() < this.aPoint[1].getY())) throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
                this.aRectangle.setValue((APoint)this.aPoint[0], (APoint)this.aPoint[1]);
            }
            this.rectangle2DSerde.serialize((Object)this.aRectangle, this.out);
            result.set((IValueReference)this.resultStorage);
            return;
        }
        catch (IOException e) {
            throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), (Throwable)e, ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
        }
    }
}

