/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.typecast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;

public class StaticTypeCastUtil {
    public static boolean rewriteListExpr(AbstractFunctionCallExpression funcExpr, IAType reqType, IAType inputType, IVariableTypeEnvironment env) throws AlgebricksException {
        if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.UNORDERED_LIST_CONSTRUCTOR) {
            if (reqType.equals(BuiltinType.ANY)) {
                reqType = DefaultOpenFieldType.NESTED_OPEN_AUNORDERED_LIST_TYPE;
            }
            return StaticTypeCastUtil.rewriteListFuncExpr(funcExpr, (AbstractCollectionType)reqType, (AbstractCollectionType)inputType, env);
        }
        if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.ORDERED_LIST_CONSTRUCTOR) {
            if (reqType.equals(BuiltinType.ANY)) {
                reqType = DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE;
            }
            return StaticTypeCastUtil.rewriteListFuncExpr(funcExpr, (AbstractCollectionType)reqType, (AbstractCollectionType)inputType, env);
        }
        List args = funcExpr.getArguments();
        boolean changed = false;
        for (Mutable arg : args) {
            ILogicalExpression argExpr = (ILogicalExpression)arg.getValue();
            if (argExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            AbstractFunctionCallExpression argFuncExpr = (AbstractFunctionCallExpression)argExpr;
            IAType exprType = (IAType)env.getType((ILogicalExpression)argFuncExpr);
            changed = StaticTypeCastUtil.rewriteListExpr(argFuncExpr, exprType, exprType, env) || changed;
        }
        return changed;
    }

    public static boolean rewriteFuncExpr(AbstractFunctionCallExpression funcExpr, IAType reqType, IAType inputType, IVariableTypeEnvironment env) throws AlgebricksException {
        if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.UNORDERED_LIST_CONSTRUCTOR) {
            if (reqType.equals(BuiltinType.ANY)) {
                reqType = DefaultOpenFieldType.NESTED_OPEN_AUNORDERED_LIST_TYPE;
            }
            return StaticTypeCastUtil.rewriteListFuncExpr(funcExpr, (AbstractCollectionType)reqType, (AbstractCollectionType)inputType, env);
        }
        if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.ORDERED_LIST_CONSTRUCTOR) {
            if (reqType.equals(BuiltinType.ANY)) {
                reqType = DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE;
            }
            return StaticTypeCastUtil.rewriteListFuncExpr(funcExpr, (AbstractCollectionType)reqType, (AbstractCollectionType)inputType, env);
        }
        if (inputType.getTypeTag().equals((Object)ATypeTag.RECORD)) {
            if (reqType.equals(BuiltinType.ANY)) {
                reqType = DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE;
            }
            return StaticTypeCastUtil.rewriteRecordFuncExpr(funcExpr, (ARecordType)reqType, (ARecordType)inputType, env);
        }
        List args = funcExpr.getArguments();
        boolean changed = false;
        for (Mutable arg : args) {
            ILogicalExpression argExpr = (ILogicalExpression)arg.getValue();
            if (argExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            AbstractFunctionCallExpression argFuncExpr = (AbstractFunctionCallExpression)argExpr;
            IAType exprType = (IAType)env.getType((ILogicalExpression)argFuncExpr);
            changed = changed || StaticTypeCastUtil.rewriteFuncExpr(argFuncExpr, exprType, exprType, env);
        }
        if (!StaticTypeCastUtil.compatible(reqType, inputType)) {
            throw new AlgebricksException("type mismatch, required: " + reqType.toString() + " actual: " + inputType.toString());
        }
        return changed;
    }

    private static boolean rewriteRecordFuncExpr(AbstractFunctionCallExpression funcExpr, ARecordType requiredRecordType, ARecordType inputRecordType, IVariableTypeEnvironment env) throws AlgebricksException {
        if (TypeCastUtils.getRequiredType((AbstractFunctionCallExpression)funcExpr) != null) {
            return false;
        }
        boolean casted = StaticTypeCastUtil.staticRecordTypeCast(funcExpr, requiredRecordType, inputRecordType, env);
        if (casted) {
            TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)funcExpr, (IAType)requiredRecordType, (IAType)inputRecordType);
        }
        return casted;
    }

    private static boolean rewriteListFuncExpr(AbstractFunctionCallExpression funcExpr, AbstractCollectionType requiredListType, AbstractCollectionType inputListType, IVariableTypeEnvironment env) throws AlgebricksException {
        if (TypeCastUtils.getRequiredType((AbstractFunctionCallExpression)funcExpr) != null) {
            return false;
        }
        TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)funcExpr, (IAType)requiredListType, (IAType)inputListType);
        List args = funcExpr.getArguments();
        IAType itemType = requiredListType.getItemType();
        IAType inputItemType = inputListType.getItemType();
        boolean changed = false;
        block4: for (int j = 0; j < args.size(); ++j) {
            ILogicalExpression arg = (ILogicalExpression)((Mutable)args.get(j)).getValue();
            IAType currentItemType = inputItemType == null || inputItemType == BuiltinType.ANY ? (IAType)env.getType(arg) : inputItemType;
            switch (arg.getExpressionTag()) {
                case FUNCTION_CALL: {
                    ScalarFunctionCallExpression argFunc = (ScalarFunctionCallExpression)arg;
                    changed = StaticTypeCastUtil.rewriteFuncExpr((AbstractFunctionCallExpression)argFunc, itemType, currentItemType, env) || changed;
                    continue block4;
                }
                case VARIABLE: {
                    changed = StaticTypeCastUtil.injectCastToRelaxType((Mutable<ILogicalExpression>)((Mutable)args.get(j)), currentItemType, env) || changed;
                }
            }
        }
        return changed;
    }

    private static boolean staticRecordTypeCast(AbstractFunctionCallExpression func, ARecordType reqType, ARecordType inputType, IVariableTypeEnvironment env) throws AlgebricksException {
        int i;
        int i2;
        if (func.getFunctionIdentifier() != BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR && func.getFunctionIdentifier() != BuiltinFunctions.CLOSED_RECORD_CONSTRUCTOR) {
            return false;
        }
        IAType[] reqFieldTypes = reqType.getFieldTypes();
        String[] reqFieldNames = reqType.getFieldNames();
        IAType[] inputFieldTypes = inputType.getFieldTypes();
        String[] inputFieldNames = inputType.getFieldNames();
        int[] fieldPermutation = new int[reqFieldTypes.length];
        boolean[] nullFields = new boolean[reqFieldTypes.length];
        boolean[] openFields = new boolean[inputFieldTypes.length];
        Arrays.fill(nullFields, false);
        Arrays.fill(openFields, true);
        Arrays.fill(fieldPermutation, -1);
        boolean matched = false;
        for (i2 = 0; i2 < inputFieldNames.length; ++i2) {
            String fieldName = inputFieldNames[i2];
            IAType fieldType = inputFieldTypes[i2];
            if (2 * i2 + 1 > func.getArguments().size()) {
                return false;
            }
            ILogicalExpression arg = (ILogicalExpression)((Mutable)func.getArguments().get(2 * i2 + 1)).getValue();
            matched = false;
            for (int j = 0; j < reqFieldNames.length; ++j) {
                IAType itemType;
                ScalarFunctionCallExpression scalarFunc;
                String reqFieldName = reqFieldNames[j];
                IAType reqFieldType = reqFieldTypes[j];
                if (!fieldName.equals(reqFieldName)) continue;
                if (fieldType.equals(reqFieldType)) {
                    fieldPermutation[j] = i2;
                    openFields[i2] = false;
                    matched = true;
                    if (arg.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) break;
                    scalarFunc = (ScalarFunctionCallExpression)arg;
                    StaticTypeCastUtil.rewriteFuncExpr((AbstractFunctionCallExpression)scalarFunc, reqFieldType, fieldType, env);
                    break;
                }
                if (NonTaggedFormatUtil.isOptional((IAType)reqFieldType)) {
                    reqFieldType = itemType = ((AUnionType)reqFieldType).getActualType();
                    if (fieldType.equals(BuiltinType.AMISSING) || fieldType.equals(itemType)) {
                        fieldPermutation[j] = i2;
                        openFields[i2] = false;
                        matched = true;
                        if (arg.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) break;
                        ScalarFunctionCallExpression scalarFunc2 = (ScalarFunctionCallExpression)arg;
                        StaticTypeCastUtil.rewriteFuncExpr((AbstractFunctionCallExpression)scalarFunc2, reqFieldType, fieldType, env);
                        break;
                    }
                }
                if (NonTaggedFormatUtil.isOptional((IAType)fieldType) && reqFieldType.equals(itemType = ((AUnionType)fieldType).getActualType())) {
                    fieldPermutation[j] = i2;
                    openFields[i2] = false;
                    matched = true;
                    ScalarFunctionCallExpression notNullFunc = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CHECK_UNKNOWN));
                    notNullFunc.getArguments().add(new MutableObject((Object)arg));
                    ((Mutable)func.getArguments().get(2 * i2 + 1)).setValue((Object)notNullFunc);
                    break;
                }
                if (arg.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
                scalarFunc = (ScalarFunctionCallExpression)arg;
                StaticTypeCastUtil.rewriteFuncExpr((AbstractFunctionCallExpression)scalarFunc, reqFieldType, fieldType, env);
                fieldPermutation[j] = i2;
                openFields[i2] = false;
                matched = true;
                break;
            }
            if (matched || reqType.isOpen()) continue;
            throw new AlgebricksException("static type mismatch: the input record includes an extra closed field " + fieldName + ":" + fieldType + "! Please check the field name and type.");
        }
        for (i2 = 0; i2 < reqFieldNames.length; ++i2) {
            String reqFieldName = reqFieldNames[i2];
            IAType reqFieldType = reqFieldTypes[i2];
            matched = false;
            for (int j = 0; j < inputFieldNames.length; ++j) {
                String fieldName = inputFieldNames[j];
                IAType fieldType = inputFieldTypes[j];
                if (!fieldName.equals(reqFieldName)) continue;
                if (!openFields[j]) {
                    matched = true;
                    break;
                }
                if (!NonTaggedFormatUtil.isOptional((IAType)reqFieldType)) continue;
                IAType itemType = ((AUnionType)reqFieldType).getActualType();
                if (!fieldType.equals(BuiltinType.AMISSING) && !fieldType.equals(itemType)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            if (NonTaggedFormatUtil.isOptional((IAType)reqFieldType)) {
                nullFields[i2] = true;
                continue;
            }
            if (inputType.isOpen()) {
                return false;
            }
            throw new AlgebricksException("static type mismatch: the input record misses a required closed field " + reqFieldName + ":" + reqFieldType + "! Please check the field name and type.");
        }
        List arguments = func.getArguments();
        ArrayList originalArguments = new ArrayList();
        originalArguments.addAll(arguments);
        arguments.clear();
        for (i = 0; i < fieldPermutation.length; ++i) {
            int pos = fieldPermutation[i];
            if (pos >= 0) {
                arguments.add(originalArguments.get(2 * pos));
                arguments.add(originalArguments.get(2 * pos + 1));
            }
            if (!nullFields[i]) continue;
            arguments.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString(reqFieldNames[i])))));
            arguments.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)ANull.NULL))));
        }
        for (i = 0; i < openFields.length; ++i) {
            if (!openFields[i]) continue;
            arguments.add(originalArguments.get(2 * i));
            Mutable expRef = (Mutable)originalArguments.get(2 * i + 1);
            StaticTypeCastUtil.injectCastToRelaxType((Mutable<ILogicalExpression>)expRef, inputFieldTypes[i], env);
            arguments.add(expRef);
        }
        return true;
    }

    private static boolean injectCastToRelaxType(Mutable<ILogicalExpression> expRef, IAType inputFieldType, IVariableTypeEnvironment env) throws AlgebricksException {
        ILogicalExpression argExpr = (ILogicalExpression)expRef.getValue();
        ArrayList parameterVars = new ArrayList();
        argExpr.getUsedVariables(parameterVars);
        boolean castInjected = false;
        if (argExpr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL || argExpr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            IAType reqFieldType = inputFieldType;
            switch (inputFieldType.getTypeTag()) {
                case RECORD: {
                    reqFieldType = DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE;
                    break;
                }
                case ORDEREDLIST: {
                    reqFieldType = DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE;
                    break;
                }
                case UNORDEREDLIST: {
                    reqFieldType = DefaultOpenFieldType.NESTED_OPEN_AUNORDERED_LIST_TYPE;
                    break;
                }
            }
            if (!inputFieldType.equals(reqFieldType) && !parameterVars.isEmpty()) {
                StaticTypeCastUtil.injectCastFunction(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CAST_TYPE), reqFieldType, inputFieldType, expRef, argExpr);
                castInjected = true;
            }
            if (argExpr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && TypeCastUtils.getRequiredType((AbstractFunctionCallExpression)((AbstractFunctionCallExpression)argExpr)) == null && reqFieldType != null) {
                if (castInjected) {
                    ScalarFunctionCallExpression argFunc = (ScalarFunctionCallExpression)argExpr;
                    StaticTypeCastUtil.rewriteFuncExpr((AbstractFunctionCallExpression)argFunc, inputFieldType, inputFieldType, env);
                } else {
                    ScalarFunctionCallExpression argFunc = (ScalarFunctionCallExpression)argExpr;
                    StaticTypeCastUtil.rewriteFuncExpr((AbstractFunctionCallExpression)argFunc, reqFieldType, inputFieldType, env);
                }
            }
        }
        return castInjected;
    }

    private static void injectCastFunction(IFunctionInfo funcInfo, IAType reqType, IAType inputType, Mutable<ILogicalExpression> exprRef, ILogicalExpression argExpr) throws AlgebricksException {
        ScalarFunctionCallExpression cast = new ScalarFunctionCallExpression(funcInfo);
        cast.getArguments().add(new MutableObject((Object)argExpr));
        exprRef.setValue((Object)cast);
        TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)cast, (IAType)reqType, (IAType)inputType);
    }

    public static boolean compatible(IAType reqType, IAType inputType) {
        AUnionType unionType;
        if (reqType.getTypeTag() == ATypeTag.ANY || inputType.getTypeTag() == ATypeTag.ANY) {
            return true;
        }
        if (reqType.getTypeTag() != ATypeTag.UNION && inputType.getTypeTag() != ATypeTag.UNION) {
            return reqType.equals(inputType);
        }
        HashSet<IAType> reqTypePossible = new HashSet<IAType>();
        HashSet<IAType> inputTypePossible = new HashSet<IAType>();
        if (reqType.getTypeTag() == ATypeTag.UNION) {
            unionType = (AUnionType)reqType;
            reqTypePossible.addAll(unionType.getUnionList());
        } else {
            reqTypePossible.add(reqType);
        }
        if (inputType.getTypeTag() == ATypeTag.UNION) {
            unionType = (AUnionType)inputType;
            inputTypePossible.addAll(unionType.getUnionList());
        } else {
            inputTypePossible.add(inputType);
        }
        return reqTypePossible.equals(inputTypePossible);
    }
}

