/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.asterix.algebra.operators.CommitOperator;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.optimizer.rules.am.AbstractIntroduceAccessMethodRule;
import org.apache.asterix.optimizer.rules.am.AccessMethodAnalysisContext;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.asterix.optimizer.rules.am.BTreeAccessMethod;
import org.apache.asterix.optimizer.rules.am.IAccessMethod;
import org.apache.asterix.optimizer.rules.am.InvertedIndexAccessMethod;
import org.apache.asterix.optimizer.rules.am.OptimizableOperatorSubTree;
import org.apache.asterix.optimizer.rules.am.RTreeAccessMethod;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceSelectAccessMethodRule
extends AbstractIntroduceAccessMethodRule {
    protected Mutable<ILogicalOperator> selectRef = null;
    protected SelectOperator selectOp = null;
    protected AbstractFunctionCallExpression selectCond = null;
    protected IVariableTypeEnvironment typeEnvironment = null;
    protected final OptimizableOperatorSubTree subTree = new OptimizableOperatorSubTree();
    protected List<Mutable<ILogicalOperator>> afterSelectRefs = null;
    protected static Map<FunctionIdentifier, List<IAccessMethod>> accessMethods = new HashMap<FunctionIdentifier, List<IAccessMethod>>();

    @Override
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        this.clear();
        this.setMetadataDeclarations(context);
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        if (op.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT && op.getOperatorTag() != LogicalOperatorTag.SINK && op.getOperatorTag() != LogicalOperatorTag.DELEGATE_OPERATOR) {
            return false;
        }
        if (op.getOperatorTag() == LogicalOperatorTag.DELEGATE_OPERATOR && !(((DelegateOperator)op).getDelegate() instanceof CommitOperator)) {
            return false;
        }
        this.afterSelectRefs = new ArrayList<Mutable<ILogicalOperator>>();
        boolean planTransformed = this.checkAndApplyTheSelectTransformation(opRef, context);
        if (this.selectOp != null) {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)this.selectOp);
        }
        if (!planTransformed) {
            return false;
        }
        OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
        return planTransformed;
    }

    protected boolean checkSelectOpConditionAndInitSubTree(IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression condExpr = (ILogicalExpression)this.selectOp.getCondition().getValue();
        this.typeEnvironment = context.getOutputTypeEnvironment((ILogicalOperator)this.selectOp);
        if (condExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        this.selectCond = (AbstractFunctionCallExpression)condExpr;
        boolean res = this.subTree.initFromSubTree((Mutable<ILogicalOperator>)((Mutable)this.selectOp.getInputs().get(0)));
        return res && this.subTree.hasDataSourceScan();
    }

    private boolean intersectAllSecondaryIndexes(List<Pair<IAccessMethod, Index>> chosenIndexes, Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs, IOptimizationContext context) throws AlgebricksException {
        Pair chosenIndex = null;
        Optional<Pair> primaryIndex = chosenIndexes.stream().filter(pair -> ((Index)pair.second).isPrimaryIndex()).findFirst();
        if (chosenIndexes.size() == 1) {
            chosenIndex = chosenIndexes.get(0);
        } else if (primaryIndex.isPresent()) {
            chosenIndex = primaryIndex.get();
        }
        if (chosenIndex != null) {
            AccessMethodAnalysisContext analysisCtx = analyzedAMs.get(chosenIndex.first);
            return ((IAccessMethod)chosenIndex.first).applySelectPlanTransformation(this.afterSelectRefs, this.selectRef, this.subTree, (Index)chosenIndex.second, analysisCtx, context);
        }
        Mutable conditionRef = this.selectOp.getCondition();
        ArrayList<ILogicalOperator> subRoots = new ArrayList<ILogicalOperator>();
        for (Pair<IAccessMethod, Index> pair2 : chosenIndexes) {
            AccessMethodAnalysisContext analysisCtx = analyzedAMs.get(pair2.first);
            subRoots.add(((IAccessMethod)pair2.first).createSecondaryToPrimaryPlan((Mutable<ILogicalExpression>)conditionRef, this.subTree, null, (Index)pair2.second, analysisCtx, AccessMethodUtils.retainInputs(this.subTree.getDataSourceVariables(), (ILogicalOperator)this.subTree.getDataSourceRef().getValue(), this.afterSelectRefs), false, ((ILogicalOperator)((Mutable)((ILogicalOperator)this.subTree.getDataSourceRef().getValue()).getInputs().get(0)).getValue()).getExecutionMode() == AbstractLogicalOperator.ExecutionMode.UNPARTITIONED, context));
        }
        ILogicalOperator primaryUnnestOp = this.connectAll2ndarySearchPlanWithIntersect(subRoots, context);
        this.subTree.getDataSourceRef().setValue((Object)primaryUnnestOp);
        return primaryUnnestOp != null;
    }

    private ILogicalOperator connectAll2ndarySearchPlanWithIntersect(List<ILogicalOperator> subRoots, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator lop = subRoots.get(0);
        ArrayList inputVars = new ArrayList(subRoots.size());
        for (int i = 0; i < subRoots.size(); ++i) {
            if (lop.getOperatorTag() != subRoots.get(i).getOperatorTag()) {
                throw new AlgebricksException("The data source root should have the same operator type.");
            }
            if (lop.getInputs().size() != 1) {
                throw new AlgebricksException("The primary search has multiple inputs.");
            }
            ILogicalOperator curRoot = subRoots.get(i);
            OrderOperator order = (OrderOperator)((Mutable)curRoot.getInputs().get(0)).getValue();
            ArrayList<LogicalVariable> orderedColumn = new ArrayList<LogicalVariable>(order.getOrderExpressions().size());
            for (Pair orderExpression : order.getOrderExpressions()) {
                if (((ILogicalExpression)((Mutable)orderExpression.second).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                    throw new AlgebricksException("The order by expression should be variables, but they aren't variables.");
                }
                VariableReferenceExpression orderedVar = (VariableReferenceExpression)((Mutable)orderExpression.second).getValue();
                orderedColumn.add(orderedVar.getVariableReference());
            }
            inputVars.add(orderedColumn);
        }
        List outputVar = (List)inputVars.get(0);
        IntersectOperator intersect = new IntersectOperator(outputVar, inputVars);
        for (ILogicalOperator secondarySearch : subRoots) {
            intersect.getInputs().add(secondarySearch.getInputs().get(0));
        }
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)intersect);
        lop.getInputs().set(0, new MutableObject((Object)intersect));
        return lop;
    }

    protected boolean checkAndApplyTheSelectTransformation(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        boolean isSelectOp = false;
        Mutable<ILogicalOperator> selectRefFromThisOp = null;
        SelectOperator selectOpFromThisOp = null;
        if (op.getOperatorTag() == LogicalOperatorTag.SELECT) {
            this.selectRef = opRef;
            this.selectOp = (SelectOperator)op;
            selectRefFromThisOp = opRef;
            selectOpFromThisOp = (SelectOperator)op;
            isSelectOp = true;
        } else {
            this.afterSelectRefs.add(opRef);
        }
        for (Mutable inputOpRef : op.getInputs()) {
            boolean selectFoundAndOptimizationApplied = this.checkAndApplyTheSelectTransformation((Mutable<ILogicalOperator>)inputOpRef, context);
            if (!selectFoundAndOptimizationApplied) continue;
            return true;
        }
        if (isSelectOp) {
            this.selectRef = selectRefFromThisOp;
            this.selectOp = selectOpFromThisOp;
            boolean continueCheck = true;
            if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)this.selectOp)) {
                continueCheck = false;
            }
            TreeMap<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs = null;
            if (continueCheck) {
                analyzedAMs = new TreeMap<IAccessMethod, AccessMethodAnalysisContext>();
            }
            if (continueCheck && !this.checkSelectOpConditionAndInitSubTree(context)) {
                continueCheck = false;
            }
            if (continueCheck && !this.analyzeSelectOrJoinOpConditionAndUpdateAnalyzedAM((ILogicalExpression)this.selectCond, this.subTree.getAssignsAndUnnests(), analyzedAMs, context, this.typeEnvironment)) {
                continueCheck = false;
            }
            if (continueCheck && !this.subTree.setDatasetAndTypeMetadata((MetadataProvider)context.getMetadataProvider())) {
                continueCheck = false;
            }
            if (continueCheck) {
                this.fillSubTreeIndexExprs(this.subTree, analyzedAMs, context);
                this.pruneIndexCandidates(analyzedAMs, context, this.typeEnvironment);
                List<Pair<IAccessMethod, Index>> chosenIndexes = this.chooseAllIndexes(analyzedAMs);
                if (chosenIndexes == null || chosenIndexes.isEmpty()) {
                    context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)this.selectRef.getValue());
                    return false;
                }
                boolean res = this.intersectAllSecondaryIndexes(chosenIndexes, analyzedAMs, context);
                context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)this.selectOp);
                if (res) {
                    OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
                    return res;
                }
            }
            this.selectRef = null;
            this.selectOp = null;
            this.afterSelectRefs.add(opRef);
        }
        this.afterSelectRefs.remove(opRef);
        return false;
    }

    @Override
    public Map<FunctionIdentifier, List<IAccessMethod>> getAccessMethods() {
        return accessMethods;
    }

    private void clear() {
        this.afterSelectRefs = null;
        this.selectRef = null;
        this.selectOp = null;
        this.selectCond = null;
        this.subTree.reset();
    }

    static {
        IntroduceSelectAccessMethodRule.registerAccessMethod(BTreeAccessMethod.INSTANCE, accessMethods);
        IntroduceSelectAccessMethodRule.registerAccessMethod(RTreeAccessMethod.INSTANCE, accessMethods);
        IntroduceSelectAccessMethodRule.registerAccessMethod(InvertedIndexAccessMethod.INSTANCE, accessMethods);
    }
}

