/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.FeedDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.feeds.BuiltinFeedPolicies;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.rules.util.EquivalenceClassUtils;
import org.apache.asterix.translator.util.PlanTranslationUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IVariableContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class UnnestToDataScanRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return false;
        }
        UnnestOperator unnest = (UnnestOperator)op;
        ILogicalExpression unnestExpr = (ILogicalExpression)unnest.getExpressionRef().getValue();
        if (unnestExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        return this.handleFunction(opRef, context, unnest, (AbstractFunctionCallExpression)unnestExpr);
    }

    protected boolean handleFunction(Mutable<ILogicalOperator> opRef, IOptimizationContext context, UnnestOperator unnest, AbstractFunctionCallExpression f) throws AlgebricksException {
        FunctionIdentifier fid = f.getFunctionIdentifier();
        if (fid.equals((Object)BuiltinFunctions.DATASET)) {
            if (unnest.getPositionalVariable() != null) {
                throw new AlgebricksException("No positional variables are allowed over datasets.");
            }
            ILogicalExpression expr = (ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
                return false;
            }
            ConstantExpression ce = (ConstantExpression)expr;
            IAlgebricksConstantValue acv = ce.getValue();
            if (!(acv instanceof AsterixConstantValue)) {
                return false;
            }
            AsterixConstantValue acv2 = (AsterixConstantValue)acv;
            if (acv2.getObject().getType().getTypeTag() != ATypeTag.STRING) {
                return false;
            }
            String datasetArg = ((AString)acv2.getObject()).getStringValue();
            MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
            Pair<String, String> datasetReference = this.parseDatasetReference(metadataProvider, datasetArg);
            String dataverseName = (String)datasetReference.first;
            String datasetName = (String)datasetReference.second;
            Dataset dataset = metadataProvider.findDataset(dataverseName, datasetName);
            if (dataset == null) {
                throw new AlgebricksException("Could not find dataset " + datasetName + " in dataverse " + dataverseName);
            }
            DataSourceId asid = new DataSourceId(dataverseName, datasetName);
            ArrayList<LogicalVariable> variables = new ArrayList<LogicalVariable>();
            if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                int numPrimaryKeys = DatasetUtil.getPartitioningKeys((Dataset)dataset).size();
                for (int i = 0; i < numPrimaryKeys; ++i) {
                    variables.add(context.newVar());
                }
            }
            variables.add(unnest.getVariable());
            DataSource dataSource = metadataProvider.findDataSource(asid);
            boolean hasMeta = dataSource.hasMeta();
            if (hasMeta) {
                variables.add(context.newVar());
            }
            DataSourceScanOperator scan = new DataSourceScanOperator(variables, (IDataSource)dataSource);
            List scanInpList = scan.getInputs();
            scanInpList.addAll(unnest.getInputs());
            opRef.setValue((Object)scan);
            this.addPrimaryKey(variables, dataSource, context);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)scan);
            IAType[] schemaTypes = dataSource.getSchemaTypes();
            ARecordType recordType = (ARecordType)(hasMeta ? schemaTypes[schemaTypes.length - 2] : schemaTypes[schemaTypes.length - 1]);
            ARecordType metaRecordType = (ARecordType)(hasMeta ? schemaTypes[schemaTypes.length - 1] : null);
            EquivalenceClassUtils.addEquivalenceClassesForPrimaryIndexAccess((ILogicalOperator)scan, variables, recordType, metaRecordType, dataset, context);
            return true;
        }
        if (fid.equals((Object)BuiltinFunctions.FEED_COLLECT)) {
            if (unnest.getPositionalVariable() != null) {
                throw new AlgebricksException("No positional variables are allowed over feeds.");
            }
            String dataverse = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)f, (int)0);
            String sourceFeedName = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)f, (int)1);
            String getTargetFeed = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)f, (int)2);
            String subscriptionLocation = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)f, (int)3);
            String targetDataset = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)f, (int)4);
            String outputType = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)f, (int)5);
            MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
            DataSourceId asid = new DataSourceId(dataverse, getTargetFeed);
            String policyName = (String)metadataProvider.getConfig().get("feed-policy-name");
            FeedPolicyEntity policy = metadataProvider.findFeedPolicy(dataverse, policyName);
            if (policy == null && (policy = BuiltinFeedPolicies.getFeedPolicy((String)policyName)) == null) {
                throw new AlgebricksException("Unknown feed policy:" + policyName);
            }
            ArrayList<LogicalVariable> feedDataScanOutputVariables = new ArrayList<LogicalVariable>();
            String csLocations = (String)metadataProvider.getConfig().get("collect-locations");
            ArrayList<LogicalVariable> pkVars = new ArrayList<LogicalVariable>();
            FeedDataSource ds = this.createFeedDataSource(asid, targetDataset, sourceFeedName, subscriptionLocation, metadataProvider, policy, outputType, csLocations, unnest.getVariable(), context, pkVars);
            feedDataScanOutputVariables.add(unnest.getVariable());
            if (ds.hasMeta()) {
                feedDataScanOutputVariables.add(context.newVar());
            }
            if (ds.isChange()) {
                feedDataScanOutputVariables.addAll(pkVars);
            }
            DataSourceScanOperator scan = new DataSourceScanOperator(feedDataScanOutputVariables, (IDataSource)ds);
            List scanInpList = scan.getInputs();
            scanInpList.addAll(unnest.getInputs());
            opRef.setValue((Object)scan);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)scan);
            return true;
        }
        return false;
    }

    private void addPrimaryKey(List<LogicalVariable> scanVariables, DataSource dataSource, IOptimizationContext context) {
        List primaryKey = dataSource.getPrimaryKeyVariables(scanVariables);
        ArrayList<LogicalVariable> tail = new ArrayList<LogicalVariable>();
        tail.addAll(scanVariables);
        FunctionalDependency pk = new FunctionalDependency(primaryKey, tail);
        context.addPrimaryKey(pk);
    }

    private FeedDataSource createFeedDataSource(DataSourceId aqlId, String targetDataset, String sourceFeedName, String subscriptionLocation, MetadataProvider metadataProvider, FeedPolicyEntity feedPolicy, String outputType, String locations, LogicalVariable recordVar, IOptimizationContext context, List<LogicalVariable> pkVars) throws AlgebricksException {
        ArrayList keyAccessScalarFunctionCallExpression;
        if (!aqlId.getDataverseName().equals(metadataProvider.getDefaultDataverse() == null ? null : metadataProvider.getDefaultDataverse().getDataverseName())) {
            return null;
        }
        Dataset dataset = metadataProvider.findDataset(aqlId.getDataverseName(), targetDataset);
        ARecordType feedOutputType = (ARecordType)metadataProvider.findType(aqlId.getDataverseName(), outputType);
        Feed sourceFeed = metadataProvider.findFeed(aqlId.getDataverseName(), sourceFeedName);
        FeedConnection feedConnection = metadataProvider.findFeedConnection(aqlId.getDataverseName(), sourceFeedName, targetDataset);
        ARecordType metaType = null;
        if (dataset.hasMetaPart()) {
            String metaTypeName = FeedUtils.getFeedMetaTypeName((Map)sourceFeed.getAdapterConfiguration());
            if (metaTypeName == null) {
                throw new AlgebricksException("Feed to a dataset with metadata doesn't have meta type specified");
            }
            String dataverseName = aqlId.getDataverseName();
            if (metaTypeName.contains(".")) {
                dataverseName = metaTypeName.substring(0, metaTypeName.indexOf(46));
                metaTypeName = metaTypeName.substring(metaTypeName.indexOf(46) + 1);
            }
            metaType = (ARecordType)metadataProvider.findType(dataverseName, metaTypeName);
        }
        List pkTypes = null;
        List partitioningKeys = null;
        List keySourceIndicator = null;
        ArrayList<Mutable<ILogicalExpression>> keyAccessExpression = null;
        if (ExternalDataUtils.isChangeFeed((Map)sourceFeed.getAdapterConfiguration())) {
            keyAccessExpression = new ArrayList<Mutable<ILogicalExpression>>();
            keyAccessScalarFunctionCallExpression = new ArrayList();
            pkTypes = ((InternalDatasetDetails)dataset.getDatasetDetails()).getPrimaryKeyType();
            partitioningKeys = ((InternalDatasetDetails)dataset.getDatasetDetails()).getPartitioningKey();
            if (dataset.hasMetaPart()) {
                keySourceIndicator = ((InternalDatasetDetails)dataset.getDatasetDetails()).getKeySourceIndicator();
            }
            for (int i = 0; i < partitioningKeys.size(); ++i) {
                List key = (List)partitioningKeys.get(i);
                if (keySourceIndicator == null || (Integer)keySourceIndicator.get(i) == 0) {
                    PlanTranslationUtil.prepareVarAndExpression(key, recordVar, pkVars, keyAccessExpression, null, (IVariableContext)context);
                    continue;
                }
                PlanTranslationUtil.prepareMetaKeyAccessExpression(key, recordVar, keyAccessExpression, pkVars, null, (IVariableContext)context);
            }
            keyAccessExpression.forEach(expr -> keyAccessScalarFunctionCallExpression.add((ScalarFunctionCallExpression)expr.getValue()));
        } else {
            keyAccessExpression = null;
            keyAccessScalarFunctionCallExpression = null;
        }
        FeedDataSource feedDataSource = new FeedDataSource(sourceFeed, aqlId, targetDataset, (IAType)feedOutputType, (IAType)metaType, pkTypes, partitioningKeys, keyAccessScalarFunctionCallExpression, sourceFeed.getFeedId(), FeedUtils.FeedRuntimeType.valueOf((String)subscriptionLocation), locations.split(","), context.getComputationNodeDomain(), feedConnection);
        feedDataSource.getProperties().put("policy", feedPolicy);
        return feedDataSource;
    }

    private Pair<String, String> parseDatasetReference(MetadataProvider metadataProvider, String datasetArg) throws AlgebricksException {
        String datasetName;
        String dataverseName;
        String[] datasetNameComponents = datasetArg.split("\\.");
        if (datasetNameComponents.length == 1) {
            Dataverse defaultDataverse = metadataProvider.getDefaultDataverse();
            if (defaultDataverse == null) {
                throw new AlgebricksException("Unresolved dataset " + datasetArg + " Dataverse not specified.");
            }
            dataverseName = defaultDataverse.getDataverseName();
            datasetName = datasetNameComponents[0];
        } else {
            dataverseName = datasetNameComponents[0];
            datasetName = datasetNameComponents[1];
        }
        return new Pair((Object)dataverseName, (Object)datasetName);
    }
}

