/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.algebra.operators.CommitOperator;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceDynamicTypeCastRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        boolean cast;
        LogicalVariable recordVar;
        ARecordType requiredRecordType;
        AbstractLogicalOperator op;
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        switch (op1.getOperatorTag()) {
            case SINK: 
            case DELEGATE_OPERATOR: {
                DelegateOperator eOp;
                if (op1.getOperatorTag() == LogicalOperatorTag.DELEGATE_OPERATOR && !((eOp = (DelegateOperator)op1).getDelegate() instanceof CommitOperator)) {
                    return false;
                }
                AbstractLogicalOperator op2 = (AbstractLogicalOperator)((Mutable)op1.getInputs().get(0)).getValue();
                if (op2.getOperatorTag() == LogicalOperatorTag.INSERT_DELETE_UPSERT) {
                    InsertDeleteUpsertOperator insertDeleteOp = (InsertDeleteUpsertOperator)op2;
                    if (insertDeleteOp.getOperation() == InsertDeleteUpsertOperator.Kind.DELETE) {
                        return false;
                    }
                    op = insertDeleteOp;
                    InsertDeleteUpsertOperator insertDeleteOperator = (InsertDeleteUpsertOperator)op2;
                    DataSource dataSource = (DataSource)insertDeleteOperator.getDataSource();
                    requiredRecordType = (ARecordType)dataSource.getItemType();
                    ILogicalExpression expr = (ILogicalExpression)insertDeleteOperator.getPayloadExpression().getValue();
                    ArrayList payloadVars = new ArrayList();
                    expr.getUsedVariables(payloadVars);
                    recordVar = (LogicalVariable)payloadVars.get(0);
                    break;
                }
                return false;
            }
            case DISTRIBUTE_RESULT: {
                requiredRecordType = (ARecordType)op1.getAnnotations().get("output-record-type");
                if (requiredRecordType == null) {
                    return false;
                }
                op = op1;
                recordVar = ((VariableReferenceExpression)((Mutable)((DistributeResultOperator)op).getExpressions().get(0)).getValue()).getVariableReference();
                break;
            }
            default: {
                return false;
            }
        }
        IVariableTypeEnvironment env = op.computeOutputTypeEnvironment((ITypingContext)context);
        IAType inputRecordType = (IAType)env.getVarType(recordVar);
        boolean checkUnknown = false;
        while (NonTaggedFormatUtil.isOptional((IAType)inputRecordType)) {
            inputRecordType = ((AUnionType)inputRecordType).getActualType();
            checkUnknown = true;
        }
        boolean bl = cast = !IntroduceDynamicTypeCastRule.compatible(requiredRecordType, inputRecordType);
        if (checkUnknown) {
            recordVar = IntroduceDynamicTypeCastRule.addWrapperFunction(requiredRecordType, recordVar, (ILogicalOperator)op, context, BuiltinFunctions.CHECK_UNKNOWN);
        }
        if (cast) {
            IntroduceDynamicTypeCastRule.addWrapperFunction(requiredRecordType, recordVar, (ILogicalOperator)op, context, BuiltinFunctions.CAST_TYPE);
        }
        return cast || checkUnknown;
    }

    public static LogicalVariable addWrapperFunction(ARecordType requiredRecordType, LogicalVariable recordVar, ILogicalOperator parent, IOptimizationContext context, FunctionIdentifier fd) throws AlgebricksException {
        List opRefs = parent.getInputs();
        for (int index = 0; index < opRefs.size(); ++index) {
            Mutable opRef = (Mutable)opRefs.get(index);
            ILogicalOperator op = (ILogicalOperator)opRef.getValue();
            ArrayList producedVars = new ArrayList();
            VariableUtilities.getProducedVariables((ILogicalOperator)op, producedVars);
            IVariableTypeEnvironment env = op.computeOutputTypeEnvironment((ITypingContext)context);
            for (int i = 0; i < producedVars.size(); ++i) {
                LogicalVariable var = (LogicalVariable)producedVars.get(i);
                if (!var.equals((Object)recordVar)) continue;
                IAType actualType = (IAType)env.getVarType(var);
                ScalarFunctionCallExpression cast = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)fd));
                cast.getArguments().add(new MutableObject((Object)new VariableReferenceExpression(var)));
                TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)cast, (IAType)requiredRecordType, (IAType)actualType);
                LogicalVariable newAssignVar = context.newVar();
                AssignOperator newAssignOperator = new AssignOperator(newAssignVar, (Mutable)new MutableObject((Object)cast));
                newAssignOperator.getInputs().add(new MutableObject((Object)op));
                opRef.setValue((Object)newAssignOperator);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newAssignOperator);
                newAssignOperator.computeOutputTypeEnvironment((ITypingContext)context);
                VariableUtilities.substituteVariables((ILogicalOperator)parent, (LogicalVariable)recordVar, (LogicalVariable)newAssignVar, (ITypingContext)context);
                return newAssignVar;
            }
            LogicalVariable replacedVar = IntroduceDynamicTypeCastRule.addWrapperFunction(requiredRecordType, recordVar, op, context, fd);
            if (replacedVar == null) continue;
            VariableUtilities.substituteVariables((ILogicalOperator)parent, (LogicalVariable)recordVar, (LogicalVariable)replacedVar, (ITypingContext)context);
            return replacedVar;
        }
        return null;
    }

    public static boolean compatible(ARecordType reqType, IAType inputType) throws AlgebricksException {
        if (inputType.getTypeTag() == ATypeTag.ANY) {
            return false;
        }
        if (inputType.getTypeTag() != ATypeTag.RECORD) {
            throw new AlgebricksException("The input type " + inputType + " is not a valid record type!");
        }
        ARecordType inputRecType = (ARecordType)inputType;
        if (reqType.isOpen() != inputRecType.isOpen()) {
            return false;
        }
        IAType[] reqTypes = reqType.getFieldTypes();
        String[] reqFieldNames = reqType.getFieldNames();
        IAType[] inputTypes = inputRecType.getFieldTypes();
        String[] inputFieldNames = ((ARecordType)inputType).getFieldNames();
        if (reqTypes.length != inputTypes.length) {
            return false;
        }
        for (int i = 0; i < reqTypes.length; ++i) {
            if (!reqFieldNames[i].equals(inputFieldNames[i])) {
                return false;
            }
            IAType reqTypeInside = reqTypes[i];
            if (NonTaggedFormatUtil.isOptional((IAType)reqTypes[i])) {
                reqTypeInside = ((AUnionType)reqTypes[i]).getActualType();
            }
            IAType inputTypeInside = inputTypes[i];
            if (NonTaggedFormatUtil.isOptional((IAType)inputTypes[i])) {
                if (!NonTaggedFormatUtil.isOptional((IAType)reqTypes[i])) {
                    return false;
                }
                inputTypeInside = ((AUnionType)inputTypes[i]).getActualType();
            }
            if (inputTypeInside.getTypeTag() == ATypeTag.MISSING || reqTypeInside.equals(inputTypeInside)) continue;
            return false;
        }
        return true;
    }
}

