/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import org.apache.asterix.metadata.functions.ExternalScalarFunctionInfo;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.optimizer.rules.IntroduceDynamicTypeCastRule;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceDynamicTypeCastForExternalFunctionRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        boolean cast;
        ScalarFunctionCallExpression funcExpr;
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT) {
            return false;
        }
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)((Mutable)op1.getInputs().get(0)).getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.PROJECT) {
            return false;
        }
        AbstractLogicalOperator op3 = (AbstractLogicalOperator)((Mutable)op2.getInputs().get(0)).getValue();
        if (op3.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        AbstractLogicalOperator op4 = (AbstractLogicalOperator)((Mutable)op3.getInputs().get(0)).getValue();
        if (op4.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        AssignOperator assignOp1 = (AssignOperator)op3;
        AssignOperator assignOp2 = (AssignOperator)op4;
        FunctionIdentifier fid = null;
        ILogicalExpression assignExpr = (ILogicalExpression)((Mutable)assignOp2.getExpressions().get(0)).getValue();
        if (assignExpr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            funcExpr = (ScalarFunctionCallExpression)((Mutable)assignOp2.getExpressions().get(0)).getValue();
            fid = funcExpr.getFunctionIdentifier();
            if (fid != BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR) {
                return false;
            }
        } else {
            return false;
        }
        assignExpr = (ILogicalExpression)((Mutable)assignOp1.getExpressions().get(0)).getValue();
        funcExpr = null;
        if (assignExpr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            funcExpr = (ScalarFunctionCallExpression)((Mutable)assignOp1.getExpressions().get(0)).getValue();
            fid = funcExpr.getFunctionIdentifier();
            if (BuiltinFunctions.getBuiltinFunctionIdentifier((FunctionIdentifier)fid) != null) {
                return false;
            }
        } else {
            return false;
        }
        ExternalScalarFunctionInfo finfo = (ExternalScalarFunctionInfo)funcExpr.getFunctionInfo();
        ARecordType requiredRecordType = (ARecordType)finfo.getArgumenTypes().get(0);
        ArrayList<LogicalVariable> recordVar = new ArrayList<LogicalVariable>();
        recordVar.addAll(assignOp2.getVariables());
        IVariableTypeEnvironment env = assignOp2.computeOutputTypeEnvironment((ITypingContext)context);
        IAType inputRecordType = (IAType)env.getVarType((LogicalVariable)recordVar.get(0));
        boolean checkUnknown = false;
        while (NonTaggedFormatUtil.isOptional((IAType)inputRecordType)) {
            inputRecordType = ((AUnionType)inputRecordType).getActualType();
            checkUnknown = true;
        }
        boolean bl = cast = !IntroduceDynamicTypeCastRule.compatible(requiredRecordType, inputRecordType);
        if (checkUnknown) {
            recordVar.set(0, IntroduceDynamicTypeCastRule.addWrapperFunction(requiredRecordType, (LogicalVariable)recordVar.get(0), (ILogicalOperator)assignOp1, context, BuiltinFunctions.CHECK_UNKNOWN));
        }
        if (cast) {
            IntroduceDynamicTypeCastRule.addWrapperFunction(requiredRecordType, (LogicalVariable)recordVar.get(0), (ILogicalOperator)assignOp1, context, BuiltinFunctions.CAST_TYPE);
        }
        return cast || checkUnknown;
    }
}

