/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jobgen;

import java.util.List;
import org.apache.asterix.common.functions.FunctionDescriptorTag;
import org.apache.asterix.external.library.ExternalFunctionDescriptorProvider;
import org.apache.asterix.formats.base.IDataFormat;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.runtime.formats.FormatUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ILogicalExpressionJobGen;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.ISerializedAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.ColumnAccessEvalFactory;

public class QueryLogicalExpressionJobGen
implements ILogicalExpressionJobGen {
    public static final QueryLogicalExpressionJobGen INSTANCE = new QueryLogicalExpressionJobGen();

    private QueryLogicalExpressionJobGen() {
    }

    public IAggregateEvaluatorFactory createAggregateFunctionFactory(AggregateFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        IScalarEvaluatorFactory[] args = this.codegenArguments((AbstractFunctionCallExpression)expr, env, inputSchemas, context);
        IFunctionDescriptor fd = this.getFunctionDescriptor((AbstractFunctionCallExpression)expr, env, context);
        switch (fd.getFunctionDescriptorTag()) {
            case SERIALAGGREGATE: {
                return null;
            }
            case AGGREGATE: {
                return fd.createAggregateEvaluatorFactory(args);
            }
        }
        throw new IllegalStateException("Invalid function descriptor " + fd.getFunctionDescriptorTag() + " expected " + FunctionDescriptorTag.SERIALAGGREGATE + " or " + FunctionDescriptorTag.AGGREGATE);
    }

    public IRunningAggregateEvaluatorFactory createRunningAggregateFunctionFactory(StatefulFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        IScalarEvaluatorFactory[] args = this.codegenArguments((AbstractFunctionCallExpression)expr, env, inputSchemas, context);
        return this.getFunctionDescriptor((AbstractFunctionCallExpression)expr, env, context).createRunningAggregateEvaluatorFactory(args);
    }

    public IUnnestingEvaluatorFactory createUnnestingFunctionFactory(UnnestingFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        IScalarEvaluatorFactory[] args = this.codegenArguments((AbstractFunctionCallExpression)expr, env, inputSchemas, context);
        return this.getFunctionDescriptor((AbstractFunctionCallExpression)expr, env, context).createUnnestingEvaluatorFactory(args);
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(ILogicalExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        IScalarEvaluatorFactory copyEvaluatorFactory = null;
        switch (expr.getExpressionTag()) {
            case VARIABLE: {
                VariableReferenceExpression v = (VariableReferenceExpression)expr;
                copyEvaluatorFactory = this.createVariableEvaluatorFactory(v, inputSchemas, context);
                return copyEvaluatorFactory;
            }
            case CONSTANT: {
                ConstantExpression c = (ConstantExpression)expr;
                copyEvaluatorFactory = this.createConstantEvaluatorFactory(c, inputSchemas, context);
                return copyEvaluatorFactory;
            }
            case FUNCTION_CALL: {
                copyEvaluatorFactory = this.createScalarFunctionEvaluatorFactory((AbstractFunctionCallExpression)expr, env, inputSchemas, context);
                return copyEvaluatorFactory;
            }
        }
        throw new IllegalStateException();
    }

    private IScalarEvaluatorFactory createVariableEvaluatorFactory(VariableReferenceExpression expr, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        LogicalVariable variable = expr.getVariableReference();
        for (IOperatorSchema scm : inputSchemas) {
            int pos = scm.findVariable(variable);
            if (pos < 0) continue;
            return new ColumnAccessEvalFactory(pos);
        }
        throw new AlgebricksException("Variable " + variable + " could not be found in any input schema.");
    }

    private IScalarEvaluatorFactory createScalarFunctionEvaluatorFactory(AbstractFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        IScalarEvaluatorFactory[] args = this.codegenArguments(expr, env, inputSchemas, context);
        IFunctionDescriptor fd = null;
        if (!(expr.getFunctionInfo() instanceof IExternalFunctionInfo)) {
            IDataFormat format = FormatUtils.getDefaultFormat();
            fd = format.resolveFunction((ILogicalExpression)expr, env);
        } else {
            fd = ExternalFunctionDescriptorProvider.getExternalFunctionDescriptor((IExternalFunctionInfo)((IExternalFunctionInfo)expr.getFunctionInfo()));
        }
        return fd.createEvaluatorFactory(args);
    }

    private IScalarEvaluatorFactory createConstantEvaluatorFactory(ConstantExpression expr, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        IDataFormat format = FormatUtils.getDefaultFormat();
        return format.getConstantEvalFactory(expr.getValue());
    }

    private IScalarEvaluatorFactory[] codegenArguments(AbstractFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        List arguments = expr.getArguments();
        int n = arguments.size();
        IScalarEvaluatorFactory[] args = new IScalarEvaluatorFactory[n];
        int i = 0;
        for (Mutable a : arguments) {
            args[i++] = this.createEvaluatorFactory((ILogicalExpression)a.getValue(), env, inputSchemas, context);
        }
        return args;
    }

    public ISerializedAggregateEvaluatorFactory createSerializableAggregateFunctionFactory(AggregateFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        IScalarEvaluatorFactory[] args = this.codegenArguments((AbstractFunctionCallExpression)expr, env, inputSchemas, context);
        IFunctionDescriptor fd = this.getFunctionDescriptor((AbstractFunctionCallExpression)expr, env, context);
        switch (fd.getFunctionDescriptorTag()) {
            case AGGREGATE: {
                if (BuiltinFunctions.isAggregateFunctionSerializable((FunctionIdentifier)fd.getIdentifier())) {
                    AggregateFunctionCallExpression serialAggExpr = BuiltinFunctions.makeSerializableAggregateFunctionExpression((FunctionIdentifier)fd.getIdentifier(), (List)expr.getArguments());
                    IFunctionDescriptor afdd = this.getFunctionDescriptor((AbstractFunctionCallExpression)serialAggExpr, env, context);
                    return afdd.createSerializableAggregateEvaluatorFactory(args);
                }
                throw new AlgebricksException("Trying to create a serializable aggregate from a non-serializable aggregate function descriptor. (fi=" + expr.getFunctionIdentifier() + ")");
            }
            case SERIALAGGREGATE: {
                return fd.createSerializableAggregateEvaluatorFactory(args);
            }
        }
        throw new IllegalStateException("Invalid function descriptor " + fd.getFunctionDescriptorTag() + " expected " + FunctionDescriptorTag.SERIALAGGREGATE + " or " + FunctionDescriptorTag.AGGREGATE);
    }

    private IFunctionDescriptor getFunctionDescriptor(AbstractFunctionCallExpression expr, IVariableTypeEnvironment env, JobGenContext context) throws AlgebricksException {
        IFunctionDescriptor fd = FormatUtils.getDefaultFormat().resolveFunction((ILogicalExpression)expr, env);
        return fd;
    }
}

