/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.event.error;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.asterix.event.management.IOutputHandler;
import org.apache.asterix.event.management.OutputAnalysis;
import org.apache.asterix.event.model.EventList;
import org.apache.asterix.event.schema.pattern.Event;

public class OutputHandler
implements IOutputHandler {
    public static IOutputHandler INSTANCE = new OutputHandler();

    private OutputHandler() {
    }

    @Override
    public OutputAnalysis reportEventOutput(Event event, String output) {
        EventList.EventType eventType = EventList.EventType.valueOf(event.getType().toUpperCase());
        boolean ignore = true;
        String trimmedOutput = output.trim();
        StringBuilder errorMessage = new StringBuilder();
        switch (eventType) {
            case FILE_TRANSFER: {
                if (trimmedOutput.length() <= 0 || !output.contains("Permission denied") && !output.contains("cannot find or open")) break;
                ignore = false;
                break;
            }
            case BACKUP: 
            case RESTORE: {
                if (trimmedOutput.length() <= 0) break;
                if (trimmedOutput.contains("AccessControlException")) {
                    errorMessage.append("Insufficient permissions on back up directory");
                }
                ignore = output.contains("does not exist") || output.contains("File exist") || output.contains("No such file or directory");
                break;
            }
            case NODE_INFO: {
                Properties p = new Properties();
                try {
                    p.load(new ByteArrayInputStream(trimmedOutput.getBytes()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                String javaVersion = (String)p.get("java_version");
                if (p.get("java_version") == null) {
                    errorMessage.append("Java not installed on " + event.getNodeid().getValue().getAbsvalue());
                    ignore = false;
                    break;
                }
                if (javaVersion.contains("1.7")) break;
                errorMessage.append("Asterix requires Java 1.7.x. Incompatible version found on  " + event.getNodeid().getValue().getAbsvalue() + "\n");
                ignore = false;
                break;
            }
        }
        return ignore ? new OutputAnalysis(true, null) : new OutputAnalysis(false, errorMessage.toString());
    }
}

