/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.common.shutdown.ShutdownRun;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.hyracks.ipc.exceptions.IPCException;

public class ClusterShutdownWork
extends SynchronizableWork {
    private static final Logger LOGGER = Logger.getLogger(ClusterShutdownWork.class.getName());
    private final ClusterControllerService ccs;
    private final boolean terminateNCService;
    private final IResultCallback<Boolean> callback;

    public ClusterShutdownWork(ClusterControllerService ncs, boolean terminateNCService, IResultCallback<Boolean> callback) {
        this.ccs = ncs;
        this.terminateNCService = terminateNCService;
        this.callback = callback;
    }

    public void doRun() {
        try {
            if (this.ccs.getShutdownRun() != null) {
                throw new IPCException("Shutdown already in progress");
            }
            INodeManager nodeManager = this.ccs.getNodeManager();
            Collection<String> nodeIds = nodeManager.getAllNodeIds();
            final ShutdownRun shutdownStatus = new ShutdownRun(nodeIds);
            this.ccs.setShutdownRun(shutdownStatus);
            nodeManager.apply(this::shutdownNode);
            this.ccs.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        LOGGER.info("Waiting for NCs to shutdown...");
                        boolean cleanShutdown = shutdownStatus.waitForCompletion();
                        if (!cleanShutdown) {
                            LOGGER.severe("Clean shutdown of NCs timed out- giving up; unresponsive nodes: " + shutdownStatus.getRemainingNodes());
                        }
                        ClusterShutdownWork.this.callback.setValue((Object)cleanShutdown);
                        ClusterShutdownWork.this.ccs.stop(ClusterShutdownWork.this.terminateNCService);
                        LOGGER.info("JVM Exiting.. Bye!");
                        Runtime rt = Runtime.getRuntime();
                        rt.exit(cleanShutdown ? 0 : 1);
                    }
                    catch (Exception e) {
                        ClusterShutdownWork.this.callback.setException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            this.callback.setException(e);
        }
    }

    protected void shutdownNode(String nodeId, NodeControllerState ncState) {
        try {
            LOGGER.info("Notifying NC " + nodeId + " to shutdown...");
            ncState.getNodeController().shutdown(this.terminateNCService);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception shutting down NC " + nodeId + " (possibly dead?), continuing shutdown...", e);
        }
    }
}

