/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.job;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.api.constraints.Constraint;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.OperatorDescriptorId;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicy;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.ActivityCluster;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.ActivityClusterId;
import org.apache.hyracks.api.job.IActivityClusterGraphGenerator;
import org.apache.hyracks.api.job.IActivityClusterGraphGeneratorFactory;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.PreDistributedJobStore;
import org.apache.hyracks.control.cc.executor.ActivityPartitionDetails;
import org.apache.hyracks.control.cc.executor.JobExecutor;
import org.apache.hyracks.control.cc.job.ActivityClusterPlan;
import org.apache.hyracks.control.cc.job.ActivityPlan;
import org.apache.hyracks.control.cc.job.IJobStatusConditionVariable;
import org.apache.hyracks.control.cc.job.Task;
import org.apache.hyracks.control.cc.job.TaskAttempt;
import org.apache.hyracks.control.cc.job.TaskCluster;
import org.apache.hyracks.control.cc.job.TaskClusterAttempt;
import org.apache.hyracks.control.cc.partitions.PartitionMatchMaker;
import org.apache.hyracks.control.common.job.profiling.om.JobProfile;
import org.apache.hyracks.control.common.utils.ExceptionUtils;

public class JobRun
implements IJobStatusConditionVariable {
    private final DeploymentId deploymentId;
    private final JobId jobId;
    private final JobSpecification spec;
    private final ActivityClusterGraph acg;
    private JobExecutor scheduler;
    private final Set<JobFlag> jobFlags;
    private final Map<ActivityClusterId, ActivityClusterPlan> activityClusterPlanMap;
    private final PartitionMatchMaker pmm;
    private final Set<String> participatingNodeIds;
    private final Set<String> cleanupPendingNodeIds;
    private final JobProfile profile;
    private final Map<ConnectorDescriptorId, IConnectorPolicy> connectorPolicyMap;
    private long createTime;
    private long startTime;
    private long endTime;
    private JobStatus status;
    private List<Exception> exceptions;
    private JobStatus pendingStatus;
    private List<Exception> pendingExceptions;
    private Map<OperatorDescriptorId, Map<Integer, String>> operatorLocations;

    private JobRun(DeploymentId deploymentId, JobId jobId, Set<JobFlag> jobFlags, JobSpecification spec, ActivityClusterGraph acg) {
        this.deploymentId = deploymentId;
        this.jobId = jobId;
        this.jobFlags = jobFlags;
        this.spec = spec;
        this.acg = acg;
        this.activityClusterPlanMap = new HashMap<ActivityClusterId, ActivityClusterPlan>();
        this.pmm = new PartitionMatchMaker();
        this.participatingNodeIds = new HashSet<String>();
        this.cleanupPendingNodeIds = new HashSet<String>();
        this.profile = new JobProfile(jobId);
        this.connectorPolicyMap = new HashMap<ConnectorDescriptorId, IConnectorPolicy>();
        this.operatorLocations = new HashMap<OperatorDescriptorId, Map<Integer, String>>();
        this.createTime = System.currentTimeMillis();
    }

    public JobRun(ClusterControllerService ccs, DeploymentId deploymentId, JobId jobId, PreDistributedJobStore.PreDistributedJobDescriptor distributedJobDescriptor) throws HyracksException {
        this(deploymentId, jobId, EnumSet.noneOf(JobFlag.class), distributedJobDescriptor.getJobSpecification(), distributedJobDescriptor.getActivityClusterGraph());
        Set<Constraint> constaints = distributedJobDescriptor.getActivityClusterGraphConstraints();
        this.scheduler = new JobExecutor(ccs, this, constaints, true);
    }

    public JobRun(ClusterControllerService ccs, DeploymentId deploymentId, JobId jobId, IActivityClusterGraphGeneratorFactory acggf, IActivityClusterGraphGenerator acgg, Set<JobFlag> jobFlags) {
        this(deploymentId, jobId, jobFlags, acggf.getJobSpecification(), acgg.initialize());
        this.scheduler = new JobExecutor(ccs, this, acgg.getConstraints(), false);
    }

    public DeploymentId getDeploymentId() {
        return this.deploymentId;
    }

    public JobSpecification getJobSpecification() {
        return this.spec;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public ActivityClusterGraph getActivityClusterGraph() {
        return this.acg;
    }

    public Set<JobFlag> getFlags() {
        return this.jobFlags;
    }

    public Map<ActivityClusterId, ActivityClusterPlan> getActivityClusterPlanMap() {
        return this.activityClusterPlanMap;
    }

    public PartitionMatchMaker getPartitionMatchMaker() {
        return this.pmm;
    }

    public synchronized void setStatus(JobStatus status, List<Exception> exceptions) {
        this.status = status;
        this.exceptions = exceptions;
        this.notifyAll();
    }

    public synchronized JobStatus getStatus() {
        return this.status;
    }

    public synchronized List<Exception> getExceptions() {
        return this.exceptions;
    }

    public void setPendingStatus(JobStatus status, List<Exception> exceptions) {
        this.pendingStatus = status;
        this.pendingExceptions = exceptions;
    }

    public JobStatus getPendingStatus() {
        return this.pendingStatus;
    }

    public synchronized List<Exception> getPendingExceptions() {
        return this.pendingExceptions;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void registerOperatorLocation(OperatorDescriptorId op, int partition, String location) {
        Map<Integer, String> locations = this.operatorLocations.get(op);
        if (locations == null) {
            locations = new HashMap<Integer, String>();
            this.operatorLocations.put(op, locations);
        }
        locations.put(partition, location);
    }

    @Override
    public synchronized void waitForCompletion() throws Exception {
        while (this.status != JobStatus.TERMINATED && this.status != JobStatus.FAILURE) {
            this.wait();
        }
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            HyracksException he = HyracksException.create((Throwable)this.exceptions.get(0));
            for (int i = 1; i < this.exceptions.size(); ++i) {
                he.addSuppressed((Throwable)this.exceptions.get(i));
            }
            throw he;
        }
    }

    public Set<String> getParticipatingNodeIds() {
        return this.participatingNodeIds;
    }

    public Set<String> getCleanupPendingNodeIds() {
        return this.cleanupPendingNodeIds;
    }

    public JobProfile getJobProfile() {
        return this.profile;
    }

    public JobExecutor getExecutor() {
        return this.scheduler;
    }

    public Map<ConnectorDescriptorId, IConnectorPolicy> getConnectorPolicyMap() {
        return this.connectorPolicyMap;
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode result = om.createObjectNode();
        result.put("job-id", this.jobId.toString());
        result.putPOJO("status", (Object)this.getStatus());
        result.put("create-time", this.getCreateTime());
        result.put("start-time", this.getStartTime());
        result.put("end-time", this.getEndTime());
        ArrayNode aClusters = om.createArrayNode();
        for (ActivityCluster ac : this.acg.getActivityClusterMap().values()) {
            Object aid2;
            ObjectNode acJSON = om.createObjectNode();
            acJSON.put("activity-cluster-id", String.valueOf(ac.getId()));
            ArrayNode activitiesJSON = om.createArrayNode();
            for (Object aid2 : ac.getActivityMap().keySet()) {
                activitiesJSON.addPOJO(aid2);
            }
            acJSON.set("activities", (JsonNode)activitiesJSON);
            ArrayNode dependenciesJSON = om.createArrayNode();
            aid2 = ac.getDependencies().iterator();
            while (aid2.hasNext()) {
                ActivityCluster dependency = (ActivityCluster)aid2.next();
                dependenciesJSON.add(String.valueOf(dependency.getId()));
            }
            acJSON.set("dependencies", (JsonNode)dependenciesJSON);
            ActivityClusterPlan acp = this.activityClusterPlanMap.get(ac.getId());
            if (acp == null) {
                acJSON.putNull("plan");
            } else {
                Object outPartCounts;
                ObjectNode planJSON = om.createObjectNode();
                ArrayNode acTasks = om.createArrayNode();
                for (Map.Entry<ActivityId, ActivityPlan> e : acp.getActivityPlanMap().entrySet()) {
                    ActivityPlan acPlan = e.getValue();
                    ObjectNode entry = om.createObjectNode();
                    entry.put("activity-id", e.getKey().toString());
                    ActivityPartitionDetails apd = acPlan.getActivityPartitionDetails();
                    entry.put("partition-count", apd.getPartitionCount());
                    ArrayNode inPartCountsJSON = om.createArrayNode();
                    int[] inPartCounts = apd.getInputPartitionCounts();
                    if (inPartCounts != null) {
                        for (int i : inPartCounts) {
                            inPartCountsJSON.add(i);
                        }
                    }
                    entry.set("input-partition-counts", (JsonNode)inPartCountsJSON);
                    ArrayNode outPartCountsJSON = om.createArrayNode();
                    outPartCounts = apd.getOutputPartitionCounts();
                    if (outPartCounts != null) {
                        for (int o : outPartCounts) {
                            outPartCountsJSON.add(o);
                        }
                    }
                    entry.set("output-partition-counts", (JsonNode)outPartCountsJSON);
                    ArrayNode tasks = om.createArrayNode();
                    Task[] i = acPlan.getTasks();
                    int n = i.length;
                    for (int o = 0; o < n; ++o) {
                        Task t = i[o];
                        ObjectNode task = om.createObjectNode();
                        task.put("task-id", t.getTaskId().toString());
                        ArrayNode dependentTasksJSON = om.createArrayNode();
                        for (TaskId dependent : t.getDependents()) {
                            dependentTasksJSON.add(dependent.toString());
                            task.set("dependents", (JsonNode)dependentTasksJSON);
                            ArrayNode dependencyTasksJSON = om.createArrayNode();
                            for (TaskId dependency : t.getDependencies()) {
                                dependencyTasksJSON.add(dependency.toString());
                            }
                            task.set("dependencies", (JsonNode)dependencyTasksJSON);
                            tasks.add((JsonNode)task);
                        }
                        entry.set("tasks", (JsonNode)tasks);
                        acTasks.add((JsonNode)entry);
                    }
                }
                planJSON.set("activities", (JsonNode)acTasks);
                ArrayNode tClusters = om.createArrayNode();
                for (TaskCluster tc : acp.getTaskClusters()) {
                    ObjectNode c = om.createObjectNode();
                    c.put("task-cluster-id", String.valueOf(tc.getTaskClusterId()));
                    ArrayNode tasksAry = om.createArrayNode();
                    for (ArrayNode t : tc.getTasks()) {
                        tasksAry.add(t.getTaskId().toString());
                    }
                    c.set("tasks", (JsonNode)tasksAry);
                    ArrayNode prodParts = om.createArrayNode();
                    outPartCounts = tc.getProducedPartitions().iterator();
                    while (outPartCounts.hasNext()) {
                        PartitionId p = (PartitionId)outPartCounts.next();
                        prodParts.add(p.toString());
                    }
                    c.set("produced-partitions", (JsonNode)prodParts);
                    ArrayNode reqdParts = om.createArrayNode();
                    for (PartitionId p : tc.getRequiredPartitions()) {
                        reqdParts.add(p.toString());
                    }
                    c.set("required-partitions", (JsonNode)reqdParts);
                    ArrayNode attempts = om.createArrayNode();
                    List<TaskClusterAttempt> tcAttempts = tc.getAttempts();
                    if (tcAttempts != null) {
                        for (TaskClusterAttempt tca : tcAttempts) {
                            ObjectNode attempt = om.createObjectNode();
                            attempt.put("attempt", tca.getAttempt());
                            attempt.putPOJO("status", (Object)tca.getStatus());
                            attempt.put("start-time", tca.getStartTime());
                            attempt.put("end-time", tca.getEndTime());
                            ArrayNode taskAttempts = om.createArrayNode();
                            for (TaskAttempt ta : tca.getTaskAttempts().values()) {
                                ObjectNode taskAttempt = om.createObjectNode();
                                taskAttempt.putPOJO("task-id", (Object)ta.getTaskAttemptId().getTaskId());
                                taskAttempt.putPOJO("task-attempt-id", (Object)ta.getTaskAttemptId());
                                taskAttempt.putPOJO("status", (Object)ta.getStatus());
                                taskAttempt.put("node-id", ta.getNodeId());
                                taskAttempt.put("start-time", ta.getStartTime());
                                taskAttempt.put("end-time", ta.getEndTime());
                                List<Exception> exceptions = ta.getExceptions();
                                if (exceptions != null && !exceptions.isEmpty()) {
                                    List filteredExceptions = ExceptionUtils.getActualExceptions(exceptions);
                                    for (Exception exception : filteredExceptions) {
                                        StringWriter exceptionWriter = new StringWriter();
                                        exception.printStackTrace(new PrintWriter(exceptionWriter));
                                        taskAttempt.put("failure-details", exceptionWriter.toString());
                                    }
                                }
                                taskAttempts.add((JsonNode)taskAttempt);
                            }
                            attempt.set("task-attempts", (JsonNode)taskAttempts);
                            attempts.add((JsonNode)attempt);
                        }
                    }
                    c.set("attempts", (JsonNode)attempts);
                    tClusters.add((JsonNode)c);
                }
                planJSON.set("task-clusters", (JsonNode)tClusters);
                acJSON.set("plan", (JsonNode)planJSON);
            }
            aClusters.add((JsonNode)acJSON);
        }
        result.set("activity-clusters", (JsonNode)aClusters);
        result.set("profile", (JsonNode)this.profile.toJSON());
        return result;
    }

    public Map<OperatorDescriptorId, Map<Integer, String>> getOperatorLocations() {
        return this.operatorLocations;
    }
}

