/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.dataset;

import org.apache.hyracks.api.dataset.DatasetDirectoryRecord;
import org.apache.hyracks.api.dataset.DatasetJobRecord;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.control.cc.dataset.Waiter;
import org.apache.hyracks.control.cc.dataset.Waiters;
import org.apache.hyracks.control.common.work.IResultCallback;

class JobResultInfo {
    private DatasetJobRecord record;
    private Waiters waiters;

    JobResultInfo(DatasetJobRecord record, Waiters waiters) {
        this.record = record;
        this.waiters = waiters;
    }

    DatasetJobRecord getRecord() {
        return this.record;
    }

    void addWaiter(ResultSetId rsId, DatasetDirectoryRecord[] knownRecords, IResultCallback<DatasetDirectoryRecord[]> callback) {
        if (this.waiters == null) {
            this.waiters = new Waiters();
        }
        this.waiters.put(rsId, new Waiter(knownRecords, callback));
    }

    Waiter removeWaiter(ResultSetId rsId) {
        return (Waiter)this.waiters.remove(rsId);
    }

    Waiter getWaiter(ResultSetId rsId) {
        return this.waiters != null ? (Waiter)this.waiters.get(rsId) : null;
    }

    void setException(Exception exception) {
        if (this.waiters != null) {
            for (ResultSetId rsId : this.waiters.keySet()) {
                ((Waiter)this.waiters.remove((Object)rsId)).callback.setException(exception);
            }
        }
    }

    public String toString() {
        return this.record.toString();
    }
}

