/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.application.ICCApplication;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.client.ClusterControllerInfo;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.context.ICCContext;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.resource.IJobCapacityController;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.hyracks.api.topology.ClusterTopology;
import org.apache.hyracks.api.topology.TopologyDefinitionParser;
import org.apache.hyracks.control.cc.BaseCCApplication;
import org.apache.hyracks.control.cc.ClientInterfaceIPCI;
import org.apache.hyracks.control.cc.ClusterControllerIPCI;
import org.apache.hyracks.control.cc.PreDistributedJobStore;
import org.apache.hyracks.control.cc.application.CCServiceContext;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.cc.cluster.NodeManager;
import org.apache.hyracks.control.cc.dataset.DatasetDirectoryService;
import org.apache.hyracks.control.cc.dataset.IDatasetDirectoryService;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobManager;
import org.apache.hyracks.control.cc.scheduler.IResourceManager;
import org.apache.hyracks.control.cc.scheduler.ResourceManager;
import org.apache.hyracks.control.cc.web.WebServer;
import org.apache.hyracks.control.cc.work.GatherStateDumpsWork;
import org.apache.hyracks.control.cc.work.GetIpAddressNodeNameMapWork;
import org.apache.hyracks.control.cc.work.GetThreadDumpWork;
import org.apache.hyracks.control.cc.work.RemoveDeadNodesWork;
import org.apache.hyracks.control.cc.work.ShutdownNCServiceWork;
import org.apache.hyracks.control.cc.work.TriggerNCWork;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.context.ServerContext;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.common.deployment.DeploymentRun;
import org.apache.hyracks.control.common.ipc.CCNCFunctions;
import org.apache.hyracks.control.common.logs.LogFile;
import org.apache.hyracks.control.common.shutdown.ShutdownRun;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.hyracks.control.common.work.WorkQueue;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.hyracks.ipc.api.IPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.impl.IPCSystem;
import org.apache.hyracks.ipc.impl.JavaSerializationBasedPayloadSerializerDeserializer;
import org.xml.sax.InputSource;

public class ClusterControllerService
implements IControllerService {
    private static final Logger LOGGER = Logger.getLogger(ClusterControllerService.class.getName());
    private final CCConfig ccConfig;
    private final ConfigManager configManager;
    private IPCSystem clusterIPC;
    private IPCSystem clientIPC;
    private final LogFile jobLog;
    private ServerContext serverCtx;
    private WebServer webServer;
    private ClusterControllerInfo info;
    private CCServiceContext serviceCtx;
    private final PreDistributedJobStore preDistributedJobStore = new PreDistributedJobStore();
    private final WorkQueue workQueue;
    private ExecutorService executor;
    private final Timer timer;
    private final ICCContext ccContext;
    private final DeadNodeSweeper sweeper;
    private final IDatasetDirectoryService datasetDirectoryService;
    private final Map<DeploymentId, DeploymentRun> deploymentRunMap;
    private final Map<String, GatherStateDumpsWork.StateDumpRun> stateDumpRunMap;
    private final Map<String, GetThreadDumpWork.ThreadDumpRun> threadDumpRunMap;
    private final INodeManager nodeManager;
    private final IResourceManager resourceManager = new ResourceManager();
    private IJobManager jobManager;
    private ShutdownRun shutdownCallback;
    private final ICCApplication application;

    public ClusterControllerService(CCConfig config) throws Exception {
        this(config, ClusterControllerService.getApplication(config));
    }

    public ClusterControllerService(CCConfig config, ICCApplication application) throws Exception {
        this.ccConfig = config;
        this.configManager = this.ccConfig.getConfigManager();
        if (application == null) {
            throw new IllegalArgumentException("ICCApplication cannot be null");
        }
        this.application = application;
        this.configManager.processConfig();
        File jobLogFolder = new File(this.ccConfig.getRootDir(), "logs/jobs");
        this.jobLog = new LogFile(jobLogFolder);
        this.workQueue = new WorkQueue("ClusterController", 10);
        this.timer = new Timer(true);
        ClusterTopology topology = ClusterControllerService.computeClusterTopology(this.ccConfig);
        this.ccContext = new ClusterControllerContext(topology);
        this.sweeper = new DeadNodeSweeper();
        this.datasetDirectoryService = new DatasetDirectoryService(this.ccConfig.getResultTTL(), this.ccConfig.getResultSweepThreshold());
        this.deploymentRunMap = new HashMap<DeploymentId, DeploymentRun>();
        this.stateDumpRunMap = new HashMap<String, GatherStateDumpsWork.StateDumpRun>();
        this.threadDumpRunMap = Collections.synchronizedMap(new HashMap());
        this.nodeManager = new NodeManager(this.ccConfig, this.resourceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClusterTopology computeClusterTopology(CCConfig ccConfig) throws Exception {
        if (ccConfig.getClusterTopology() == null) {
            return null;
        }
        FileReader fr = new FileReader(ccConfig.getClusterTopology());
        InputSource in = new InputSource(fr);
        try {
            ClusterTopology clusterTopology = TopologyDefinitionParser.parse((InputSource)in);
            return clusterTopology;
        }
        finally {
            fr.close();
        }
    }

    public void start() throws Exception {
        LOGGER.log(Level.INFO, "Starting ClusterControllerService: " + this);
        this.serverCtx = new ServerContext(ServerContext.ServerType.CLUSTER_CONTROLLER, new File(this.ccConfig.getRootDir()));
        ClusterControllerIPCI ccIPCI = new ClusterControllerIPCI(this);
        this.clusterIPC = new IPCSystem(new InetSocketAddress(this.ccConfig.getClusterListenPort()), (IIPCI)ccIPCI, (IPayloadSerializerDeserializer)new CCNCFunctions.SerializerDeserializer());
        ClientInterfaceIPCI ciIPCI = new ClientInterfaceIPCI(this);
        this.clientIPC = new IPCSystem(new InetSocketAddress(this.ccConfig.getClientListenAddress(), this.ccConfig.getClientListenPort()), (IIPCI)ciIPCI, (IPayloadSerializerDeserializer)new JavaSerializationBasedPayloadSerializerDeserializer());
        this.webServer = new WebServer(this, this.ccConfig.getConsoleListenPort());
        this.clusterIPC.start();
        this.clientIPC.start();
        this.webServer.start();
        this.info = new ClusterControllerInfo(this.ccConfig.getClientListenAddress(), this.ccConfig.getClientListenPort(), this.webServer.getListeningPort());
        this.timer.schedule((TimerTask)this.sweeper, 0L, (long)this.ccConfig.getHeartbeatPeriod());
        this.jobLog.open();
        this.startApplication();
        this.datasetDirectoryService.init(this.executor);
        this.workQueue.start();
        this.connectNCs();
        LOGGER.log(Level.INFO, "Started ClusterControllerService");
        this.notifyApplication();
    }

    private void startApplication() throws Exception {
        this.serviceCtx = new CCServiceContext(this, this.serverCtx, this.ccContext, this.ccConfig.getAppConfig());
        this.serviceCtx.addJobLifecycleListener(this.datasetDirectoryService);
        this.executor = Executors.newCachedThreadPool(this.serviceCtx.getThreadFactory());
        this.application.start((IServiceContext)this.serviceCtx, this.ccConfig.getAppArgsArray());
        IJobCapacityController jobCapacityController = this.application.getJobCapacityController();
        try {
            Constructor<?> jobManagerConstructor = this.getClass().getClassLoader().loadClass(this.ccConfig.getJobManagerClass()).getConstructor(CCConfig.class, ClusterControllerService.class, IJobCapacityController.class);
            this.jobManager = (IJobManager)jobManagerConstructor.newInstance(this.ccConfig, this, jobCapacityController);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "class " + this.ccConfig.getJobManagerClass() + " could not be used: ", e);
            }
            this.jobManager = new JobManager(this.ccConfig, this, jobCapacityController);
        }
    }

    private Map<String, Pair<String, Integer>> getNCServices() throws IOException {
        TreeMap<String, Pair<String, Integer>> ncMap = new TreeMap<String, Pair<String, Integer>>();
        for (String ncId : this.configManager.getNodeNames()) {
            IApplicationConfig ncConfig = this.configManager.getNodeEffectiveConfig(ncId);
            if (ncConfig.getBoolean((IOption)NCConfig.Option.VIRTUAL_NC)) continue;
            ncMap.put(ncId, (Pair<String, Integer>)Pair.of((Object)ncConfig.getString((IOption)NCConfig.Option.NCSERVICE_ADDRESS), (Object)ncConfig.getInt((IOption)NCConfig.Option.NCSERVICE_PORT)));
        }
        return ncMap;
    }

    private void connectNCs() throws IOException {
        this.getNCServices().entrySet().forEach(ncService -> {
            TriggerNCWork triggerWork = new TriggerNCWork(this, (String)((Pair)ncService.getValue()).getLeft(), (Integer)((Pair)ncService.getValue()).getRight(), (String)ncService.getKey());
            this.workQueue.schedule((AbstractWork)triggerWork);
        });
    }

    private void terminateNCServices() throws Exception {
        ArrayList shutdownNCServiceWorks = new ArrayList();
        this.getNCServices().entrySet().forEach(ncService -> {
            ShutdownNCServiceWork shutdownWork = new ShutdownNCServiceWork((String)((Pair)ncService.getValue()).getLeft(), (Integer)((Pair)ncService.getValue()).getRight(), (String)ncService.getKey());
            this.workQueue.schedule((AbstractWork)shutdownWork);
            shutdownNCServiceWorks.add(shutdownWork);
        });
        for (ShutdownNCServiceWork shutdownWork : shutdownNCServiceWorks) {
            shutdownWork.sync();
        }
    }

    private void notifyApplication() throws Exception {
        this.application.startupCompleted();
    }

    public void stop(boolean terminateNCService) throws Exception {
        if (terminateNCService) {
            this.terminateNCServices();
        }
        this.stop();
    }

    public void stop() throws Exception {
        LOGGER.log(Level.INFO, "Stopping ClusterControllerService");
        this.stopApplication();
        this.webServer.stop();
        this.sweeper.cancel();
        this.workQueue.stop();
        this.executor.shutdownNow();
        this.clusterIPC.stop();
        this.jobLog.close();
        this.clientIPC.stop();
        LOGGER.log(Level.INFO, "Stopped ClusterControllerService");
    }

    private void stopApplication() throws Exception {
        this.application.stop();
    }

    public ServerContext getServerContext() {
        return this.serverCtx;
    }

    public ICCContext getCCContext() {
        return this.ccContext;
    }

    public IJobManager getJobManager() {
        return this.jobManager;
    }

    public INodeManager getNodeManager() {
        return this.nodeManager;
    }

    public PreDistributedJobStore getPreDistributedJobStore() throws HyracksException {
        return this.preDistributedJobStore;
    }

    public IResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public LogFile getJobLogFile() {
        return this.jobLog;
    }

    public WorkQueue getWorkQueue() {
        return this.workQueue;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public CCConfig getConfig() {
        return this.ccConfig;
    }

    public CCServiceContext getContext() {
        return this.serviceCtx;
    }

    public ClusterControllerInfo getClusterControllerInfo() {
        return this.info;
    }

    public CCConfig getCCConfig() {
        return this.ccConfig;
    }

    public IPCSystem getClusterIPC() {
        return this.clusterIPC;
    }

    public NetworkAddress getDatasetDirectoryServiceInfo() {
        return new NetworkAddress(this.ccConfig.getClientListenAddress(), this.ccConfig.getClientListenPort());
    }

    public IDatasetDirectoryService getDatasetDirectoryService() {
        return this.datasetDirectoryService;
    }

    public synchronized void addStateDumpRun(String id, GatherStateDumpsWork.StateDumpRun sdr) {
        this.stateDumpRunMap.put(id, sdr);
    }

    public synchronized GatherStateDumpsWork.StateDumpRun getStateDumpRun(String id) {
        return this.stateDumpRunMap.get(id);
    }

    public synchronized void removeStateDumpRun(String id) {
        this.stateDumpRunMap.remove(id);
    }

    public synchronized void addDeploymentRun(DeploymentId deploymentKey, DeploymentRun dRun) {
        this.deploymentRunMap.put(deploymentKey, dRun);
    }

    public synchronized DeploymentRun getDeploymentRun(DeploymentId deploymentKey) {
        return this.deploymentRunMap.get(deploymentKey);
    }

    public synchronized void removeDeploymentRun(DeploymentId deploymentKey) {
        this.deploymentRunMap.remove(deploymentKey);
    }

    public synchronized void setShutdownRun(ShutdownRun sRun) {
        this.shutdownCallback = sRun;
    }

    public synchronized ShutdownRun getShutdownRun() {
        return this.shutdownCallback;
    }

    public void addThreadDumpRun(String requestKey, GetThreadDumpWork.ThreadDumpRun tdr) {
        this.threadDumpRunMap.put(requestKey, tdr);
    }

    public GetThreadDumpWork.ThreadDumpRun removeThreadDumpRun(String requestKey) {
        return this.threadDumpRunMap.remove(requestKey);
    }

    private static ICCApplication getApplication(CCConfig ccConfig) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (ccConfig.getAppClass() != null) {
            Class<?> c = Class.forName(ccConfig.getAppClass());
            return (ICCApplication)c.newInstance();
        }
        return BaseCCApplication.INSTANCE;
    }

    public ICCApplication getApplication() {
        return this.application;
    }

    public Object getApplicationContext() {
        return this.application.getApplicationContext();
    }

    private class DeadNodeSweeper
    extends TimerTask {
        private DeadNodeSweeper() {
        }

        @Override
        public void run() {
            ClusterControllerService.this.workQueue.schedule((AbstractWork)new RemoveDeadNodesWork(ClusterControllerService.this));
        }
    }

    private final class ClusterControllerContext
    implements ICCContext {
        private final ClusterTopology topology;

        private ClusterControllerContext(ClusterTopology topology) {
            this.topology = topology;
        }

        public void getIPAddressNodeMap(Map<InetAddress, Set<String>> map) throws HyracksDataException {
            GetIpAddressNodeNameMapWork ginmw = new GetIpAddressNodeNameMapWork(ClusterControllerService.this.getNodeManager(), map);
            try {
                ClusterControllerService.this.workQueue.scheduleAndSync((SynchronizableWork)ginmw);
            }
            catch (Exception e) {
                throw new HyracksDataException((Throwable)e);
            }
        }

        public ClusterControllerInfo getClusterControllerInfo() {
            return ClusterControllerService.this.info;
        }

        public ClusterTopology getClusterTopology() {
            return this.topology;
        }
    }
}

