/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.hdfs2.dataflow;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class FileSplitsFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] splitBytes;
    private String splitClassName;

    public FileSplitsFactory(List<FileSplit> splits) throws HyracksDataException {
        this.splitBytes = this.splitsToBytes(splits);
        if (splits.size() > 0) {
            this.splitClassName = splits.get(0).getClass().getName();
        }
    }

    public List<FileSplit> getSplits() throws HyracksDataException {
        return this.bytesToSplits(this.splitBytes);
    }

    private byte[] splitsToBytes(List<FileSplit> splits) throws HyracksDataException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeInt(splits.size());
            int size = splits.size();
            for (int i = 0; i < size; ++i) {
                splits.get(i).write((DataOutput)dos);
            }
            dos.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    private List<FileSplit> bytesToSplits(byte[] bytes) throws HyracksDataException {
        try {
            Class<?> splitClass = Class.forName(this.splitClassName);
            Constructor<?>[] constructors = splitClass.getDeclaredConstructors();
            Constructor<?> defaultConstructor = null;
            for (Constructor<?> constructor : constructors) {
                if (constructor.getParameterTypes().length != 0) continue;
                constructor.setAccessible(true);
                defaultConstructor = constructor;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bis);
            int size = dis.readInt();
            ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
            for (int i = 0; i < size; ++i) {
                splits.add((FileSplit)defaultConstructor.newInstance(new Object[0]));
                ((FileSplit)splits.get(i)).readFields((DataInput)dis);
            }
            dis.close();
            return splits;
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }
}

