/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.hdfs.scheduler;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.topology.ClusterTopology;
import org.apache.hyracks.hdfs.api.INcCollection;
import org.apache.hyracks.hdfs.api.INcCollectionBuilder;

public class RackAwareNcCollectionBuilder
implements INcCollectionBuilder {
    private static final Logger LOGGER = Logger.getLogger(RackAwareNcCollectionBuilder.class.getName());
    private ClusterTopology topology;

    public RackAwareNcCollectionBuilder(ClusterTopology topology) {
        this.topology = topology;
    }

    @Override
    public INcCollection build(Map<String, NodeControllerInfo> ncNameToNcInfos, Map<String, List<String>> ipToNcMapping, final Map<String, Integer> ncNameToIndex, String[] NCs, final int[] workloads, final int slotLimit) {
        try {
            final HashMap pathToNCs = new HashMap();
            for (int i = 0; i < NCs.length; ++i) {
                ArrayList<String> ncs;
                ArrayList<Integer> path = new ArrayList<Integer>();
                String ipAddress = InetAddress.getByAddress(ncNameToNcInfos.get(NCs[i]).getNetworkAddress().lookupIpAddress()).getHostAddress();
                this.topology.lookupNetworkTerminal(ipAddress, path);
                if (path.size() <= 0) {
                    path.add(Integer.MIN_VALUE);
                    LOGGER.info(NCs[i] + "'s IP address is not in the cluster toplogy file!");
                }
                if ((ncs = (ArrayList<String>)pathToNCs.get(path)) == null) {
                    ncs = new ArrayList<String>();
                    pathToNCs.put(path, ncs);
                }
                ncs.add(NCs[i]);
            }
            final TreeMap<List<Integer>, IntWritable> availableIpsToSlots = new TreeMap<List<Integer>, IntWritable>(new Comparator<List<Integer>>(){

                @Override
                public int compare(List<Integer> l1, List<Integer> l2) {
                    int commonLength = Math.min(l1.size(), l2.size());
                    for (int i = 0; i < commonLength; ++i) {
                        int cmp;
                        Integer value1 = l1.get(i);
                        Integer value2 = l2.get(i);
                        int n = value1 > value2 ? 1 : (cmp = value1 < value2 ? -1 : 0);
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return l1.size() > l2.size() ? 1 : (l1.size() < l2.size() ? -1 : 0);
                }
            });
            for (int i = 0; i < workloads.length; ++i) {
                IntWritable availableSlot;
                if (workloads[i] >= slotLimit) continue;
                ArrayList<Integer> path = new ArrayList<Integer>();
                String ipAddress = InetAddress.getByAddress(ncNameToNcInfos.get(NCs[i]).getNetworkAddress().lookupIpAddress()).getHostAddress();
                this.topology.lookupNetworkTerminal(ipAddress, path);
                if (path.size() <= 0) {
                    path.add(Integer.MIN_VALUE);
                }
                if ((availableSlot = (IntWritable)availableIpsToSlots.get(path)) == null) {
                    availableSlot = new IntWritable(slotLimit - workloads[i]);
                    availableIpsToSlots.put(path, availableSlot);
                    continue;
                }
                availableSlot.set(slotLimit - workloads[i] + availableSlot.get());
            }
            return new INcCollection(){

                @Override
                public String findNearestAvailableSlot(InputSplit split) {
                    try {
                        String[] locs = split.getLocations();
                        int minDistance = Integer.MAX_VALUE;
                        List currentCandidatePath = null;
                        if (locs == null || locs.length > 0) {
                            for (int j = 0; j < locs.length; ++j) {
                                InetAddress[] allIps = InetAddress.getAllByName(locs[j]);
                                boolean inTopology = false;
                                for (InetAddress ip : allIps) {
                                    int distance;
                                    ArrayList<Integer> splitPath = new ArrayList<Integer>();
                                    boolean inCluster = RackAwareNcCollectionBuilder.this.topology.lookupNetworkTerminal(ip.getHostAddress(), splitPath);
                                    if (!inCluster) continue;
                                    inTopology = true;
                                    List candidatePath = availableIpsToSlots.floorKey(splitPath);
                                    if (candidatePath == null) {
                                        candidatePath = availableIpsToSlots.ceilingKey(splitPath);
                                    }
                                    if (candidatePath == null || ((IntWritable)availableIpsToSlots.get(candidatePath)).get() <= 0 || minDistance <= (distance = this.distance(splitPath, candidatePath))) continue;
                                    minDistance = distance;
                                    currentCandidatePath = candidatePath;
                                }
                                if (inTopology) continue;
                                LOGGER.info(locs[j] + "'s IP address is not in the cluster toplogy file!");
                                List candidatePath = null;
                                for (Map.Entry entry : availableIpsToSlots.entrySet()) {
                                    if (((IntWritable)entry.getValue()).get() <= 0) continue;
                                    candidatePath = (List)entry.getKey();
                                    break;
                                }
                                if (candidatePath == null || ((IntWritable)availableIpsToSlots.get(candidatePath)).get() <= 0) continue;
                                currentCandidatePath = candidatePath;
                            }
                        } else {
                            for (Map.Entry entry : availableIpsToSlots.entrySet()) {
                                if (((IntWritable)entry.getValue()).get() <= 0) continue;
                                currentCandidatePath = (List)entry.getKey();
                                break;
                            }
                        }
                        if (currentCandidatePath != null && currentCandidatePath.size() > 0) {
                            IntWritable availableSlot = (IntWritable)availableIpsToSlots.get(currentCandidatePath);
                            availableSlot.set(availableSlot.get() - 1);
                            if (availableSlot.get() == 0) {
                                availableIpsToSlots.remove(currentCandidatePath);
                            }
                            List candidateNcs = (List)pathToNCs.get(currentCandidatePath);
                            for (String candidate : candidateNcs) {
                                int ncIndex = (Integer)ncNameToIndex.get(candidate);
                                if (workloads[ncIndex] >= slotLimit) continue;
                                return candidate;
                            }
                        }
                        return null;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }

                @Override
                public int numAvailableSlots() {
                    return availableIpsToSlots.size();
                }

                private int distance(List<Integer> splitPath, List<Integer> candidatePath) {
                    int commonLength = Math.min(splitPath.size(), candidatePath.size());
                    int distance = 0;
                    for (int i = 0; i < commonLength; ++i) {
                        distance = distance * 100 + Math.abs(splitPath.get(i) - candidatePath.get(i));
                    }
                    List<Integer> restElements = splitPath.size() > candidatePath.size() ? splitPath : candidatePath;
                    for (int i = commonLength; i < restElements.size(); ++i) {
                        distance = distance * 100 + Math.abs(restElements.get(i));
                    }
                    return distance;
                }
            };
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

