/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.common.deployment.DeploymentUtils;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;

public class DistributeJobWork
extends AbstractWork {
    private final NodeControllerService ncs;
    private final byte[] acgBytes;
    private final JobId jobId;

    public DistributeJobWork(NodeControllerService ncs, JobId jobId, byte[] acgBytes) {
        this.ncs = ncs;
        this.jobId = jobId;
        this.acgBytes = acgBytes;
    }

    public void run() {
        try {
            this.ncs.checkForDuplicateDistributedJob(this.jobId);
            ActivityClusterGraph acg = (ActivityClusterGraph)DeploymentUtils.deserialize((byte[])this.acgBytes, null, (IServiceContext)this.ncs.getContext());
            this.ncs.storeActivityClusterGraph(this.jobId, acg);
        }
        catch (HyracksException e) {
            try {
                this.ncs.getClusterController().notifyDistributedJobFailure(this.jobId, this.ncs.getId());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

