/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.task;

import java.lang.management.ThreadMXBean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.control.common.utils.ThreadDumpHelper;
import org.apache.hyracks.control.nc.NodeControllerService;

public class ThreadDumpTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ThreadDumpTask.class.getName());
    private final NodeControllerService ncs;
    private final String requestId;

    public ThreadDumpTask(NodeControllerService ncs, String requestId) {
        this.ncs = ncs;
        this.requestId = requestId;
    }

    @Override
    public void run() {
        String result;
        try {
            result = ThreadDumpHelper.takeDumpJSON((ThreadMXBean)this.ncs.getThreadMXBean());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception taking thread dump", e);
            result = null;
        }
        try {
            this.ncs.getClusterController().notifyThreadDump(this.ncs.getContext().getNodeId(), this.requestId, result);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception sending thread dump to CC", e);
        }
    }
}

