/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.io;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileDeviceComputer;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOFuture;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.control.nc.io.DefaultDeviceComputer;
import org.apache.hyracks.control.nc.io.FileHandle;

public class IOManager
implements IIOManager {
    private static final String WORKSPACE_FILE_SUFFIX = ".waf";
    private static final FilenameFilter WORKSPACE_FILES_FILTER = (dir, name) -> name.endsWith(WORKSPACE_FILE_SUFFIX);
    private final List<IODeviceHandle> ioDevices;
    private final List<IODeviceHandle> workspaces;
    private Executor executor;
    private int workspaceIndex;
    private IFileDeviceComputer deviceComputer;

    public IOManager(List<IODeviceHandle> devices, Executor executor) throws HyracksDataException {
        this(devices);
        this.executor = executor;
    }

    public IOManager(List<IODeviceHandle> devices) throws HyracksDataException {
        this.ioDevices = Collections.unmodifiableList(devices);
        this.checkDeviceValidity(devices);
        this.workspaces = new ArrayList<IODeviceHandle>();
        for (IODeviceHandle d : this.ioDevices) {
            if (d.getWorkspace() == null) continue;
            new File(d.getMount(), d.getWorkspace()).mkdirs();
            this.workspaces.add(d);
        }
        if (this.workspaces.isEmpty()) {
            throw new HyracksDataException("No devices with workspace found");
        }
        this.workspaceIndex = 0;
        this.deviceComputer = new DefaultDeviceComputer(this);
    }

    private void checkDeviceValidity(List<IODeviceHandle> devices) throws HyracksDataException {
        for (IODeviceHandle d : devices) {
            Path p = Paths.get(d.getMount().toURI());
            for (IODeviceHandle e : devices) {
                if (e == d) continue;
                Path q = Paths.get(e.getMount().toURI());
                if (p.equals(q)) {
                    throw HyracksDataException.create((int)13, (Serializable[])new Serializable[0]);
                }
                if (!p.startsWith(q)) continue;
                throw HyracksDataException.create((int)14, (Serializable[])new Serializable[0]);
            }
        }
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public List<IODeviceHandle> getIODevices() {
        return this.ioDevices;
    }

    public IFileHandle open(FileReference fileRef, IIOManager.FileReadWriteMode rwMode, IIOManager.FileSyncMode syncMode) throws HyracksDataException {
        FileHandle fHandle = new FileHandle(fileRef);
        try {
            fHandle.open(rwMode, syncMode);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        return fHandle;
    }

    public int syncWrite(IFileHandle fHandle, long offset, ByteBuffer data) throws HyracksDataException {
        try {
            if (fHandle == null) {
                throw new IllegalStateException("Trying to write to a deleted file.");
            }
            int n = 0;
            int remaining = data.remaining();
            while (remaining > 0) {
                int len = ((FileHandle)fHandle).getFileChannel().write(data, offset);
                if (len < 0) {
                    throw new HyracksDataException("Error writing to file: " + ((FileHandle)fHandle).getFileReference().toString());
                }
                remaining -= len;
                offset += (long)len;
                n += len;
            }
            return n;
        }
        catch (HyracksDataException e) {
            throw e;
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long syncWrite(IFileHandle fHandle, long offset, ByteBuffer[] dataArray) throws HyracksDataException {
        try {
            if (fHandle == null) {
                throw new IllegalStateException("Trying to write to a deleted file.");
            }
            int n = 0;
            int remaining = 0;
            for (ByteBuffer buf : dataArray) {
                remaining += buf.remaining();
            }
            FileChannel fileChannel = ((FileHandle)fHandle).getFileChannel();
            while (remaining > 0) {
                long len;
                FileChannel fileChannel2 = fileChannel;
                synchronized (fileChannel2) {
                    fileChannel.position(offset);
                    len = fileChannel.write(dataArray);
                }
                if (len < 0L) {
                    throw new HyracksDataException("Error writing to file: " + ((FileHandle)fHandle).getFileReference().toString());
                }
                remaining = (int)((long)remaining - len);
                offset += len;
                n = (int)((long)n + len);
            }
            return n;
        }
        catch (HyracksDataException e) {
            throw e;
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public int syncRead(IFileHandle fHandle, long offset, ByteBuffer data) throws HyracksDataException {
        try {
            int n = 0;
            int remaining = data.remaining();
            while (remaining > 0) {
                int len = ((FileHandle)fHandle).getFileChannel().read(data, offset);
                if (len < 0) {
                    return n == 0 ? -1 : n;
                }
                remaining -= len;
                offset += (long)len;
                n += len;
            }
            return n;
        }
        catch (HyracksDataException e) {
            throw e;
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public IIOFuture asyncWrite(IFileHandle fHandle, long offset, ByteBuffer data) {
        AsyncWriteRequest req = new AsyncWriteRequest((FileHandle)fHandle, offset, data);
        this.executor.execute(req);
        return req;
    }

    public IIOFuture asyncRead(IFileHandle fHandle, long offset, ByteBuffer data) {
        AsyncReadRequest req = new AsyncReadRequest((FileHandle)fHandle, offset, data);
        this.executor.execute(req);
        return req;
    }

    public void close(IFileHandle fHandle) throws HyracksDataException {
        try {
            ((FileHandle)fHandle).close();
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public synchronized FileReference createWorkspaceFile(String prefix) throws HyracksDataException {
        File waf;
        IODeviceHandle dev = this.workspaces.get(this.workspaceIndex);
        this.workspaceIndex = (this.workspaceIndex + 1) % this.workspaces.size();
        String waPath = dev.getWorkspace();
        try {
            waf = File.createTempFile(prefix, WORKSPACE_FILE_SUFFIX, new File(dev.getMount(), waPath));
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        return dev.createFileRef(waPath + File.separator + waf.getName());
    }

    public void sync(IFileHandle fileHandle, boolean metadata) throws HyracksDataException {
        try {
            ((FileHandle)fileHandle).getFileChannel().force(metadata);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public long getSize(IFileHandle fileHandle) {
        return ((FileHandle)fileHandle).getFileReference().getFile().length();
    }

    public void deleteWorkspaceFiles() {
        for (IODeviceHandle ioDevice : this.workspaces) {
            File[] workspaceFiles;
            File workspaceFolder = new File(ioDevice.getMount(), ioDevice.getWorkspace());
            if (!workspaceFolder.exists() || !workspaceFolder.isDirectory()) continue;
            for (File workspaceFile : workspaceFiles = workspaceFolder.listFiles(WORKSPACE_FILES_FILTER)) {
                workspaceFile.delete();
            }
        }
    }

    public synchronized FileReference getFileReference(int ioDeviceId, String relativePath) {
        IODeviceHandle devHandle = this.ioDevices.get(ioDeviceId);
        return new FileReference(devHandle, relativePath);
    }

    public FileReference resolve(String path) throws HyracksDataException {
        return new FileReference(this.deviceComputer.compute(path), path);
    }

    public FileReference resolveAbsolutePath(String path) throws HyracksDataException {
        IODeviceHandle devHandle = this.getDevice(path);
        if (devHandle == null) {
            throw HyracksDataException.create((int)4, (Serializable[])new Serializable[]{path});
        }
        String relativePath = devHandle.getRelativePath(path);
        return new FileReference(devHandle, relativePath);
    }

    public IODeviceHandle getDevice(String fullPath) {
        Path full = Paths.get(fullPath, new String[0]);
        for (IODeviceHandle d : this.ioDevices) {
            if (!full.startsWith(Paths.get(d.getMount().getAbsolutePath(), new String[0]))) continue;
            return d;
        }
        return null;
    }

    private class AsyncWriteRequest
    extends AsyncRequest {
        private AsyncWriteRequest(FileHandle fHandle, long offset, ByteBuffer data) {
            super(fHandle, offset, data);
        }

        @Override
        protected int performOperation() throws HyracksDataException {
            return IOManager.this.syncWrite((IFileHandle)this.fHandle, this.offset, this.data);
        }
    }

    private class AsyncReadRequest
    extends AsyncRequest {
        private AsyncReadRequest(FileHandle fHandle, long offset, ByteBuffer data) {
            super(fHandle, offset, data);
        }

        @Override
        protected int performOperation() throws HyracksDataException {
            return IOManager.this.syncRead(this.fHandle, this.offset, this.data);
        }
    }

    private abstract class AsyncRequest
    implements IIOFuture,
    Runnable {
        protected final FileHandle fHandle;
        protected final long offset;
        protected final ByteBuffer data;
        private boolean complete;
        private HyracksDataException exception;
        private int result;

        private AsyncRequest(FileHandle fHandle, long offset, ByteBuffer data) {
            this.fHandle = fHandle;
            this.offset = offset;
            this.data = data;
            this.complete = false;
            this.exception = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HyracksDataException hde = null;
            int res = -1;
            try {
                res = this.performOperation();
            }
            catch (HyracksDataException e) {
                hde = e;
            }
            AsyncRequest asyncRequest = this;
            synchronized (asyncRequest) {
                this.exception = hde;
                this.result = res;
                this.complete = true;
                this.notifyAll();
            }
        }

        protected abstract int performOperation() throws HyracksDataException;

        public synchronized int synchronize() throws HyracksDataException, InterruptedException {
            while (!this.complete) {
                this.wait();
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        public synchronized boolean isComplete() {
            return this.complete;
        }
    }
}

