/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.io;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IFileDeviceComputer;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.control.nc.io.IOManager;

public class DefaultDeviceComputer
implements IFileDeviceComputer {
    private final IOManager ioManager;
    private AtomicInteger next = new AtomicInteger(0);

    public DefaultDeviceComputer(IOManager ioManager) {
        this.ioManager = ioManager;
    }

    public IODeviceHandle compute(String relPath) throws HyracksDataException {
        String path = relPath;
        if (this.ioManager.getIODevices().size() == 1) {
            return this.ioManager.getIODevices().get(0);
        }
        int nextSeparator = path.lastIndexOf(File.separator);
        while (nextSeparator > 0) {
            for (IODeviceHandle dev : this.ioManager.getIODevices()) {
                if (!dev.contains(path)) continue;
                return dev;
            }
            path = path.substring(0, nextSeparator);
            nextSeparator = path.lastIndexOf(File.separator);
        }
        for (IODeviceHandle dev : this.ioManager.getIODevices()) {
            if (!dev.contains(path)) continue;
            return dev;
        }
        return this.ioManager.getIODevices().get(this.next.getAndIncrement() % this.ioManager.getIODevices().size());
    }
}

