/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.DataOutput;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.IPropertiesProvider;
import org.apache.asterix.common.context.ITransactionSubsystemProvider;
import org.apache.asterix.common.context.TransactionSubsystemProvider;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.external.operators.ExternalIndexBulkModifyOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalScanOperatorDescriptor;
import org.apache.asterix.formats.nontagged.BinaryBooleanInspector;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.ExternalIndexingOperations;
import org.apache.asterix.metadata.utils.SecondaryBTreeOperationsHelper;
import org.apache.asterix.metadata.utils.SecondaryInvertedIndexOperationsHelper;
import org.apache.asterix.metadata.utils.SecondaryRTreeOperationsHelper;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.AndDescriptor;
import org.apache.asterix.runtime.evaluators.functions.CastTypeDescriptor;
import org.apache.asterix.runtime.evaluators.functions.IsUnknownDescriptor;
import org.apache.asterix.runtime.evaluators.functions.NotDescriptor;
import org.apache.asterix.runtime.job.listener.JobEventListenerFactory;
import org.apache.asterix.runtime.utils.AppContextInfo;
import org.apache.asterix.runtime.utils.RuntimeComponentsProvider;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexInstantSearchOperationCallbackFactory;
import org.apache.asterix.transaction.management.service.transaction.JobIdFactory;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.algebricks.data.ISerializerDeserializerProvider;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.ColumnAccessEvalFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.algebricks.runtime.operators.std.AssignRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.std.StreamSelectRuntimeFactory;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.dataflow.std.misc.ConstantTupleSourceOperatorDescriptor;
import org.apache.hyracks.dataflow.std.sort.ExternalSortOperatorDescriptor;
import org.apache.hyracks.storage.am.btree.dataflow.BTreeSearchOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.IIndexLifecycleManagerProvider;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.TreeIndexBulkLoadOperatorDescriptor;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.common.IStorageManager;

public abstract class SecondaryIndexOperationsHelper {
    protected final PhysicalOptimizationConfig physOptConf;
    protected final MetadataProvider metadataProvider;
    protected final Dataset dataset;
    protected final Index index;
    protected final ARecordType itemType;
    protected final ARecordType metaType;
    protected final ARecordType enforcedItemType;
    protected final ARecordType enforcedMetaType;
    protected ISerializerDeserializer metaSerde;
    protected ISerializerDeserializer payloadSerde;
    protected IFileSplitProvider primaryFileSplitProvider;
    protected AlgebricksPartitionConstraint primaryPartitionConstraint;
    protected IFileSplitProvider secondaryFileSplitProvider;
    protected AlgebricksPartitionConstraint secondaryPartitionConstraint;
    protected boolean anySecondaryKeyIsNullable = false;
    protected long numElementsHint;
    protected IBinaryComparatorFactory[] primaryComparatorFactories;
    protected int[] primaryBloomFilterKeyFields;
    protected RecordDescriptor primaryRecDesc;
    protected IBinaryComparatorFactory[] secondaryComparatorFactories;
    protected ITypeTraits[] secondaryTypeTraits;
    protected int[] secondaryBloomFilterKeyFields;
    protected RecordDescriptor secondaryRecDesc;
    protected IScalarEvaluatorFactory[] secondaryFieldAccessEvalFactories;
    protected IPropertiesProvider propertiesProvider;
    protected ILSMMergePolicyFactory mergePolicyFactory;
    protected Map<String, String> mergePolicyFactoryProperties;
    protected RecordDescriptor enforcedRecDesc;
    protected int numFilterFields;
    protected List<String> filterFieldName;
    protected ITypeTraits[] filterTypeTraits;
    protected IBinaryComparatorFactory[] filterCmpFactories;
    protected int[] secondaryFilterFields;
    protected int[] primaryFilterFields;
    protected int[] primaryBTreeFields;
    protected int[] secondaryBTreeFields;
    protected List<ExternalFile> externalFiles;
    protected int numPrimaryKeys;

    protected SecondaryIndexOperationsHelper(Dataset dataset, Index index, PhysicalOptimizationConfig physOptConf, IPropertiesProvider propertiesProvider, MetadataProvider metadataProvider, ARecordType recType, ARecordType metaType, ARecordType enforcedType, ARecordType enforcedMetaType) {
        this.dataset = dataset;
        this.index = index;
        this.physOptConf = physOptConf;
        this.propertiesProvider = propertiesProvider;
        this.metadataProvider = metadataProvider;
        this.itemType = recType;
        this.metaType = metaType;
        this.enforcedItemType = enforcedType;
        this.enforcedMetaType = enforcedMetaType;
    }

    public static SecondaryIndexOperationsHelper createIndexOperationsHelper(Dataset dataset, Index index, MetadataProvider metadataProvider, PhysicalOptimizationConfig physOptConf, ARecordType recType, ARecordType metaType, ARecordType enforcedType, ARecordType enforcedMetaType) throws AlgebricksException {
        SecondaryIndexOperationsHelper indexOperationsHelper;
        AppContextInfo asterixPropertiesProvider = AppContextInfo.INSTANCE;
        switch (index.getIndexType()) {
            case BTREE: {
                indexOperationsHelper = new SecondaryBTreeOperationsHelper(dataset, index, physOptConf, (IPropertiesProvider)asterixPropertiesProvider, metadataProvider, recType, metaType, enforcedType, enforcedMetaType);
                break;
            }
            case RTREE: {
                indexOperationsHelper = new SecondaryRTreeOperationsHelper(dataset, index, physOptConf, (IPropertiesProvider)asterixPropertiesProvider, metadataProvider, recType, metaType, enforcedType, enforcedMetaType);
                break;
            }
            case SINGLE_PARTITION_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                indexOperationsHelper = new SecondaryInvertedIndexOperationsHelper(dataset, index, physOptConf, (IPropertiesProvider)asterixPropertiesProvider, metadataProvider, recType, metaType, enforcedType, enforcedMetaType);
                break;
            }
            default: {
                throw new CompilationException(1012, new Serializable[]{index.getIndexType()});
            }
        }
        indexOperationsHelper.init();
        return indexOperationsHelper;
    }

    public abstract JobSpecification buildCreationJobSpec() throws AlgebricksException;

    public abstract JobSpecification buildLoadingJobSpec() throws AlgebricksException;

    public abstract JobSpecification buildCompactJobSpec() throws AlgebricksException;

    public abstract JobSpecification buildDropJobSpec() throws AlgebricksException;

    protected void init() throws AlgebricksException {
        this.payloadSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)this.itemType);
        this.metaSerde = this.metaType == null ? null : SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)this.metaType);
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> secondarySplitsAndConstraint = this.metadataProvider.getSplitProviderAndConstraints(this.dataset, this.index.getIndexName());
        this.secondaryFileSplitProvider = (IFileSplitProvider)secondarySplitsAndConstraint.first;
        this.secondaryPartitionConstraint = (AlgebricksPartitionConstraint)secondarySplitsAndConstraint.second;
        this.numPrimaryKeys = DatasetUtil.getPartitioningKeys(this.dataset).size();
        if (this.dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            this.filterFieldName = DatasetUtil.getFilterField(this.dataset);
            this.numFilterFields = this.filterFieldName != null ? 1 : 0;
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> primarySplitsAndConstraint = this.metadataProvider.getSplitProviderAndConstraints(this.dataset);
            this.primaryFileSplitProvider = (IFileSplitProvider)primarySplitsAndConstraint.first;
            this.primaryPartitionConstraint = (AlgebricksPartitionConstraint)primarySplitsAndConstraint.second;
            this.setPrimaryRecDescAndComparators();
        }
        this.setSecondaryRecDescAndComparators();
        this.numElementsHint = this.metadataProvider.getCardinalityPerPartitionHint(this.dataset);
        Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtil.getMergePolicyFactory(this.dataset, this.metadataProvider.getMetadataTxnContext());
        this.mergePolicyFactory = (ILSMMergePolicyFactory)compactionInfo.first;
        this.mergePolicyFactoryProperties = (Map)compactionInfo.second;
        if (this.numFilterFields > 0) {
            this.setFilterTypeTraitsAndComparators();
        }
    }

    protected void setFilterTypeTraitsAndComparators() throws AlgebricksException {
        int i;
        this.filterTypeTraits = new ITypeTraits[this.numFilterFields];
        this.filterCmpFactories = new IBinaryComparatorFactory[this.numFilterFields];
        this.secondaryFilterFields = new int[this.numFilterFields];
        this.primaryFilterFields = new int[this.numFilterFields];
        this.primaryBTreeFields = new int[this.numPrimaryKeys + 1];
        this.secondaryBTreeFields = new int[this.index.getKeyFieldNames().size() + this.numPrimaryKeys];
        for (i = 0; i < this.primaryBTreeFields.length; ++i) {
            this.primaryBTreeFields[i] = i;
        }
        for (i = 0; i < this.secondaryBTreeFields.length; ++i) {
            this.secondaryBTreeFields[i] = i;
        }
        IAType type = this.itemType.getSubFieldType(this.filterFieldName);
        this.filterCmpFactories[0] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)type, true);
        this.filterTypeTraits[0] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)type);
        this.secondaryFilterFields[0] = this.getNumSecondaryKeys() + this.numPrimaryKeys;
        this.primaryFilterFields[0] = this.numPrimaryKeys + 1;
    }

    protected abstract int getNumSecondaryKeys();

    protected void setPrimaryRecDescAndComparators() throws AlgebricksException {
        List<List<String>> partitioningKeys = DatasetUtil.getPartitioningKeys(this.dataset);
        ISerializerDeserializer[] primaryRecFields = new ISerializerDeserializer[this.numPrimaryKeys + 1 + (this.dataset.hasMetaPart() ? 1 : 0)];
        ITypeTraits[] primaryTypeTraits = new ITypeTraits[this.numPrimaryKeys + 1 + (this.dataset.hasMetaPart() ? 1 : 0)];
        this.primaryComparatorFactories = new IBinaryComparatorFactory[this.numPrimaryKeys];
        this.primaryBloomFilterKeyFields = new int[this.numPrimaryKeys];
        ISerializerDeserializerProvider serdeProvider = this.metadataProvider.getFormat().getSerdeProvider();
        List<Integer> indicators = null;
        if (this.dataset.hasMetaPart()) {
            indicators = ((InternalDatasetDetails)this.dataset.getDatasetDetails()).getKeySourceIndicator();
        }
        for (int i = 0; i < this.numPrimaryKeys; ++i) {
            IAType keyType = indicators == null || indicators.get(i) == 0 ? this.itemType.getSubFieldType(partitioningKeys.get(i)) : this.metaType.getSubFieldType(partitioningKeys.get(i));
            primaryRecFields[i] = serdeProvider.getSerializerDeserializer((Object)keyType);
            this.primaryComparatorFactories[i] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)keyType, true);
            primaryTypeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
            this.primaryBloomFilterKeyFields[i] = i;
        }
        primaryRecFields[this.numPrimaryKeys] = this.payloadSerde;
        primaryTypeTraits[this.numPrimaryKeys] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)this.itemType);
        if (this.dataset.hasMetaPart()) {
            primaryRecFields[this.numPrimaryKeys + 1] = this.payloadSerde;
            primaryTypeTraits[this.numPrimaryKeys + 1] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)this.itemType);
        }
        this.primaryRecDesc = new RecordDescriptor(primaryRecFields, primaryTypeTraits);
    }

    protected abstract void setSecondaryRecDescAndComparators() throws AlgebricksException;

    protected AbstractOperatorDescriptor createDummyKeyProviderOp(JobSpecification spec) throws AlgebricksException {
        ArrayTupleBuilder tb = new ArrayTupleBuilder(1);
        DataOutput dos = tb.getDataOutput();
        tb.reset();
        try {
            IntegerSerializerDeserializer.INSTANCE.serialize(Integer.valueOf(0), dos);
        }
        catch (HyracksDataException e) {
            throw new AsterixException((Throwable)e);
        }
        tb.addFieldEndOffset();
        ISerializerDeserializer[] keyRecDescSers = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE};
        RecordDescriptor keyRecDesc = new RecordDescriptor(keyRecDescSers);
        ConstantTupleSourceOperatorDescriptor keyProviderOp = new ConstantTupleSourceOperatorDescriptor((IOperatorDescriptorRegistry)spec, keyRecDesc, tb.getFieldEndOffsets(), tb.getByteArray(), tb.getSize());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)keyProviderOp, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return keyProviderOp;
    }

    protected BTreeSearchOperatorDescriptor createPrimaryIndexScanOp(JobSpecification spec) throws AlgebricksException {
        int[] lowKeyFields = null;
        int[] highKeyFields = null;
        TransactionSubsystemProvider txnSubsystemProvider = TransactionSubsystemProvider.INSTANCE;
        JobId jobId = JobIdFactory.generateJobId();
        this.metadataProvider.setJobId(jobId);
        boolean isWriteTransaction = this.metadataProvider.isWriteTransaction();
        JobEventListenerFactory jobEventListenerFactory = new JobEventListenerFactory(jobId, isWriteTransaction);
        spec.setJobletEventListenerFactory((IJobletEventListenerFactory)jobEventListenerFactory);
        Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.metadataProvider.getMetadataTxnContext(), this.dataset.getDataverseName(), this.dataset.getDatasetName(), this.dataset.getDatasetName());
        boolean temp = this.dataset.getDatasetDetails().isTemp();
        NoOpOperationCallbackFactory searchCallbackFactory = temp ? NoOpOperationCallbackFactory.INSTANCE : new PrimaryIndexInstantSearchOperationCallbackFactory(jobId, this.dataset.getDatasetId(), this.primaryBloomFilterKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, 0);
        BTreeSearchOperatorDescriptor primarySearchOp = new BTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.primaryRecDesc, (IStorageManager)RuntimeComponentsProvider.RUNTIME_PROVIDER, (IIndexLifecycleManagerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, this.primaryFileSplitProvider, this.primaryRecDesc.getTypeTraits(), this.primaryComparatorFactories, this.primaryBloomFilterKeyFields, lowKeyFields, highKeyFields, true, true, this.dataset.getIndexDataflowHelperFactory(this.metadataProvider, primaryIndex, this.itemType, this.metaType, this.mergePolicyFactory, this.mergePolicyFactoryProperties), false, false, null, (ISearchOperationCallbackFactory)searchCallbackFactory, null, null, (IPageManagerFactory)this.metadataProvider.getStorageComponentProvider().getMetadataPageManagerFactory());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)primarySearchOp, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return primarySearchOp;
    }

    protected AlgebricksMetaOperatorDescriptor createAssignOp(JobSpecification spec, int numSecondaryKeyFields, RecordDescriptor secondaryRecDesc) throws AlgebricksException {
        int i;
        int[] outColumns = new int[numSecondaryKeyFields + this.numFilterFields];
        int[] projectionList = new int[numSecondaryKeyFields + this.numPrimaryKeys + this.numFilterFields];
        for (int i2 = 0; i2 < numSecondaryKeyFields + this.numFilterFields; ++i2) {
            outColumns[i2] = this.numPrimaryKeys + i2;
        }
        int projCount = 0;
        for (i = 0; i < numSecondaryKeyFields; ++i) {
            projectionList[projCount++] = this.numPrimaryKeys + i;
        }
        i = 0;
        while (i < this.numPrimaryKeys) {
            projectionList[projCount++] = i++;
        }
        if (this.numFilterFields > 0) {
            projectionList[projCount] = this.numPrimaryKeys + numSecondaryKeyFields;
        }
        IScalarEvaluatorFactory[] sefs = new IScalarEvaluatorFactory[this.secondaryFieldAccessEvalFactories.length];
        for (int i3 = 0; i3 < this.secondaryFieldAccessEvalFactories.length; ++i3) {
            sefs[i3] = this.secondaryFieldAccessEvalFactories[i3];
        }
        AssignRuntimeFactory assign = new AssignRuntimeFactory(outColumns, sefs, projectionList);
        AlgebricksMetaOperatorDescriptor asterixAssignOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 1, new IPushRuntimeFactory[]{assign}, new RecordDescriptor[]{secondaryRecDesc});
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)asterixAssignOp, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return asterixAssignOp;
    }

    protected AlgebricksMetaOperatorDescriptor createCastOp(JobSpecification spec, DatasetConfig.DatasetType dsType) {
        int recordIdx;
        CastTypeDescriptor castFuncDesc = (CastTypeDescriptor)CastTypeDescriptor.FACTORY.createFunctionDescriptor();
        castFuncDesc.setImmutableStates(new Object[]{this.enforcedItemType, this.itemType});
        int[] outColumns = new int[1];
        int[] projectionList = new int[(this.dataset.hasMetaPart() ? 2 : 1) + this.numPrimaryKeys];
        if (dsType == DatasetConfig.DatasetType.EXTERNAL) {
            recordIdx = 0;
            outColumns[0] = 0;
        } else {
            recordIdx = this.numPrimaryKeys;
            outColumns[0] = this.numPrimaryKeys;
        }
        for (int i = 0; i <= this.numPrimaryKeys; ++i) {
            projectionList[i] = i;
        }
        if (this.dataset.hasMetaPart()) {
            projectionList[this.numPrimaryKeys + 1] = this.numPrimaryKeys + 1;
        }
        IScalarEvaluatorFactory[] castEvalFact = new IScalarEvaluatorFactory[]{new ColumnAccessEvalFactory(recordIdx)};
        IScalarEvaluatorFactory[] sefs = new IScalarEvaluatorFactory[]{castFuncDesc.createEvaluatorFactory(castEvalFact)};
        AssignRuntimeFactory castAssign = new AssignRuntimeFactory(outColumns, sefs, projectionList);
        return new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 1, new IPushRuntimeFactory[]{castAssign}, new RecordDescriptor[]{this.enforcedRecDesc});
    }

    protected ExternalSortOperatorDescriptor createSortOp(JobSpecification spec, IBinaryComparatorFactory[] secondaryComparatorFactories, RecordDescriptor secondaryRecDesc) {
        int[] sortFields = new int[secondaryComparatorFactories.length];
        for (int i = 0; i < secondaryComparatorFactories.length; ++i) {
            sortFields[i] = i;
        }
        ExternalSortOperatorDescriptor sortOp = new ExternalSortOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.physOptConf.getMaxFramesExternalSort(), sortFields, secondaryComparatorFactories, secondaryRecDesc);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)sortOp, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return sortOp;
    }

    protected TreeIndexBulkLoadOperatorDescriptor createTreeIndexBulkLoadOp(JobSpecification spec, int[] fieldPermutation, IIndexDataflowHelperFactory dataflowHelperFactory, float fillFactor) throws AlgebricksException {
        TreeIndexBulkLoadOperatorDescriptor treeIndexBulkLoadOp = new TreeIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.secondaryRecDesc, (IStorageManager)RuntimeComponentsProvider.RUNTIME_PROVIDER, (IIndexLifecycleManagerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, this.secondaryFileSplitProvider, this.secondaryRecDesc.getTypeTraits(), this.secondaryComparatorFactories, this.secondaryBloomFilterKeyFields, fieldPermutation, fillFactor, false, this.numElementsHint, false, dataflowHelperFactory, (IPageManagerFactory)this.metadataProvider.getStorageComponentProvider().getMetadataPageManagerFactory());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)treeIndexBulkLoadOp, (AlgebricksPartitionConstraint)this.secondaryPartitionConstraint);
        return treeIndexBulkLoadOp;
    }

    public AlgebricksMetaOperatorDescriptor createFilterNullsSelectOp(JobSpecification spec, int numSecondaryKeyFields, RecordDescriptor secondaryRecDesc) throws AlgebricksException {
        IScalarEvaluatorFactory selectCond;
        IScalarEvaluatorFactory[] andArgsEvalFactories = new IScalarEvaluatorFactory[numSecondaryKeyFields];
        NotDescriptor notDesc = new NotDescriptor();
        IsUnknownDescriptor isUnknownDesc = new IsUnknownDescriptor();
        for (int i = 0; i < numSecondaryKeyFields; ++i) {
            IScalarEvaluatorFactory notEvalFactory;
            ColumnAccessEvalFactory columnAccessEvalFactory = new ColumnAccessEvalFactory(i);
            IScalarEvaluatorFactory isUnknownEvalFactory = isUnknownDesc.createEvaluatorFactory(new IScalarEvaluatorFactory[]{columnAccessEvalFactory});
            andArgsEvalFactories[i] = notEvalFactory = notDesc.createEvaluatorFactory(new IScalarEvaluatorFactory[]{isUnknownEvalFactory});
        }
        if (numSecondaryKeyFields > 1) {
            AndDescriptor andDesc = new AndDescriptor();
            selectCond = andDesc.createEvaluatorFactory(andArgsEvalFactories);
        } else {
            selectCond = andArgsEvalFactories[0];
        }
        StreamSelectRuntimeFactory select = new StreamSelectRuntimeFactory(selectCond, null, BinaryBooleanInspector.FACTORY, false, -1, null);
        AlgebricksMetaOperatorDescriptor asterixSelectOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 1, new IPushRuntimeFactory[]{select}, new RecordDescriptor[]{secondaryRecDesc});
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)asterixSelectOp, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return asterixSelectOp;
    }

    protected ExternalScanOperatorDescriptor createExternalIndexingOp(JobSpecification spec) throws AlgebricksException {
        Pair<ExternalScanOperatorDescriptor, AlgebricksPartitionConstraint> indexingOpAndConstraints;
        ISerializerDeserializer[] serdes = new ISerializerDeserializer[1 + this.numPrimaryKeys];
        ITypeTraits[] typeTraits = new ITypeTraits[1 + this.numPrimaryKeys];
        serdes[0] = this.payloadSerde;
        typeTraits[0] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)this.itemType);
        for (int i = 1; i < serdes.length; ++i) {
            serdes[i] = IndexingConstants.getSerializerDeserializer((int)(i - 1));
            typeTraits[i] = IndexingConstants.getTypeTraits((int)(i - 1));
        }
        RecordDescriptor indexerDesc = new RecordDescriptor(serdes, typeTraits);
        try {
            indexingOpAndConstraints = ExternalIndexingOperations.createExternalIndexingOp(spec, this.metadataProvider, this.dataset, this.itemType, indexerDesc, this.externalFiles);
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)((IOperatorDescriptor)indexingOpAndConstraints.first), (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)indexingOpAndConstraints.second));
        this.primaryPartitionConstraint = (AlgebricksPartitionConstraint)indexingOpAndConstraints.second;
        return (ExternalScanOperatorDescriptor)indexingOpAndConstraints.first;
    }

    protected AlgebricksMetaOperatorDescriptor createExternalAssignOp(JobSpecification spec, int numSecondaryKeys, RecordDescriptor secondaryRecDesc) throws AlgebricksException {
        int i;
        int[] outColumns = new int[numSecondaryKeys];
        int[] projectionList = new int[numSecondaryKeys + this.numPrimaryKeys];
        for (int i2 = 0; i2 < numSecondaryKeys; ++i2) {
            outColumns[i2] = i2 + this.numPrimaryKeys + 1;
            projectionList[i2] = i2 + this.numPrimaryKeys + 1;
        }
        IScalarEvaluatorFactory[] sefs = new IScalarEvaluatorFactory[this.secondaryFieldAccessEvalFactories.length];
        for (i = 0; i < this.secondaryFieldAccessEvalFactories.length; ++i) {
            sefs[i] = this.secondaryFieldAccessEvalFactories[i];
        }
        for (i = 0; i < this.numPrimaryKeys; ++i) {
            projectionList[numSecondaryKeys + i] = i + 1;
        }
        AssignRuntimeFactory assign = new AssignRuntimeFactory(outColumns, sefs, projectionList);
        return new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 1, new IPushRuntimeFactory[]{assign}, new RecordDescriptor[]{secondaryRecDesc});
    }

    protected ExternalIndexBulkModifyOperatorDescriptor createExternalIndexBulkModifyOp(JobSpecification spec, int[] fieldPermutation, IIndexDataflowHelperFactory dataflowHelperFactory, float fillFactor) throws AlgebricksException {
        int numOfDeletedFiles = 0;
        for (ExternalFile file : this.externalFiles) {
            if (file.getPendingOp() != DatasetConfig.ExternalFilePendingOp.DROP_OP) continue;
            ++numOfDeletedFiles;
        }
        int[] deletedFiles = new int[numOfDeletedFiles];
        int i = 0;
        for (ExternalFile file : this.externalFiles) {
            if (file.getPendingOp() != DatasetConfig.ExternalFilePendingOp.DROP_OP) continue;
            deletedFiles[i] = file.getFileNumber();
        }
        ExternalIndexBulkModifyOperatorDescriptor treeIndexBulkLoadOp = new ExternalIndexBulkModifyOperatorDescriptor((IOperatorDescriptorRegistry)spec, (IStorageManager)RuntimeComponentsProvider.RUNTIME_PROVIDER, (IIndexLifecycleManagerProvider)RuntimeComponentsProvider.RUNTIME_PROVIDER, this.secondaryFileSplitProvider, this.secondaryTypeTraits, this.secondaryComparatorFactories, this.secondaryBloomFilterKeyFields, dataflowHelperFactory, (IModificationOperationCallbackFactory)NoOpOperationCallbackFactory.INSTANCE, deletedFiles, fieldPermutation, fillFactor, this.numElementsHint, this.metadataProvider.getStorageComponentProvider().getMetadataPageManagerFactory());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)treeIndexBulkLoadOp, (AlgebricksPartitionConstraint)this.secondaryPartitionConstraint);
        return treeIndexBulkLoadOp;
    }

    public List<ExternalFile> getExternalFiles() {
        return this.externalFiles;
    }

    public void setExternalFiles(List<ExternalFile> externalFiles) {
        this.externalFiles = externalFiles;
    }
}

