/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.config.OptimizationConfUtil;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.SecondaryIndexOperationsHelper;
import org.apache.asterix.metadata.utils.TypeUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.job.JobSpecification;

public class IndexUtil {
    private static final int[] empty = null;
    private static final PhysicalOptimizationConfig physicalOptimizationConfig = OptimizationConfUtil.getPhysicalOptimizationConfig();

    private IndexUtil() {
    }

    public static int[] getFilterFields(Dataset dataset, Index index, ITypeTraits[] filterTypeTraits) throws AlgebricksException {
        if (index.isPrimaryIndex()) {
            return DatasetUtil.createFilterFields(dataset);
        }
        return IndexUtil.secondaryFilterFields(dataset, index, filterTypeTraits);
    }

    public static int[] getBtreeFieldsIfFiltered(Dataset dataset, Index index) throws AlgebricksException {
        if (index.isPrimaryIndex()) {
            return DatasetUtil.createBTreeFieldsWhenThereisAFilter(dataset);
        }
        int numPrimaryKeys = DatasetUtil.getPartitioningKeys(dataset).size();
        int numSecondaryKeys = index.getKeyFieldNames().size();
        int[] btreeFields = new int[numSecondaryKeys + numPrimaryKeys];
        for (int k = 0; k < btreeFields.length; ++k) {
            btreeFields[k] = k;
        }
        return btreeFields;
    }

    private static int[] secondaryFilterFields(Dataset dataset, Index index, ITypeTraits[] filterTypeTraits) throws CompilationException {
        if (filterTypeTraits == null) {
            return empty;
        }
        int numPrimaryKeys = DatasetUtil.getPartitioningKeys(dataset).size();
        int numSecondaryKeys = index.getKeyFieldNames().size();
        switch (index.getIndexType()) {
            case BTREE: {
                return new int[]{numPrimaryKeys + numSecondaryKeys};
            }
            case RTREE: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case SINGLE_PARTITION_WORD_INVIX: {
                break;
            }
            default: {
                throw new CompilationException(1012, new Serializable[]{index.getIndexType().toString()});
            }
        }
        return empty;
    }

    public static JobSpecification buildDropIndexJobSpec(Index index, MetadataProvider metadataProvider, Dataset dataset) throws AlgebricksException {
        ARecordType recordType = (ARecordType)metadataProvider.findType(dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
        ARecordType metaType = DatasetUtil.getMetaType(metadataProvider, dataset);
        ARecordType enforcedType = null;
        ARecordType enforcedMetaType = null;
        if (index.isEnforcingKeyFileds()) {
            Pair<ARecordType, ARecordType> enforcedTypes = TypeUtil.createEnforcedType(recordType, metaType, Collections.singletonList(index));
            enforcedType = (ARecordType)enforcedTypes.first;
            enforcedMetaType = (ARecordType)enforcedTypes.second;
        }
        SecondaryIndexOperationsHelper secondaryIndexHelper = SecondaryIndexOperationsHelper.createIndexOperationsHelper(dataset, index, metadataProvider, physicalOptimizationConfig, recordType, metaType, enforcedType, enforcedMetaType);
        return secondaryIndexHelper.buildDropJobSpec();
    }

    public static JobSpecification buildSecondaryIndexCreationJobSpec(Dataset dataset, Index index, ARecordType recType, ARecordType metaType, ARecordType enforcedType, ARecordType enforcedMetaType, MetadataProvider metadataProvider) throws AlgebricksException {
        SecondaryIndexOperationsHelper secondaryIndexHelper = SecondaryIndexOperationsHelper.createIndexOperationsHelper(dataset, index, metadataProvider, physicalOptimizationConfig, recType, metaType, enforcedType, enforcedMetaType);
        return secondaryIndexHelper.buildCreationJobSpec();
    }

    public static JobSpecification buildSecondaryIndexLoadingJobSpec(Dataset dataset, Index index, ARecordType recType, ARecordType metaType, ARecordType enforcedType, ARecordType enforcedMetaType, MetadataProvider metadataProvider) throws AlgebricksException {
        SecondaryIndexOperationsHelper secondaryIndexHelper = SecondaryIndexOperationsHelper.createIndexOperationsHelper(dataset, index, metadataProvider, physicalOptimizationConfig, recType, metaType, enforcedType, enforcedMetaType);
        return secondaryIndexHelper.buildLoadingJobSpec();
    }

    public static JobSpecification buildSecondaryIndexLoadingJobSpec(Dataset dataset, Index index, ARecordType recType, ARecordType metaType, ARecordType enforcedType, ARecordType enforcedMetaType, MetadataProvider metadataProvider, List<ExternalFile> files) throws AlgebricksException {
        SecondaryIndexOperationsHelper secondaryIndexHelper = SecondaryIndexOperationsHelper.createIndexOperationsHelper(dataset, index, metadataProvider, physicalOptimizationConfig, recType, metaType, enforcedType, enforcedMetaType);
        secondaryIndexHelper.setExternalFiles(files);
        return secondaryIndexHelper.buildLoadingJobSpec();
    }

    public static JobSpecification buildSecondaryIndexCompactJobSpec(Dataset dataset, Index index, ARecordType recType, ARecordType metaType, ARecordType enforcedType, ARecordType enforcedMetaType, MetadataProvider metadataProvider) throws AlgebricksException {
        SecondaryIndexOperationsHelper secondaryIndexHelper = SecondaryIndexOperationsHelper.createIndexOperationsHelper(dataset, index, metadataProvider, physicalOptimizationConfig, recType, metaType, enforcedType, enforcedMetaType);
        return secondaryIndexHelper.buildCompactJobSpec();
    }
}

