/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import java.util.HashMap;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;

public class BuiltinFeedPolicies {
    public static final FeedPolicyEntity BASIC = BuiltinFeedPolicies.initializeBasicPolicy();
    public static final FeedPolicyEntity ADVANCED_FT_DISCARD = BuiltinFeedPolicies.initializeAdvancedFTDiscardPolicy();
    public static final FeedPolicyEntity ADVANCED_FT_SPILL = BuiltinFeedPolicies.initializeAdvancedFTSpillPolicy();
    public static final FeedPolicyEntity ELASTIC = BuiltinFeedPolicies.initializeAdvancedFTElasticPolicy();
    public static final FeedPolicyEntity[] policies = new FeedPolicyEntity[]{BASIC, ADVANCED_FT_DISCARD, ADVANCED_FT_SPILL, ELASTIC};
    public static final FeedPolicyEntity DEFAULT_POLICY = BASIC;
    public static final String CONFIG_FEED_POLICY_KEY = "policy";

    public static FeedPolicyEntity getFeedPolicy(String policyName) {
        for (FeedPolicyEntity policy : policies) {
            if (!policy.getPolicyName().equalsIgnoreCase(policyName)) continue;
            return policy;
        }
        return null;
    }

    private static FeedPolicyEntity initializeBasicPolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("elastic", "false");
        String description = "Basic";
        return new FeedPolicyEntity("Metadata", "Basic", description, policyParams);
    }

    private static FeedPolicyEntity initializeAdvancedFTDiscardPolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("elastic", "false");
        policyParams.put("flowcontrol.enabled", "true");
        policyParams.put("max.spill.size.on.disk", "false");
        policyParams.put("max.fraction.discard", "100");
        policyParams.put("logging.statistics", "true");
        String description = "FlowControl 100% Discard during congestion";
        return new FeedPolicyEntity("Metadata", "Discard", description, policyParams);
    }

    private static FeedPolicyEntity initializeAdvancedFTSpillPolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("elastic", "false");
        policyParams.put("flowcontrol.enabled", "true");
        policyParams.put("spill.to.disk.on.congestion", "" + Boolean.TRUE);
        policyParams.put("max.spill.size.on.disk", "-1");
        String description = "FlowControl 100% Spill during congestion";
        return new FeedPolicyEntity("Metadata", "Spill", description, policyParams);
    }

    private static FeedPolicyEntity initializeAdvancedFTElasticPolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("elastic", "true");
        policyParams.put("flowcontrol.enabled", "true");
        policyParams.put("logging.statistics", "true");
        String description = "Basic Monitored Fault-Tolerant Elastic";
        return new FeedPolicyEntity("Metadata", "AdvancedFT_Elastic", description, policyParams);
    }
}

