/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class FeedConnectionTupleTranslator
extends AbstractTupleTranslator<FeedConnection> {
    public static final int FEED_CONN_DATAVERSE_NAME_FIELD_INDEX = 0;
    public static final int FEED_CONN_FEED_NAME_FIELD_INDEX = 1;
    public static final int FEED_CONN_DATASET_NAME_FIELD_INDEX = 2;
    public static final int FEED_CONN_PAYLOAD_TUPLE_FIELD_INDEX = 3;
    private ISerializerDeserializer<ARecord> recordSerDes = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)MetadataRecordTypes.FEED_CONNECTION_RECORDTYPE);

    public FeedConnectionTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET.getFieldCount());
    }

    @Override
    public FeedConnection getMetadataEntityFromTuple(ITupleReference frameTuple) throws MetadataException, IOException {
        byte[] serRecord = frameTuple.getFieldData(3);
        int recordStartOffset = frameTuple.getFieldStart(3);
        int recordLength = frameTuple.getFieldLength(3);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        ARecord feedConnRecord = (ARecord)this.recordSerDes.deserialize((DataInput)in);
        return this.createFeedConnFromRecord(feedConnRecord);
    }

    private FeedConnection createFeedConnFromRecord(ARecord feedConnRecord) {
        String dataverseName = ((AString)feedConnRecord.getValueByPos(0)).getStringValue();
        String feedName = ((AString)feedConnRecord.getValueByPos(1)).getStringValue();
        String datasetName = ((AString)feedConnRecord.getValueByPos(2)).getStringValue();
        String outputType = ((AString)feedConnRecord.getValueByPos(3)).getStringValue();
        String policyName = ((AString)feedConnRecord.getValueByPos(5)).getStringValue();
        ArrayList<FunctionSignature> appliedFunctions = null;
        IAObject o = feedConnRecord.getValueByPos(4);
        if (!(o instanceof ANull) && !(o instanceof AMissing)) {
            appliedFunctions = new ArrayList<FunctionSignature>();
            IACursor cursor = ((AUnorderedList)feedConnRecord.getValueByPos(4)).getCursor();
            while (cursor.next()) {
                FunctionSignature functionSignature = new FunctionSignature(dataverseName, ((AString)cursor.get()).getStringValue(), 1);
                appliedFunctions.add(functionSignature);
            }
        }
        return new FeedConnection(dataverseName, feedName, datasetName, appliedFunctions, policyName, outputType);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(FeedConnection me) throws MetadataException, IOException {
        this.tupleBuilder.reset();
        this.aString.setValue(me.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(me.getFeedName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(me.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.FEED_CONNECTION_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(me.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(me.getFeedName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(me.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(me.getOutputType());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.writeAppliedFunctionsField(this.recordBuilder, me, this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(me.getPolicyName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(5, (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    private void writeAppliedFunctionsField(IARecordBuilder rb, FeedConnection fc, ArrayBackedValueStorage buffer) throws HyracksDataException {
        UnorderedListBuilder listBuilder = new UnorderedListBuilder();
        ArrayBackedValueStorage listEleBuffer = new ArrayBackedValueStorage();
        listBuilder.reset((AbstractCollectionType)((AUnorderedListType)MetadataRecordTypes.FEED_CONNECTION_RECORDTYPE.getFieldTypes()[4]));
        if (fc.getAppliedFunctions() != null) {
            List<FunctionSignature> appliedFunctions = fc.getAppliedFunctions();
            for (FunctionSignature af : appliedFunctions) {
                listEleBuffer.reset();
                this.aString.setValue(af.getName());
                this.stringSerde.serialize((Object)this.aString, listEleBuffer.getDataOutput());
                listBuilder.addItem((IValueReference)listEleBuffer);
            }
        }
        listBuilder.write(buffer.getDataOutput(), true);
        rb.addField(4, (IValueReference)buffer);
    }
}

