/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.io.Serializable;
import java.util.Map;
import org.apache.asterix.common.context.AsterixVirtualBufferCacheProvider;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.metadata.api.IIndexDataflowHelperFactoryProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.lock.ExternalDatasetsRegistry;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.ExternalBTreeDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.ExternalBTreeWithBuddyDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.LSMBTreeDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;

public class BTreeDataflowHelperFactoryProvider
implements IIndexDataflowHelperFactoryProvider {
    public static final BTreeDataflowHelperFactoryProvider INSTANCE = new BTreeDataflowHelperFactoryProvider();

    private BTreeDataflowHelperFactoryProvider() {
    }

    public static String externalFileIndexName(Dataset dataset) {
        return dataset.getDatasetName().concat("FilesIndex");
    }

    @Override
    public IIndexDataflowHelperFactory getIndexDataflowHelperFactory(MetadataProvider mdProvider, Dataset dataset, Index index, ARecordType recordType, ARecordType metaType, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories) throws AlgebricksException {
        int[] filterFields = IndexUtil.getFilterFields(dataset, index, filterTypeTraits);
        int[] btreeFields = IndexUtil.getBtreeFieldsIfFiltered(dataset, index);
        IStorageComponentProvider storageComponentProvider = mdProvider.getStorageComponentProvider();
        switch (dataset.getDatasetType()) {
            case EXTERNAL: {
                return index.getIndexName().equals(BTreeDataflowHelperFactoryProvider.externalFileIndexName(dataset)) ? new ExternalBTreeDataflowHelperFactory(mergePolicyFactory, mergePolicyProperties, dataset.getIndexOperationTrackerFactory(index), storageComponentProvider.getIoOperationSchedulerProvider(), dataset.getIoOperationCallbackFactory(index), mdProvider.getStorageProperties().getBloomFilterFalsePositiveRate(), ExternalDatasetsRegistry.INSTANCE.getAndLockDatasetVersion(dataset, mdProvider), !dataset.getDatasetDetails().isTemp()) : new ExternalBTreeWithBuddyDataflowHelperFactory(mergePolicyFactory, mergePolicyProperties, dataset.getIndexOperationTrackerFactory(index), storageComponentProvider.getIoOperationSchedulerProvider(), dataset.getIoOperationCallbackFactory(index), mdProvider.getStorageProperties().getBloomFilterFalsePositiveRate(), new int[]{index.getKeyFieldNames().size()}, ExternalDatasetsRegistry.INSTANCE.getAndLockDatasetVersion(dataset, mdProvider), !dataset.getDatasetDetails().isTemp());
            }
            case INTERNAL: {
                return new LSMBTreeDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(dataset.getDatasetId()), mergePolicyFactory, mergePolicyProperties, dataset.getIndexOperationTrackerFactory(index), storageComponentProvider.getIoOperationSchedulerProvider(), dataset.getIoOperationCallbackFactory(index), mdProvider.getStorageProperties().getBloomFilterFalsePositiveRate(), index.isPrimaryIndex(), filterTypeTraits, filterCmpFactories, btreeFields, filterFields, !dataset.getDatasetDetails().isTemp());
            }
        }
        throw new CompilationException(1011, new Serializable[]{dataset.getDatasetType().toString()});
    }
}

