/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.INodeResolver;
import org.apache.asterix.runtime.utils.RuntimeUtils;

public class NodeResolver
implements INodeResolver {
    private static final Random random = new Random();
    private static final Map<InetAddress, Set<String>> ncMap = new HashMap<InetAddress, Set<String>>();
    private static final Set<String> ncs = new HashSet<String>();

    @Override
    public String resolveNode(String value) throws AsterixException {
        try {
            if (ncMap.isEmpty()) {
                NodeResolver.updateNCs();
            }
            if (ncs.contains(value)) {
                return value;
            }
            NodeResolver.updateNCs();
            if (ncs.contains(value)) {
                return value;
            }
            InetAddress ipAddress = null;
            try {
                ipAddress = InetAddress.getByName(value);
            }
            catch (UnknownHostException e) {
                throw new AsterixException(3032, (Throwable)e, new Serializable[]{value});
            }
            Set<String> nodeControllers = ncMap.get(ipAddress);
            if (nodeControllers == null || nodeControllers.isEmpty()) {
                throw new AsterixException(3031, new Serializable[]{value});
            }
            return nodeControllers.toArray(new String[0])[random.nextInt(nodeControllers.size())];
        }
        catch (Exception e) {
            throw new AsterixException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateNCs() throws Exception {
        Map<InetAddress, Set<String>> map = ncMap;
        synchronized (map) {
            ncMap.clear();
            RuntimeUtils.getNodeControllerMap(ncMap);
            Set<String> set = ncs;
            synchronized (set) {
                ncs.clear();
                for (Map.Entry<InetAddress, Set<String>> entry : ncMap.entrySet()) {
                    ncs.addAll((Collection<String>)entry.getValue());
                }
            }
        }
    }
}

