/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.Serializable;
import java.util.Map;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.ITupleForwarder;
import org.apache.asterix.external.dataflow.CounterTimerTupleForwarder;
import org.apache.asterix.external.dataflow.FeedTupleForwarder;
import org.apache.asterix.external.dataflow.FrameFullTupleForwarder;
import org.apache.asterix.external.dataflow.RateControlledTupleForwarder;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class DataflowUtils {
    public static void addTupleToFrame(FrameTupleAppender appender, ArrayTupleBuilder tb, IFrameWriter writer) throws HyracksDataException {
        if (!appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize())) {
            appender.write(writer, true);
            if (!appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize())) {
                throw new RuntimeDataException(3002, new Serializable[0]);
            }
        }
    }

    public static ITupleForwarder getTupleForwarder(Map<String, String> configuration, FeedLogManager feedLogManager) throws HyracksDataException {
        ITupleForwarder.TupleForwardPolicy policyType = null;
        String propValue = configuration.get("forward-policy");
        policyType = ExternalDataUtils.isFeed(configuration) ? ITupleForwarder.TupleForwardPolicy.FEED : (propValue == null ? ITupleForwarder.TupleForwardPolicy.FRAME_FULL : ITupleForwarder.TupleForwardPolicy.valueOf(propValue.trim().toUpperCase()));
        switch (policyType) {
            case FEED: {
                return new FeedTupleForwarder(feedLogManager);
            }
            case FRAME_FULL: {
                return new FrameFullTupleForwarder();
            }
            case COUNTER_TIMER_EXPIRED: {
                return CounterTimerTupleForwarder.create(configuration);
            }
            case RATE_CONTROLLED: {
                return RateControlledTupleForwarder.create(configuration);
            }
        }
        throw new RuntimeDataException(3003, new Serializable[0]);
    }

    public static void addTupleToFrame(FrameTupleAppender appender, ITupleReference tuple, IFrameWriter writer) throws HyracksDataException {
        if (!appender.append(tuple)) {
            appender.write(writer, true);
            if (!appender.append(tuple)) {
                throw new RuntimeDataException(3002, new Serializable[0]);
            }
        }
    }
}

