/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.provider;

import java.io.Serializable;
import java.util.Map;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.input.HDFSDataSourceFactory;
import org.apache.asterix.external.input.record.reader.rss.RSSRecordReaderFactory;
import org.apache.asterix.external.input.record.reader.stream.StreamRecordReaderFactory;
import org.apache.asterix.external.input.record.reader.twitter.TwitterRecordReaderFactory;
import org.apache.asterix.external.input.stream.factory.LocalFSInputStreamFactory;
import org.apache.asterix.external.input.stream.factory.SocketClientInputStreamFactory;
import org.apache.asterix.external.input.stream.factory.SocketServerInputStreamFactory;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class DatasourceFactoryProvider {
    private DatasourceFactoryProvider() {
    }

    public static IExternalDataSourceFactory getExternalDataSourceFactory(ILibraryManager libraryManager, Map<String, String> configuration) throws HyracksDataException {
        if (ExternalDataUtils.getDataSourceType(configuration).equals((Object)IExternalDataSourceFactory.DataSourceType.RECORDS)) {
            String reader = configuration.get("reader");
            return DatasourceFactoryProvider.getRecordReaderFactory(libraryManager, reader, configuration);
        }
        String streamSource = configuration.get("stream-source");
        return DatasourceFactoryProvider.getInputStreamFactory(libraryManager, streamSource, configuration);
    }

    public static IInputStreamFactory getInputStreamFactory(ILibraryManager libraryManager, String streamSource, Map<String, String> configuration) throws HyracksDataException {
        IInputStreamFactory streamSourceFactory;
        if (ExternalDataUtils.isExternal(streamSource)) {
            String dataverse = ExternalDataUtils.getDataverse(configuration);
            streamSourceFactory = ExternalDataUtils.createExternalInputStreamFactory(libraryManager, dataverse, streamSource);
        } else {
            switch (streamSource) {
                case "localfs": {
                    streamSourceFactory = new LocalFSInputStreamFactory();
                    break;
                }
                case "socket": 
                case "socket_adapter": {
                    streamSourceFactory = new SocketServerInputStreamFactory();
                    break;
                }
                case "socket-client": {
                    streamSourceFactory = new SocketServerInputStreamFactory();
                    break;
                }
                default: {
                    try {
                        streamSourceFactory = (IInputStreamFactory)Class.forName(streamSource).newInstance();
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeDataException(3023, (Throwable)e, new Serializable[]{streamSource});
                    }
                }
            }
        }
        return streamSourceFactory;
    }

    public static IRecordReaderFactory<?> getRecordReaderFactory(ILibraryManager libraryManager, String reader, Map<String, String> configuration) throws HyracksDataException {
        if (reader.equals("external")) {
            try {
                return ExternalDataUtils.createExternalRecordReaderFactory(libraryManager, configuration);
            }
            catch (AlgebricksException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        switch (reader) {
            case "hdfs": {
                return new HDFSDataSourceFactory();
            }
            case "localfs": {
                return new StreamRecordReaderFactory(new LocalFSInputStreamFactory());
            }
            case "twitter_pull": 
            case "twitter_push": 
            case "push_twitter": 
            case "pull_twitter": 
            case "twitter_user_stream": {
                try {
                    Class.forName("twitter4j.Twitter");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeDataException(3007, (Throwable)e, new Serializable[0]);
                }
                return new TwitterRecordReaderFactory();
            }
            case "socket_adapter": 
            case "socket": {
                return new StreamRecordReaderFactory(new SocketServerInputStreamFactory());
            }
            case "socket-client": {
                return new StreamRecordReaderFactory(new SocketClientInputStreamFactory());
            }
            case "rss_feed": {
                return new RSSRecordReaderFactory();
            }
        }
        try {
            return (IRecordReaderFactory)Class.forName(reader).newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeDataException(3025, (Throwable)e, new Serializable[]{reader});
        }
    }
}

