/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser.factory;

import java.io.Serializable;
import java.util.Map;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IStreamDataParser;
import org.apache.asterix.external.parser.DelimitedDataParser;
import org.apache.asterix.external.parser.factory.AbstractRecordStreamParserFactory;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;

public class DelimitedDataParserFactory
extends AbstractRecordStreamParserFactory<char[]> {
    private static final long serialVersionUID = 1L;
    private static String[] formats = new String[]{"csv", "delimited-text"};

    @Override
    public IRecordDataParser<char[]> createRecordParser(IHyracksTaskContext ctx) throws HyracksDataException {
        return this.createParser();
    }

    private DelimitedDataParser createParser() throws HyracksDataException {
        IValueParserFactory[] valueParserFactories = ExternalDataUtils.getValueParserFactories(this.recordType);
        Character delimiter = Character.valueOf(DelimitedDataParserFactory.getDelimiter(this.configuration));
        char quote = DelimitedDataParserFactory.getQuote(this.configuration, delimiter.charValue());
        boolean hasHeader = ExternalDataUtils.hasHeader(this.configuration);
        return new DelimitedDataParser(valueParserFactories, delimiter.charValue(), quote, hasHeader, this.recordType, ExternalDataUtils.getDataSourceType(this.configuration).equals((Object)IExternalDataSourceFactory.DataSourceType.STREAM));
    }

    @Override
    public Class<? extends char[]> getRecordClass() {
        return char[].class;
    }

    @Override
    public IStreamDataParser createInputStreamParser(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        return this.createParser();
    }

    public static char getDelimiter(Map<String, String> configuration) throws HyracksDataException {
        String delimiterValue = configuration.get("delimiter");
        if (delimiterValue == null) {
            delimiterValue = ",";
        } else if (delimiterValue.length() != 1) {
            throw new RuntimeDataException(3049, new Serializable[]{delimiterValue});
        }
        return delimiterValue.charAt(0);
    }

    public static char getQuote(Map<String, String> configuration, char delimiter) throws HyracksDataException {
        String quoteValue = configuration.get("quote");
        if (quoteValue == null) {
            quoteValue = "\"";
        } else if (quoteValue.length() != 1) {
            throw new RuntimeDataException(3050, new Serializable[]{quoteValue});
        }
        if (quoteValue.charAt(0) == delimiter) {
            throw new RuntimeDataException(3051, new Serializable[]{quoteValue, Character.valueOf(delimiter)});
        }
        return quoteValue.charAt(0);
    }

    @Override
    public void setMetaType(ARecordType metaType) {
    }

    @Override
    public String[] getFormats() {
        return formats;
    }
}

