/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.DataOutput;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.IResultCollector;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableOrderedList;
import org.apache.asterix.om.base.AMutableRecord;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IDataOutputProvider;

public class ResultCollector
implements IResultCollector {
    private IAObject reusableResultObjectHolder;
    private IDataOutputProvider outputProvider;
    private IExternalFunctionInfo finfo;

    public ResultCollector(IExternalFunctionInfo finfo, IDataOutputProvider outputProvider) {
        this.finfo = finfo;
        IAType returnType = finfo.getReturnType();
        this.reusableResultObjectHolder = this.allocateResultObjectHolder(returnType);
        this.outputProvider = outputProvider;
    }

    private IAObject allocateResultObjectHolder(IAType type) {
        switch (type.getTypeTag()) {
            case INT32: {
                return new AMutableInt32(0);
            }
            case FLOAT: {
                return new AMutableFloat(0.0f);
            }
            case DOUBLE: {
                return new AMutableDouble(0.0);
            }
            case STRING: {
                return new AMutableString("");
            }
            case ORDEREDLIST: {
                return new AMutableOrderedList((AOrderedListType)type);
            }
            case RECORD: {
                IAType[] fieldType = ((ARecordType)type).getFieldTypes();
                IAObject[] fieldObjects = new IAObject[fieldType.length];
                for (int i = 0; i < fieldType.length; ++i) {
                    fieldObjects[i] = this.allocateResultObjectHolder(fieldType[i]);
                }
                return new AMutableRecord((ARecordType)type, fieldObjects);
            }
        }
        return null;
    }

    @Override
    public void writeDoubleResult(double result) throws AsterixException {
        ((AMutableDouble)this.reusableResultObjectHolder).setValue(result);
        this.serializeResult(this.reusableResultObjectHolder);
    }

    @Override
    public void writeFloatResult(float result) throws AsterixException {
        ((AMutableDouble)this.reusableResultObjectHolder).setValue((double)result);
        this.serializeResult(this.reusableResultObjectHolder);
    }

    @Override
    public void writeIntResult(int result) throws AsterixException {
        ((AMutableInt32)this.reusableResultObjectHolder).setValue(result);
        this.serializeResult(this.reusableResultObjectHolder);
    }

    @Override
    public void writeStringResult(String result) throws AsterixException {
        ((AMutableString)this.reusableResultObjectHolder).setValue(result);
        this.serializeResult(this.reusableResultObjectHolder);
    }

    @Override
    public void writeRecordResult(ARecord result) throws AsterixException {
        this.serializeResult((IAObject)result);
    }

    @Override
    public void writeListResult(AOrderedList list) throws AsterixException {
        this.serializeResult((IAObject)list);
    }

    @Override
    public IAObject getComplexTypeResultHolder() {
        return this.reusableResultObjectHolder;
    }

    private void serializeResult(IAObject object) throws AsterixException {
        try {
            SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)this.finfo.getReturnType()).serialize((Object)this.reusableResultObjectHolder, this.outputProvider.getDataOutput());
        }
        catch (HyracksDataException hde) {
            throw new AsterixException((Throwable)hde);
        }
    }

    @Override
    public DataOutput getDataOutput() {
        return this.outputProvider.getDataOutput();
    }
}

