/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream.factory;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.input.stream.SocketServerInputStream;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class SocketServerInputStreamFactory
implements IInputStreamFactory {
    private static final long serialVersionUID = 1L;
    private List<Pair<String, Integer>> sockets;
    private Mode mode = Mode.IP;

    @Override
    public void configure(Map<String, String> configuration) throws AlgebricksException {
        try {
            String socketsValue;
            this.sockets = new ArrayList<Pair<String, Integer>>();
            String modeValue = configuration.get("address-type");
            if (modeValue != null) {
                this.mode = Mode.valueOf(modeValue.trim().toUpperCase());
            }
            if ((socketsValue = configuration.get("sockets")) == null) {
                throw new CompilationException(3081, new Serializable[0]);
            }
            Map ncMap = RuntimeUtils.getNodeControllerMap();
            List ncs = RuntimeUtils.getAllNodeControllers();
            String[] socketsArray = socketsValue.split(",");
            Random random = new Random();
            for (String socket : socketsArray) {
                String[] socketTokens = socket.split(":");
                String host = socketTokens[0].trim();
                int port = Integer.parseInt(socketTokens[1].trim());
                Pair p = null;
                switch (this.mode) {
                    case IP: {
                        Set ncsOnIp = (Set)ncMap.get(InetAddress.getByName(host));
                        if (ncsOnIp == null || ncsOnIp.isEmpty()) {
                            throw new CompilationException(3082, new Serializable[]{"host", host, StringUtils.join(ncMap.keySet(), (String)", ")});
                        }
                        String[] ncArray = ncsOnIp.toArray(new String[0]);
                        String nc = ncArray[random.nextInt(ncArray.length)];
                        p = new Pair((Object)nc, (Object)port);
                        break;
                    }
                    case NC: {
                        p = new Pair((Object)host, (Object)port);
                        if (ncs.contains(host)) break;
                        throw new CompilationException(3082, new Serializable[]{"NC", host, StringUtils.join((Iterable)ncs, (String)", ")});
                    }
                }
                this.sockets.add(p);
            }
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (UnknownHostException | HyracksDataException e) {
            throw new AsterixException(e);
        }
        catch (Exception e) {
            throw new CompilationException(3081, new Serializable[0]);
        }
    }

    @Override
    public synchronized AsterixInputStream createInputStream(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        try {
            Pair<String, Integer> socket = this.sockets.get(partition);
            ServerSocket server = new ServerSocket();
            server.bind(new InetSocketAddress((Integer)socket.second));
            return new SocketServerInputStream(server);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() {
        ArrayList<Object> locations = new ArrayList<Object>();
        for (Pair<String, Integer> socket : this.sockets) {
            locations.add(socket.first);
        }
        return new AlgebricksAbsolutePartitionConstraint(locations.toArray(new String[0]));
    }

    public List<Pair<String, Integer>> getSockets() {
        return this.sockets;
    }

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return IExternalDataSourceFactory.DataSourceType.STREAM;
    }

    @Override
    public boolean isIndexible() {
        return false;
    }

    public static enum Mode {
        NC,
        IP;

    }
}

