/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.log4j.Logger;

public class SocketServerInputStream
extends AsterixInputStream {
    private static final Logger LOGGER = Logger.getLogger((String)SocketServerInputStream.class.getName());
    private ServerSocket server;
    private Socket socket;
    private InputStream connectionStream;

    public SocketServerInputStream(ServerSocket server) {
        this.server = server;
        this.socket = new Socket();
        this.connectionStream = new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
    }

    @Override
    public int read() throws IOException {
        int read = this.connectionStream.read();
        while (read < 0) {
            this.accept();
            read = this.connectionStream.read();
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.server == null) {
            return -1;
        }
        int read = -1;
        try {
            if (this.connectionStream.available() < 1) {
                this.controller.flush();
            }
            read = this.connectionStream.read(b, off, len);
        }
        catch (IOException e) {
            LOGGER.info((Object)"Exhausted all pending connections. Waiting for new ones to come.");
            read = -1;
        }
        while (read < 0) {
            if (!this.accept()) {
                return -1;
            }
            try {
                read = this.connectionStream.read(b, off, len);
            }
            catch (IOException e) {
                e.printStackTrace();
                read = -1;
            }
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        return 0L;
    }

    @Override
    public int available() throws IOException {
        return 1;
    }

    @Override
    public synchronized void close() throws IOException {
        HyracksDataException hde = null;
        try {
            if (this.connectionStream != null) {
                this.connectionStream.close();
            }
            this.connectionStream = null;
        }
        catch (IOException e) {
            hde = HyracksDataException.create((Throwable)e);
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = null;
        }
        catch (IOException e) {
            hde = HyracksDataException.suppress((HyracksDataException)hde, (Throwable)e);
        }
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException e) {
            hde = HyracksDataException.suppress((HyracksDataException)hde, (Throwable)e);
        }
        finally {
            this.server = null;
        }
        if (hde != null) {
            throw hde;
        }
    }

    private boolean accept() throws IOException {
        try {
            this.connectionStream.close();
            this.connectionStream = null;
            this.socket.close();
            this.socket = null;
            this.socket = this.server.accept();
            this.connectionStream = this.socket.getInputStream();
            return true;
        }
        catch (Exception e) {
            this.close();
            return false;
        }
    }

    @Override
    public boolean stop() throws Exception {
        this.close();
        return true;
    }

    @Override
    public boolean handleException(Throwable th) {
        try {
            return this.accept();
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Failed accepting more connections", (Throwable)e);
            return false;
        }
    }
}

